/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.List;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.VillagerTrade;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundMerchantOffersPacket;

public class MerchantContainer
extends Container {
    private Entity villager;
    private List<VillagerTrade> villagerTrades;
    private ClientboundMerchantOffersPacket pendingOffersPacket;
    private int tradeExperience;

    public MerchantContainer(GeyserSession session, String title, int id, int size, ContainerType containerType, PlayerInventory playerInventory, InventoryTranslator translator) {
        super(session, title, id, size, containerType, playerInventory, translator);
    }

    public void onTradeSelected(GeyserSession session, int slot) {
        if (this.villagerTrades != null && slot >= 0 && slot < this.villagerTrades.size()) {
            VillagerTrade trade = this.villagerTrades.get(slot);
            this.setItem(2, GeyserItemStack.from(trade.getResult()), session);
            this.tradeExperience += trade.getXp();
            this.villager.getDirtyMetadata().put(EntityDataTypes.TRADE_EXPERIENCE, this.tradeExperience);
            this.villager.updateBedrockMetadata();
        }
    }

    public void setVillager(Entity villager) {
        this.villager = villager;
    }

    public void setVillagerTrades(List<VillagerTrade> villagerTrades) {
        this.villagerTrades = villagerTrades;
    }

    public void setPendingOffersPacket(ClientboundMerchantOffersPacket pendingOffersPacket) {
        this.pendingOffersPacket = pendingOffersPacket;
    }

    public void setTradeExperience(int tradeExperience) {
        this.tradeExperience = tradeExperience;
    }

    public Entity getVillager() {
        return this.villager;
    }

    public ClientboundMerchantOffersPacket getPendingOffersPacket() {
        return this.pendingOffersPacket;
    }

    public int getTradeExperience() {
        return this.tradeExperience;
    }
}

