/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public class PotionItem
extends Item {
    public PotionItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public ItemData.Builder translateToBedrock(GeyserSession session, int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        if (components == null) {
            return super.translateToBedrock(session, count, components, mapping, mappings);
        }
        PotionContents potionContents = (PotionContents)components.get(DataComponentTypes.POTION_CONTENTS);
        if (potionContents != null) {
            ItemDefinition customItemDefinition = CustomItemTranslator.getCustomItem(components, mapping);
            if (customItemDefinition == null) {
                Potion potion = Potion.getByJavaId(potionContents.getPotionId());
                if (potion != null) {
                    return ItemData.builder().definition(mapping.getBedrockDefinition()).damage((int)potion.getBedrockId()).count(count);
                }
                GeyserImpl.getInstance().getLogger().debug("Unknown Java potion: " + potionContents.getPotionId());
            } else {
                return ItemData.builder().definition(customItemDefinition).count(count);
            }
        }
        return super.translateToBedrock(session, count, components, mapping, mappings);
    }

    @Override
    public @NonNull GeyserItemStack translateToJava(GeyserSession session, @NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        Potion potion = Potion.getByBedrockId(itemData.getDamage());
        GeyserItemStack itemStack = super.translateToJava(session, itemData, mapping, mappings);
        if (potion != null) {
            itemStack.getOrCreateComponents().put(DataComponentTypes.POTION_CONTENTS, (Object)potion.toComponent());
        }
        return itemStack;
    }

    @Override
    public boolean ignoreDamage() {
        return true;
    }
}

