/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack.url;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.pack.PathPackCodec;
import org.geysermc.geyser.api.pack.UrlPackCodec;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.registry.loader.ResourcePackLoader;

public class GeyserUrlPackCodec
extends UrlPackCodec {
    private final @NonNull String url;
    private PathPackCodec fallback;

    public GeyserUrlPackCodec(@NonNull String url) throws IllegalArgumentException {
        Objects.requireNonNull(url);
        this.url = url;
    }

    @Override
    public byte @NonNull [] sha256() {
        Objects.requireNonNull(this.fallback, "must call #create() before attempting to get the sha256!");
        return this.fallback.sha256();
    }

    @Override
    public long size() {
        Objects.requireNonNull(this.fallback, "must call #create() before attempting to get the size!");
        return this.fallback.size();
    }

    @Override
    public @NonNull SeekableByteChannel serialize() throws IOException {
        Objects.requireNonNull(this.fallback, "must call #create() before attempting to serialize!!");
        return this.fallback.serialize();
    }

    @Override
    public @NonNull GeyserResourcePack create() {
        return this.createBuilder().build();
    }

    @Override
    protected @NonNull GeyserResourcePack.Builder createBuilder() {
        if (this.fallback == null) {
            ((CompletableFuture)((CompletableFuture)ResourcePackLoader.downloadPack(this.url, false).thenAccept(pack -> {
                this.fallback = pack;
            })).exceptionally(throwable -> {
                throw new IllegalStateException(throwable.getCause());
            })).join();
        }
        return ResourcePackLoader.readPack(this);
    }

    @Override
    public @NonNull String url() {
        return this.url;
    }

    public PathPackCodec getFallback() {
        return this.fallback;
    }
}

