/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector2l;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector4f;
import org.cloudburstmc.math.vector.VectorNf;
import org.cloudburstmc.math.vector.Vectorf;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector2f
implements Vectorf,
Comparable<Vector2f>,
Serializable,
Cloneable {
    public static final Vector2f ZERO = Vector2f.from(0.0f, 0.0f);
    public static final Vector2f UNIT_X = Vector2f.from(1.0f, 0.0f);
    public static final Vector2f UNIT_Y = Vector2f.from(0.0f, 1.0f);
    public static final Vector2f ONE = Vector2f.from(1.0f, 1.0f);

    public abstract float getX();

    public abstract float getY();

    public int getFloorX() {
        return GenericMath.floor(this.getX());
    }

    public int getFloorY() {
        return GenericMath.floor(this.getY());
    }

    @Nonnull
    public Vector2f add(Vector2f v) {
        return this.add(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f add(double x, double y) {
        return this.add((float)x, (float)y);
    }

    @Nonnull
    public abstract Vector2f add(float var1, float var2);

    @Nonnull
    public Vector2f sub(Vector2f v) {
        return this.sub(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f sub(double x, double y) {
        return this.sub((float)x, (float)y);
    }

    @Nonnull
    public abstract Vector2f sub(float var1, float var2);

    @Nonnull
    public Vector2f mul(double a) {
        return this.mul((float)a);
    }

    @Override
    @Nonnull
    public Vector2f mul(float a) {
        return this.mul(a, a);
    }

    @Nonnull
    public Vector2f mul(Vector2f v) {
        return this.mul(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f mul(double x, double y) {
        return this.mul((float)x, (float)y);
    }

    @Nonnull
    public abstract Vector2f mul(float var1, float var2);

    @Nonnull
    public Vector2f div(double a) {
        return this.div((float)a);
    }

    @Override
    @Nonnull
    public Vector2f div(float a) {
        return this.div(a, a);
    }

    @Nonnull
    public Vector2f div(Vector2f v) {
        return this.div(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f div(double x, double y) {
        return this.div((float)x, (float)y);
    }

    @Nonnull
    public abstract Vector2f div(float var1, float var2);

    public float dot(Vector2f v) {
        return this.dot(v.getX(), v.getY());
    }

    public float dot(double x, double y) {
        return this.dot((float)x, (float)y);
    }

    public float dot(float x, float y) {
        return this.getX() * x + this.getY() * y;
    }

    @Nonnull
    public Vector2f project(Vector2f v) {
        return this.project(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f project(double x, double y) {
        return this.project((float)x, (float)y);
    }

    @Nonnull
    public abstract Vector2f project(float var1, float var2);

    @Nonnull
    public Vector2f pow(double pow) {
        return this.pow((float)pow);
    }

    @Override
    @Nonnull
    public abstract Vector2f pow(float var1);

    @Override
    @Nonnull
    public abstract Vector2f ceil();

    @Override
    @Nonnull
    public abstract Vector2f floor();

    @Override
    @Nonnull
    public abstract Vector2f round();

    @Override
    @Nonnull
    public abstract Vector2f abs();

    @Override
    @Nonnull
    public abstract Vector2f negate();

    @Nonnull
    public Vector2f min(Vector2f v) {
        return this.min(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f min(double x, double y) {
        return this.min((float)x, (float)y);
    }

    @Nonnull
    public abstract Vector2f min(float var1, float var2);

    @Nonnull
    public Vector2f max(Vector2f v) {
        return this.max(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2f max(double x, double y) {
        return this.max((float)x, (float)y);
    }

    @Nonnull
    public abstract Vector2f max(float var1, float var2);

    public float distanceSquared(Vector2f v) {
        return this.distanceSquared(v.getX(), v.getY());
    }

    public float distanceSquared(double x, double y) {
        return this.distanceSquared((float)x, (float)y);
    }

    public float distanceSquared(float x, float y) {
        float dx = this.getX() - x;
        float dy = this.getY() - y;
        return dx * dx + dy * dy;
    }

    public float distance(Vector2f v) {
        return this.distance(v.getX(), v.getY());
    }

    public float distance(double x, double y) {
        return this.distance((float)x, (float)y);
    }

    public float distance(float x, float y) {
        return (float)Math.sqrt(this.distanceSquared(x, y));
    }

    @Nonnull
    public Vector2f north() {
        return this.north(1.0f);
    }

    @Nonnull
    public abstract Vector2f north(float var1);

    @Nonnull
    public Vector2f south() {
        return this.south(1.0f);
    }

    @Nonnull
    public abstract Vector2f south(float var1);

    @Nonnull
    public Vector2f east() {
        return this.east(1.0f);
    }

    @Nonnull
    public abstract Vector2f east(float var1);

    @Nonnull
    public Vector2f west() {
        return this.west(1.0f);
    }

    @Nonnull
    public abstract Vector2f west(float var1);

    @Override
    public float lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    @Nonnull
    public abstract Vector2f normalize();

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? 0 : 1;
    }

    @Override
    public int getMaxAxis() {
        return this.getX() > this.getY() ? 0 : 1;
    }

    @Nonnull
    public Vector3f toVector3() {
        return this.toVector3(0.0f);
    }

    @Nonnull
    public Vector3f toVector3(double z) {
        return this.toVector3((float)z);
    }

    @Nonnull
    public Vector3f toVector3(float z) {
        return Vector3f.from(this, z);
    }

    @Nonnull
    public Vector4f toVector4() {
        return this.toVector4(0.0f, 0.0f);
    }

    @Nonnull
    public Vector4f toVector4(double z, double w) {
        return this.toVector4((float)z, (float)w);
    }

    @Nonnull
    public Vector4f toVector4(float z, float w) {
        return Vector4f.from(this, z, w);
    }

    @Nonnull
    public VectorNf toVectorN() {
        return VectorNf.from(this);
    }

    @Override
    @Nonnull
    public float[] toArray() {
        return new float[]{this.getX(), this.getY()};
    }

    @Override
    @Nonnull
    public Vector2i toInt() {
        return Vector2i.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2l toLong() {
        return Vector2l.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2f toFloat() {
        return Vector2f.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2d toDouble() {
        return Vector2d.from(this.getX(), this.getY());
    }

    @Override
    public int compareTo(Vector2f v) {
        return (int)Math.signum(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector2f clone() {
        return Vector2f.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ")";
    }

    @Nonnull
    public static Vector2f from(float n) {
        return Vectors.createVector2f(n, n);
    }

    @Nonnull
    public static Vector2f from(Vector2f v) {
        return Vector2f.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2f from(Vector3f v) {
        return Vector2f.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2f from(Vector4f v) {
        return Vector2f.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2f from(VectorNf v) {
        return Vector2f.from(v.get(0), v.get(1));
    }

    @Nonnull
    public static Vector2f from(double x, double y) {
        return Vector2f.from((float)x, (float)y);
    }

    @Nonnull
    public static Vector2f from(float x, float y) {
        return Vectors.createVector2f(x, y);
    }

    @Nonnull
    public static Vector2f createRandomDirection(Random random) {
        return Vector2f.createDirectionRad(random.nextFloat() * ((float)Math.PI * 2));
    }

    @Nonnull
    public static Vector2f createDirectionDeg(double angle) {
        return Vector2f.createDirectionDeg((float)angle);
    }

    @Nonnull
    public static Vector2f createDirectionDeg(float angle) {
        return Vector2f.createDirectionRad((float)Math.toRadians(angle));
    }

    @Nonnull
    public static Vector2f createDirectionRad(double angle) {
        return Vector2f.createDirectionRad((float)angle);
    }

    @Nonnull
    public static Vector2f createDirectionRad(float angle) {
        return Vector2f.from(TrigMath.cos(angle), TrigMath.sin(angle));
    }
}

