/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser;

import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.level.GeyserWorldManager;
import org.geysermc.geyser.level.WorldManager;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;

public interface GeyserBootstrap {
    public static final GeyserWorldManager DEFAULT_CHUNK_MANAGER = new GeyserWorldManager();

    public void onGeyserInitialize();

    public void onGeyserEnable();

    public void onGeyserDisable();

    public void onGeyserShutdown();

    public GeyserConfiguration getGeyserConfig();

    public GeyserLogger getGeyserLogger();

    public CommandRegistry getCommandRegistry();

    public @Nullable IGeyserPingPassthrough getGeyserPingPassthrough();

    default public WorldManager getWorldManager() {
        return DEFAULT_CHUNK_MANAGER;
    }

    public Path getConfigFolder();

    default public Path getSavedUserLoginsFolder() {
        return this.getConfigFolder();
    }

    public BootstrapDumpInfo getDumpInfo();

    default public @Nullable String getMinecraftServerVersion() {
        return null;
    }

    default public @Nullable SocketAddress getSocketAddress() {
        return null;
    }

    default public Path getLogsPath() {
        return Paths.get("logs/latest.log", new String[0]);
    }

    public @NonNull String getServerPlatform();

    default public @Nullable InputStream getResourceOrNull(String resource) {
        return GeyserBootstrap.class.getClassLoader().getResourceAsStream(resource);
    }

    default public @NonNull InputStream getResourceOrThrow(@NonNull String resource) {
        InputStream stream = this.getResourceOrNull(resource);
        if (stream == null) {
            throw new AssertionError((Object)("Unable to find resource: " + resource));
        }
        return stream;
    }

    public @NonNull String getServerBindAddress();

    public int getServerPort();

    public boolean testFloodgatePluginPresent();
}

