/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.RecipeUnlockingRequirement;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.SmithingTransformRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.InventoryHolder;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserSmithingRecipe;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.SmithingInventoryTranslator;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.ItemStackSlotDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SlotDisplay;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundContainerSetSlotPacket;

@Translator(packet=ClientboundContainerSetSlotPacket.class)
public class JavaContainerSetSlotTranslator
extends PacketTranslator<ClientboundContainerSetSlotPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundContainerSetSlotPacket packet) {
        InventoryHolder<?> holder = InventoryUtils.getInventory(session, packet.getContainerId());
        if (holder == null) {
            return;
        }
        Object inventory = holder.inventory();
        int slot = packet.getSlot();
        if (slot < 0 || slot >= ((Inventory)inventory).getSize()) {
            GeyserLogger logger = session.getGeyser().getLogger();
            logger.warning("Slot of ClientboundContainerSetSlotPacket sent to " + session.bedrockUsername() + " is out of bounds! Was: " + slot + " for container: " + packet.getContainerId());
            if (logger.isDebug()) {
                logger.debug(packet.toString());
                logger.debug(((Inventory)inventory).toString());
            }
            return;
        }
        if (holder.translator() instanceof SmithingInventoryTranslator) {
            JavaContainerSetSlotTranslator.updateSmithingTableOutput(slot, packet.getItem(), holder);
        } else {
            JavaContainerSetSlotTranslator.updateCraftingGrid(slot, packet.getItem(), holder);
        }
        GeyserItemStack newItem = GeyserItemStack.from(packet.getItem());
        session.getBundleCache().initialize(newItem);
        ((Inventory)holder.inventory()).setItem(slot, newItem, session);
        holder.updateSlot(slot);
        int stateId = packet.getStateId();
        session.setEmulatePost1_16Logic(stateId > 0 || stateId != ((Inventory)inventory).getStateId());
        ((Inventory)inventory).setStateId(stateId);
    }

    private static void updateCraftingGrid(int slot, ItemStack item, InventoryHolder<? extends Inventory> holder) {
        if (slot != 0) {
            return;
        }
        int gridSize = holder.translator().getGridSize();
        if (gridSize == -1) {
            return;
        }
        GeyserSession session = holder.session();
        if (session.getContainerOutputFuture() != null) {
            session.getContainerOutputFuture().cancel(false);
        }
        if (InventoryUtils.isEmpty(item)) {
            return;
        }
        session.setContainerOutputFuture(session.scheduleInEventLoop(() -> {
            InventorySlotPacket slotPacket;
            int offset = gridSize == 4 ? 28 : 32;
            int gridDimensions = gridSize == 4 ? 2 : 3;
            int firstRow = -1;
            int height = -1;
            int firstCol = -1;
            int width = -1;
            for (int row = 0; row < gridDimensions; ++row) {
                for (int col = 0; col < gridDimensions; ++col) {
                    if (((Inventory)holder.inventory()).getItem(col + row * gridDimensions + 1).isEmpty()) continue;
                    if (firstRow == -1) {
                        firstRow = row;
                        firstCol = col;
                    } else {
                        firstCol = Math.min(firstCol, col);
                    }
                    height = Math.max(height, row);
                    width = Math.max(width, col);
                }
            }
            if (firstRow == -1) {
                return;
            }
            if (InventoryUtils.getValidRecipe(session, item, arg_0 -> holder.inventory().getItem(arg_0), gridDimensions, firstRow, height += -firstRow + 1, firstCol, width += -firstCol + 1) != null) {
                return;
            }
            UUID uuid = UUID.randomUUID();
            int newRecipeId = session.getLastRecipeNetId().incrementAndGet();
            ItemData[] ingredients = new ItemData[height * width];
            ArrayList<SlotDisplay> javaIngredients = new ArrayList<SlotDisplay>(height * width);
            int index = 0;
            for (int row = firstRow; row < height + firstRow; ++row) {
                for (int col = firstCol; col < width + firstCol; ++col) {
                    GeyserItemStack geyserItemStack = ((Inventory)holder.inventory()).getItem(col + row * gridDimensions + 1);
                    ingredients[index] = geyserItemStack.getItemData(session);
                    javaIngredients.add(geyserItemStack.asSlotDisplay());
                    slotPacket = new InventorySlotPacket();
                    slotPacket.setContainerId(124);
                    slotPacket.setSlot(col + row * gridDimensions + offset);
                    slotPacket.setItem(ItemData.AIR);
                    session.sendUpstreamPacket(slotPacket);
                    ++index;
                }
            }
            session.getCraftingRecipes().put(newRecipeId, (GeyserRecipe)new GeyserShapedRecipe(width, height, javaIngredients, new ItemStackSlotDisplay(item)));
            CraftingDataPacket craftPacket = new CraftingDataPacket();
            craftPacket.getCraftingData().add(ShapedRecipeData.shaped(uuid.toString(), width, height, Arrays.stream(ingredients).map(ItemDescriptorWithCount::fromItem).toList(), Collections.singletonList(ItemTranslator.translateToBedrock(session, item)), uuid, "crafting_table", 0, newRecipeId, false, RecipeUnlockingRequirement.INVALID));
            craftPacket.setCleanRecipes(false);
            session.sendUpstreamPacket(craftPacket);
            index = 0;
            for (int row = firstRow; row < height + firstRow; ++row) {
                for (int col = firstCol; col < width + firstCol; ++col) {
                    slotPacket = new InventorySlotPacket();
                    slotPacket.setContainerId(124);
                    slotPacket.setSlot(col + row * gridDimensions + offset);
                    slotPacket.setItem(ingredients[index]);
                    session.sendUpstreamPacket(slotPacket);
                    ++index;
                }
            }
        }, 150L, TimeUnit.MILLISECONDS));
    }

    static void updateSmithingTableOutput(int slot, ItemStack output, InventoryHolder<?> holder) {
        if (slot != 3) {
            return;
        }
        GeyserSession session = holder.session();
        if (session.getContainerOutputFuture() != null) {
            session.getContainerOutputFuture().cancel(false);
        }
        if (InventoryUtils.isEmpty(output)) {
            return;
        }
        Object inventory = holder.inventory();
        session.setContainerOutputFuture(session.scheduleInEventLoop(() -> {
            GeyserItemStack template = inventory.getItem(0);
            if (!template.is(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE)) {
                return;
            }
            GeyserItemStack input = inventory.getItem(1);
            GeyserItemStack material = inventory.getItem(2);
            GeyserItemStack geyserOutput = GeyserItemStack.from(output);
            for (GeyserSmithingRecipe recipe : session.getSmithingRecipes()) {
                if (!InventoryUtils.acceptsAsInput(session, recipe.result(), geyserOutput) || !InventoryUtils.acceptsAsInput(session, recipe.base(), input) || !InventoryUtils.acceptsAsInput(session, recipe.addition(), material) || !InventoryUtils.acceptsAsInput(session, recipe.template(), template)) continue;
                return;
            }
            session.getSmithingRecipes().add(new GeyserSmithingRecipe(template.asSlotDisplay(), input.asSlotDisplay(), material.asSlotDisplay(), new ItemStackSlotDisplay(output)));
            UUID uuid = UUID.randomUUID();
            CraftingDataPacket craftPacket = new CraftingDataPacket();
            craftPacket.getCraftingData().add(SmithingTransformRecipeData.of(uuid.toString(), ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, template.getItemStack())), ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, input.getItemStack())), ItemDescriptorWithCount.fromItem(ItemTranslator.translateToBedrock(session, material.getItemStack())), ItemTranslator.translateToBedrock(session, output), "smithing_table", session.getLastRecipeNetId().incrementAndGet()));
            craftPacket.setCleanRecipes(false);
            session.sendUpstreamPacket(craftPacket);
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(holder.translator().javaSlotToBedrock(2));
            slotPacket.setItem(ItemData.AIR);
            session.sendUpstreamPacket(slotPacket);
            holder.updateSlot(2);
        }, 150L, TimeUnit.MILLISECONDS));
    }
}

