/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.jetbrains.annotations.Range;

public class PlayerInventory
extends Inventory {
    private int heldItemSlot = 0;
    private @NonNull GeyserItemStack cursor = GeyserItemStack.EMPTY;

    public PlayerInventory() {
        super(0, 46, null);
    }

    @Override
    public int getOffsetForHotbar(@Range(from=0L, to=8L) int slot) {
        return slot + 36;
    }

    public void setCursor(@NonNull GeyserItemStack newCursor, GeyserSession session) {
        PlayerInventory.updateItemNetId(this.cursor, newCursor, session);
        this.cursor = newCursor;
    }

    public boolean isHolding(@NonNull Item item) {
        return this.getItemInHand().asItem() == item || this.getOffhand().asItem() == item;
    }

    public GeyserItemStack getItemInHand(@NonNull Hand hand) {
        return hand == Hand.OFF_HAND ? this.getOffhand() : this.getItemInHand();
    }

    public GeyserItemStack getItemInHand() {
        if (36 + this.heldItemSlot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Held item slot was larger than expected!");
            return GeyserItemStack.EMPTY;
        }
        return this.items[36 + this.heldItemSlot];
    }

    public boolean eitherHandMatchesItem(@NonNull Item item) {
        return this.getItemInHand().asItem() == item || this.getItemInHand(Hand.OFF_HAND).asItem() == item;
    }

    public void setItemInHand(@NonNull GeyserItemStack item) {
        if (36 + this.heldItemSlot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Held item slot was larger than expected!");
            return;
        }
        this.items[36 + this.heldItemSlot] = item;
    }

    public GeyserItemStack getOffhand() {
        return this.items[45];
    }

    public int getHeldItemSlot() {
        return this.heldItemSlot;
    }

    public void setHeldItemSlot(int heldItemSlot) {
        this.heldItemSlot = heldItemSlot;
    }

    public @NonNull GeyserItemStack getCursor() {
        return this.cursor;
    }
}

