/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class ServerboundChangeGameModePacket
implements MinecraftPacket {
    private final GameMode mode;

    public ServerboundChangeGameModePacket(ByteBuf in) {
        this.mode = GameMode.byId(MinecraftTypes.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.mode.ordinal());
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public GameMode getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChangeGameModePacket)) {
            return false;
        }
        ServerboundChangeGameModePacket other = (ServerboundChangeGameModePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GameMode this$mode = this.getMode();
        GameMode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundChangeGameModePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GameMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundChangeGameModePacket(mode=" + String.valueOf(this.getMode()) + ")";
    }

    public @NonNull ServerboundChangeGameModePacket withMode(GameMode mode) {
        return this.mode == mode ? this : new ServerboundChangeGameModePacket(mode);
    }

    public ServerboundChangeGameModePacket(GameMode mode) {
        this.mode = mode;
    }
}

