/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import com.google.common.hash.HashCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.kyori.adventure.key.Key;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.hashing.ComponentHasher;
import org.geysermc.geyser.item.hashing.DataComponentHashers;
import org.geysermc.geyser.item.hashing.MapBuilder;
import org.geysermc.geyser.item.hashing.MinecraftHashEncoder;
import org.geysermc.geyser.item.hashing.MinecraftHasher;
import org.geysermc.geyser.item.hashing.data.ConsumeEffectType;
import org.geysermc.geyser.item.hashing.data.FireworkExplosionShape;
import org.geysermc.geyser.item.hashing.data.ItemContainerSlot;
import org.geysermc.geyser.item.hashing.data.entity.AxolotlVariant;
import org.geysermc.geyser.item.hashing.data.entity.FoxVariant;
import org.geysermc.geyser.item.hashing.data.entity.HorseVariant;
import org.geysermc.geyser.item.hashing.data.entity.LlamaVariant;
import org.geysermc.geyser.item.hashing.data.entity.MooshroomVariant;
import org.geysermc.geyser.item.hashing.data.entity.ParrotVariant;
import org.geysermc.geyser.item.hashing.data.entity.RabbitVariant;
import org.geysermc.geyser.item.hashing.data.entity.SalmonVariant;
import org.geysermc.geyser.item.hashing.data.entity.TropicalFishPattern;
import org.geysermc.geyser.item.hashing.data.entity.VillagerVariant;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.ModifierOperation;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ArmorTrim;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BannerPatternLayer;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BeehiveOccupant;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BlocksAttacks;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Consumable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ConsumeEffect;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Fireworks;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.InstrumentComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemAttributeModifiers;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.JukeboxPlayable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectDetails;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectInstance;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ProvidesTrimMaterial;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.SuspiciousStewEffect;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Unit;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.CustomSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public interface RegistryHasher<DirectType>
extends MinecraftHasher<Integer> {
    public static final RegistryHasher<?> BLOCK = RegistryHasher.registry(JavaRegistries.BLOCK);
    public static final RegistryHasher<?> ITEM = RegistryHasher.registry(JavaRegistries.ITEM);
    public static final RegistryHasher<?> ENTITY_TYPE = RegistryHasher.enumIdRegistry((Enum[])EntityType.values());
    public static final RegistryHasher<?> ENCHANTMENT = RegistryHasher.registry(JavaRegistries.ENCHANTMENT);
    public static final RegistryHasher<?> ATTRIBUTE = RegistryHasher.enumIdRegistry((Enum[])AttributeType.Builtin.values(), AttributeType::getIdentifier);
    public static final MinecraftHasher<DataComponentType<?>> DATA_COMPONENT_TYPE = KEY.cast(DataComponentType::getKey);
    public static final MinecraftHasher<Effect> EFFECT = RegistryHasher.enumRegistry();
    public static final RegistryHasher<?> EFFECT_ID = RegistryHasher.enumIdRegistry((Enum[])Effect.values());
    public static final RegistryHasher<?> POTION = RegistryHasher.enumIdRegistry((Enum[])Potion.values());
    public static final RegistryHasher<?> VILLAGER_TYPE = RegistryHasher.enumIdRegistry((Enum[])VillagerVariant.values());
    public static final MinecraftHasher<BuiltinSound> BUILTIN_SOUND = KEY.cast(sound -> MinecraftKey.key(sound.getName()));
    public static final MinecraftHasher<CustomSound> CUSTOM_SOUND = MinecraftHasher.mapBuilder(builder -> builder.accept("sound_id", KEY, sound -> MinecraftKey.key(sound.getName())).optional("range", FLOAT, CustomSound::getRange, Float.valueOf(16.0f)));
    public static final MinecraftHasher<Sound> SOUND_EVENT = (sound, encoder) -> {
        if (sound instanceof BuiltinSound) {
            BuiltinSound builtin = (BuiltinSound)sound;
            return BUILTIN_SOUND.hash(builtin, encoder);
        }
        return CUSTOM_SOUND.hash((CustomSound)sound, encoder);
    };
    public static final RegistryHasher<?> DAMAGE_TYPE = RegistryHasher.registry(JavaRegistries.DAMAGE_TYPE);
    public static final MinecraftHasher<InstrumentComponent.Instrument> DIRECT_INSTRUMENT = MinecraftHasher.mapBuilder(builder -> builder.accept("sound_event", SOUND_EVENT, InstrumentComponent.Instrument::soundEvent).accept("use_duration", FLOAT, InstrumentComponent.Instrument::useDuration).accept("range", FLOAT, InstrumentComponent.Instrument::range).accept("description", ComponentHasher.COMPONENT, InstrumentComponent.Instrument::description));
    public static final RegistryHasher<InstrumentComponent.Instrument> INSTRUMENT = RegistryHasher.registry(JavaRegistries.INSTRUMENT, DIRECT_INSTRUMENT);
    public static final MinecraftHasher<ArmorTrim.TrimMaterial> DIRECT_TRIM_MATERIAL = MinecraftHasher.mapBuilder(builder -> builder.accept("asset_name", MinecraftHasher.STRING, ArmorTrim.TrimMaterial::assetBase).optional("override_armor_assets", MinecraftHasher.map(KEY, STRING), ArmorTrim.TrimMaterial::assetOverrides, Map.of()).accept("description", ComponentHasher.COMPONENT, ArmorTrim.TrimMaterial::description));
    public static final RegistryHasher<ArmorTrim.TrimMaterial> TRIM_MATERIAL = RegistryHasher.registry(JavaRegistries.TRIM_MATERIAL, DIRECT_TRIM_MATERIAL);
    public static final MinecraftHasher<ArmorTrim.TrimPattern> DIRECT_TRIM_PATTERN = MinecraftHasher.mapBuilder(builder -> builder.accept("asset_id", KEY, ArmorTrim.TrimPattern::assetId).accept("description", ComponentHasher.COMPONENT, ArmorTrim.TrimPattern::description).accept("decal", BOOL, ArmorTrim.TrimPattern::decal));
    public static final RegistryHasher<ArmorTrim.TrimPattern> TRIM_PATTERN = RegistryHasher.registry(JavaRegistries.TRIM_PATTERN, DIRECT_TRIM_PATTERN);
    public static final MinecraftHasher<JukeboxPlayable.JukeboxSong> DIRECT_JUKEBOX_SONG = MinecraftHasher.mapBuilder(builder -> builder.accept("sound_event", SOUND_EVENT, JukeboxPlayable.JukeboxSong::soundEvent).accept("description", ComponentHasher.COMPONENT, JukeboxPlayable.JukeboxSong::description).accept("length_in_seconds", FLOAT, JukeboxPlayable.JukeboxSong::lengthInSeconds).accept("comparator_output", INT, JukeboxPlayable.JukeboxSong::comparatorOutput));
    public static final RegistryHasher<JukeboxPlayable.JukeboxSong> JUKEBOX_SONG = RegistryHasher.registry(JavaRegistries.JUKEBOX_SONG, DIRECT_JUKEBOX_SONG);
    public static final MinecraftHasher<BannerPatternLayer.BannerPattern> DIRECT_BANNER_PATTERN = MinecraftHasher.mapBuilder(builder -> builder.accept("asset_id", KEY, BannerPatternLayer.BannerPattern::getAssetId).accept("translation_key", STRING, BannerPatternLayer.BannerPattern::getTranslationKey));
    public static final RegistryHasher<BannerPatternLayer.BannerPattern> BANNER_PATTERN = RegistryHasher.registry(JavaRegistries.BANNER_PATTERN, DIRECT_BANNER_PATTERN);
    public static final RegistryHasher<?> WOLF_VARIANT = RegistryHasher.registry(JavaRegistries.WOLF_VARIANT);
    public static final RegistryHasher<?> WOLF_SOUND_VARIANT = RegistryHasher.registry(JavaRegistries.WOLF_SOUND_VARIANT);
    public static final RegistryHasher<?> PIG_VARIANT = RegistryHasher.registry(JavaRegistries.PIG_VARIANT);
    public static final RegistryHasher<?> COW_VARIANT = RegistryHasher.registry(JavaRegistries.COW_VARIANT);
    public static final RegistryHasher<?> FROG_VARIANT = RegistryHasher.registry(JavaRegistries.FROG_VARIANT);
    public static final RegistryHasher<?> PAINTING_VARIANT = RegistryHasher.registry(JavaRegistries.PAINTING_VARIANT);
    public static final RegistryHasher<?> CAT_VARIANT = RegistryHasher.registry(JavaRegistries.CAT_VARIANT);
    public static final MinecraftHasher<Integer> FOX_VARIANT = MinecraftHasher.fromIdEnum((Enum[])FoxVariant.values());
    public static final MinecraftHasher<Integer> SALMON_VARIANT = MinecraftHasher.fromIdEnum((Enum[])SalmonVariant.values());
    public static final MinecraftHasher<Integer> PARROT_VARIANT = MinecraftHasher.fromIdEnum((Enum[])ParrotVariant.values());
    public static final MinecraftHasher<Integer> TROPICAL_FISH_PATTERN = MinecraftHasher.fromEnum().cast(TropicalFishPattern::fromPackedId);
    public static final MinecraftHasher<Integer> MOOSHROOM_VARIANT = MinecraftHasher.fromIdEnum((Enum[])MooshroomVariant.values());
    public static final MinecraftHasher<Integer> RABBIT_VARIANT = MinecraftHasher.fromEnum().cast(RabbitVariant::fromId);
    public static final MinecraftHasher<Integer> HORSE_VARIANT = MinecraftHasher.fromIdEnum((Enum[])HorseVariant.values());
    public static final MinecraftHasher<Integer> LLAMA_VARIANT = MinecraftHasher.fromIdEnum((Enum[])LlamaVariant.values());
    public static final MinecraftHasher<Integer> AXOLOTL_VARIANT = MinecraftHasher.fromIdEnum((Enum[])AxolotlVariant.values());
    public static final MinecraftHasher<DataComponent<?, ?>> DATA_COMPONENT_KEY = MinecraftHasher.either(KEY, component -> component.getValue() == null ? null : ((DataComponentType)component.getType()).getKey(), KEY_REMOVAL, component -> ((DataComponentType)component.getType()).getKey());
    public static final MinecraftHasher<DataComponent<?, ?>> DATA_COMPONENT_VALUE = (component, encoder) -> {
        if (component.getValue() == null) {
            return UNIT.hash(Unit.INSTANCE, encoder);
        }
        MinecraftHasher hasher = DataComponentHashers.hasher(component.getType());
        return hasher.hash(component.getValue(), encoder);
    };
    public static final MinecraftHasher<DataComponents> DATA_COMPONENTS = MinecraftHasher.mapSet(DATA_COMPONENT_KEY, DATA_COMPONENT_VALUE).cast(components -> components.getDataComponents().values());
    public static final MinecraftHasher<ItemStack> ITEM_STACK = MinecraftHasher.mapBuilder(builder -> builder.accept("id", ITEM, ItemStack::getId).accept("count", INT, ItemStack::getAmount).optionalNullable("components", DATA_COMPONENTS, ItemStack::getDataComponentsPatch));
    public static final MapBuilder<MobEffectDetails> MOB_EFFECT_DETAILS = builder -> builder.optional("amplifier", BYTE, instance -> (byte)instance.getAmplifier(), (byte)0).optional("duration", INT, MobEffectDetails::getDuration, 0).optional("ambient", BOOL, MobEffectDetails::isAmbient, false).optional("show_particles", BOOL, MobEffectDetails::isShowParticles, true).accept("show_icon", BOOL, MobEffectDetails::isShowIcon);
    public static final MinecraftHasher<MobEffectInstance> MOB_EFFECT_INSTANCE = MinecraftHasher.mapBuilder(builder -> builder.accept("id", EFFECT, MobEffectInstance::getEffect).accept(MOB_EFFECT_DETAILS, MobEffectInstance::getDetails));
    public static final MinecraftHasher<ModifierOperation> ATTRIBUTE_MODIFIER_OPERATION = MinecraftHasher.fromEnum(operation -> switch (operation) {
        default -> throw new IncompatibleClassChangeError();
        case ModifierOperation.ADD -> "add_value";
        case ModifierOperation.ADD_MULTIPLIED_BASE -> "add_multiplied_base";
        case ModifierOperation.ADD_MULTIPLIED_TOTAL -> "add_multiplied_total";
    });
    public static final MinecraftHasher<ItemEnchantments> ITEM_ENCHANTMENTS = MinecraftHasher.map(ENCHANTMENT, MinecraftHasher.INT).cast(ItemEnchantments::getEnchantments);
    public static final MinecraftHasher<ItemContainerSlot> CONTAINER_SLOT = MinecraftHasher.mapBuilder(builder -> builder.accept("slot", INT, ItemContainerSlot::index).accept("item", ITEM_STACK, ItemContainerSlot::item));
    public static final MinecraftHasher<List<ItemStack>> ITEM_CONTAINER_CONTENTS = CONTAINER_SLOT.list().cast(stacks -> {
        ArrayList<ItemContainerSlot> slots = new ArrayList<ItemContainerSlot>();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            if (stack == null) continue;
            slots.add(new ItemContainerSlot(i, (ItemStack)stacks.get(i)));
        }
        return slots;
    });
    public static final MinecraftHasher<AdventureModePredicate.BlockPredicate> BLOCK_PREDICATE = MinecraftHasher.mapBuilder(builder -> builder.optionalNullable("blocks", BLOCK.holderSet(), AdventureModePredicate.BlockPredicate::getBlocks).optionalNullable("nbt", NBT_MAP, AdventureModePredicate.BlockPredicate::getNbt));
    public static final MinecraftHasher<AdventureModePredicate> ADVENTURE_MODE_PREDICATE = MinecraftHasher.either(BLOCK_PREDICATE, predicate -> predicate.getPredicates().size() == 1 ? predicate.getPredicates().get(0) : null, BLOCK_PREDICATE.list(), AdventureModePredicate::getPredicates);
    public static final MinecraftHasher<ItemAttributeModifiers.DisplayType> ATTRIBUTE_MODIFIER_DISPLAY_TYPE = MinecraftHasher.fromEnum();
    public static final MinecraftHasher<ItemAttributeModifiers.Display> ATTRIBUTE_MODIFIER_DISPLAY = ATTRIBUTE_MODIFIER_DISPLAY_TYPE.dispatch(ItemAttributeModifiers.Display::getType, displayType -> switch (displayType) {
        default -> throw new IncompatibleClassChangeError();
        case ItemAttributeModifiers.DisplayType.DEFAULT, ItemAttributeModifiers.DisplayType.HIDDEN -> MapBuilder.unit();
        case ItemAttributeModifiers.DisplayType.OVERRIDE -> builder -> builder.accept("value", ComponentHasher.COMPONENT, ItemAttributeModifiers.Display::getComponent);
    });
    public static final MinecraftHasher<ItemAttributeModifiers.Entry> ATTRIBUTE_MODIFIER_ENTRY = MinecraftHasher.mapBuilder(builder -> builder.accept("type", ATTRIBUTE, ItemAttributeModifiers.Entry::getAttribute).accept("id", KEY, entry -> entry.getModifier().getId()).accept("amount", DOUBLE, entry -> entry.getModifier().getAmount()).accept("operation", ATTRIBUTE_MODIFIER_OPERATION, entry -> entry.getModifier().getOperation()).optional("slot", EQUIPMENT_SLOT_GROUP, ItemAttributeModifiers.Entry::getSlot, ItemAttributeModifiers.EquipmentSlotGroup.ANY).optionalPredicate("display", ATTRIBUTE_MODIFIER_DISPLAY, ItemAttributeModifiers.Entry::getDisplay, display -> display.getType() != ItemAttributeModifiers.DisplayType.DEFAULT));
    public static final MinecraftHasher<Consumable.ItemUseAnimation> ITEM_USE_ANIMATION = MinecraftHasher.fromEnum();
    public static final MinecraftHasher<ConsumeEffectType> CONSUME_EFFECT_TYPE = RegistryHasher.enumRegistry();
    public static final MinecraftHasher<ConsumeEffect> CONSUME_EFFECT = CONSUME_EFFECT_TYPE.dispatch(ConsumeEffectType::fromEffect, type -> type.getBuilder().cast());
    public static final MinecraftHasher<SuspiciousStewEffect> SUSPICIOUS_STEW_EFFECT = MinecraftHasher.mapBuilder(builder -> builder.accept("id", EFFECT_ID, SuspiciousStewEffect::getMobEffectId).optional("duration", INT, SuspiciousStewEffect::getDuration, 160));
    public static final MinecraftHasher<InstrumentComponent> INSTRUMENT_COMPONENT = MinecraftHasher.either(INSTRUMENT.holder(), InstrumentComponent::instrumentHolder, KEY, InstrumentComponent::instrumentLocation);
    public static final MinecraftHasher<ToolData.Rule> TOOL_RULE = MinecraftHasher.mapBuilder(builder -> builder.accept("blocks", BLOCK.holderSet(), ToolData.Rule::getBlocks).optionalNullable("speed", MinecraftHasher.FLOAT, ToolData.Rule::getSpeed).optionalNullable("correct_for_drops", MinecraftHasher.BOOL, ToolData.Rule::getCorrectForDrops));
    public static final MinecraftHasher<BlocksAttacks.DamageReduction> BLOCKS_ATTACKS_DAMAGE_REDUCTION = MinecraftHasher.mapBuilder(builder -> builder.optional("horizontal_blocking_angle", FLOAT, BlocksAttacks.DamageReduction::horizontalBlockingAngle, Float.valueOf(90.0f)).optionalNullable("type", DAMAGE_TYPE.holderSet(), BlocksAttacks.DamageReduction::type).accept("base", FLOAT, BlocksAttacks.DamageReduction::base).accept("factor", FLOAT, BlocksAttacks.DamageReduction::factor));
    public static final MinecraftHasher<BlocksAttacks.ItemDamageFunction> BLOCKS_ATTACKS_ITEM_DAMAGE_FUNCTION = MinecraftHasher.mapBuilder(builder -> builder.accept("threshold", FLOAT, BlocksAttacks.ItemDamageFunction::threshold).accept("base", FLOAT, BlocksAttacks.ItemDamageFunction::base).accept("factor", FLOAT, BlocksAttacks.ItemDamageFunction::factor));
    public static final MinecraftHasher<ProvidesTrimMaterial> PROVIDES_TRIM_MATERIAL = MinecraftHasher.either(TRIM_MATERIAL.holder(), ProvidesTrimMaterial::materialHolder, KEY, ProvidesTrimMaterial::materialLocation);
    public static final MinecraftHasher<ArmorTrim> ARMOR_TRIM = MinecraftHasher.mapBuilder(builder -> builder.accept("material", TRIM_MATERIAL.holder(), ArmorTrim::material).accept("pattern", TRIM_PATTERN.holder(), ArmorTrim::pattern));
    public static final MinecraftHasher<JukeboxPlayable> JUKEBOX_PLAYABLE = MinecraftHasher.either(JUKEBOX_SONG.holder(), JukeboxPlayable::songHolder, KEY, JukeboxPlayable::songLocation);
    public static final MinecraftHasher<BannerPatternLayer> BANNER_PATTERN_LAYER = MinecraftHasher.mapBuilder(builder -> builder.accept("pattern", BANNER_PATTERN.holder(), BannerPatternLayer::getPattern).accept("color", DYE_COLOR, BannerPatternLayer::getColorId));
    public static final MinecraftHasher<Integer> FIREWORK_EXPLOSION_SHAPE = MinecraftHasher.fromIdEnum((Enum[])FireworkExplosionShape.values());
    public static final MinecraftHasher<Fireworks.FireworkExplosion> FIREWORK_EXPLOSION = MinecraftHasher.mapBuilder(builder -> builder.accept("shape", FIREWORK_EXPLOSION_SHAPE, Fireworks.FireworkExplosion::getShapeId).optionalList("colors", INT, explosion -> IntStream.of(explosion.getColors()).boxed().toList()).optionalList("fade_colors", INT, explosion -> IntStream.of(explosion.getFadeColors()).boxed().toList()).optional("has_trail", BOOL, Fireworks.FireworkExplosion::isHasTrail, false).optional("has_twinkle", BOOL, Fireworks.FireworkExplosion::isHasTwinkle, false));
    public static final MinecraftHasher<BeehiveOccupant> BEEHIVE_OCCUPANT = MinecraftHasher.mapBuilder(builder -> builder.optional("entity_data", NBT_MAP, BeehiveOccupant::getEntityData, NbtMap.EMPTY).accept("ticks_in_hive", INT, BeehiveOccupant::getTicksInHive).accept("min_ticks_in_hive", INT, BeehiveOccupant::getMinTicksInHive));

    public static RegistryHasher<?> registry(JavaRegistryKey<?> registry) {
        MinecraftHasher<Integer> hasher = KEY.sessionCast(registry::key);
        return hasher::hash;
    }

    public static <DirectType> RegistryHasher<DirectType> registry(JavaRegistryKey<?> registry, MinecraftHasher<DirectType> directHasher) {
        return new RegistryHasherWithDirectHasher<DirectType>(RegistryHasher.registry(registry), directHasher);
    }

    default public MinecraftHasher<Holder<DirectType>> holder() {
        RegistryHasher registryHasher = this;
        if (registryHasher instanceof RegistryHasherWithDirectHasher) {
            RegistryHasherWithDirectHasher withDirect = (RegistryHasherWithDirectHasher)registryHasher;
            return withDirect.holderHasher;
        }
        throw new IllegalStateException("Tried to create a holder hasher on a registry hasher that does not have a direct hasher specified");
    }

    default public MinecraftHasher<HolderSet> holderSet() {
        return (holder, encoder) -> {
            if (holder.getLocation() != null) {
                return TAG.hash(holder.getLocation(), encoder);
            }
            if (holder.getHolders() != null) {
                if (holder.getHolders().length == 1) {
                    return this.hash(holder.getHolders()[0], encoder);
                }
                return this.list().hash(Arrays.stream(holder.getHolders()).boxed().toList(), encoder);
            }
            throw new IllegalStateException("HolderSet must have either tag location or holders");
        };
    }

    public static <EnumConstant extends Enum<EnumConstant>> MinecraftHasher<EnumConstant> enumRegistry() {
        return KEY.cast(constant -> MinecraftKey.key(constant.name().toLowerCase(Locale.ROOT)));
    }

    public static <EnumConstant extends Enum<EnumConstant>> RegistryHasher<?> enumIdRegistry(EnumConstant[] values) {
        return RegistryHasher.enumIdRegistry(values, (T constant) -> MinecraftKey.key(constant.name().toLowerCase(Locale.ROOT)));
    }

    public static <EnumConstant extends Enum<EnumConstant>> RegistryHasher<?> enumIdRegistry(EnumConstant[] values, Function<EnumConstant, Key> toKey) {
        MinecraftHasher<Integer> hasher = KEY.cast(i -> (Key)toKey.apply(values[i]));
        return hasher::hash;
    }

    public static class RegistryHasherWithDirectHasher<DirectType>
    implements RegistryHasher<DirectType> {
        private final MinecraftHasher<Integer> id;
        private final MinecraftHasher<Holder<DirectType>> holderHasher;

        public RegistryHasherWithDirectHasher(MinecraftHasher<Integer> id, MinecraftHasher<DirectType> direct) {
            this.id = id;
            this.holderHasher = (value, encoder) -> {
                if (value.isId()) {
                    return this.hash(value.id(), encoder);
                }
                return direct.hash(value.custom(), encoder);
            };
        }

        @Override
        public HashCode hash(Integer value, MinecraftHashEncoder encoder) {
            return this.id.hash(value, encoder);
        }
    }
}

