/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.Pair;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.PlayerAuthInputData;
import org.cloudburstmc.protocol.bedrock.data.PlayerBlockActionData;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.translator.item.CustomItemTranslator;
import org.geysermc.geyser.translator.protocol.bedrock.BedrockInventoryTransactionTranslator;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.BlockBreakStage;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.InteractAction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.AdventureModePredicate;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundInteractPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;

public class BlockBreakHandler {
    private static final Set<Block> GAME_MASTER_BLOCKS = Set.of(Blocks.COMMAND_BLOCK, Blocks.CHAIN_COMMAND_BLOCK, Blocks.REPEATING_COMMAND_BLOCK, Blocks.JIGSAW, Blocks.STRUCTURE_BLOCK, Blocks.TEST_BLOCK, Blocks.TEST_INSTANCE_BLOCK);
    protected final GeyserSession session;
    protected @Nullable Vector3i currentBlockPos = null;
    protected @Nullable BlockState currentBlockState = null;
    protected long blockStartBreakTime = 0L;
    protected Vector3i lastInstaMinedPosition = null;
    protected Set<Vector3i> restoredBlocks = new HashSet<Vector3i>(2);
    protected @Nullable Vector3i itemFramePos = null;
    private final Cache<Vector3i, Pair<Long, BlockBreakStage>> destructionStageCache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(3L, TimeUnit.MINUTES).build();
    private final BlockPredicateCache blockPredicateCache = new BlockPredicateCache();

    public BlockBreakHandler(GeyserSession session) {
        this.session = session;
    }

    public void handlePlayerAuthInputPacket(PlayerAuthInputPacket packet) {
        if (packet.getInputData().contains((Object)PlayerAuthInputData.PERFORM_BLOCK_ACTIONS)) {
            this.handleBlockBreakActions(packet);
            this.restoredBlocks.clear();
            this.itemFramePos = null;
        }
    }

    protected void handleBlockBreakActions(PlayerAuthInputPacket packet) {
        block7: for (int i = 0; i < packet.getPlayerActions().size(); ++i) {
            PlayerBlockActionData actionData = packet.getPlayerActions().get(i);
            Vector3i position = actionData.getBlockPosition();
            int blockFace = actionData.getFace();
            switch (actionData.getAction()) {
                case DROP_ITEM: {
                    ServerboundPlayerActionPacket dropItemPacket = new ServerboundPlayerActionPacket(PlayerAction.DROP_ITEM, position, Direction.VALUES[blockFace], 0);
                    this.session.sendDownstreamGamePacket(dropItemPacket);
                    continue block7;
                }
                case START_BREAK: {
                    this.preStartBreakHandle(position, blockFace, packet.getTick());
                    continue block7;
                }
                case BLOCK_CONTINUE_DESTROY: {
                    PlayerBlockActionData nextAction;
                    if (this.testForItemFrameEntity(position) || this.testForLastInstaBreakPosOrReset(position) || this.abortDueToBlockRestoring(position)) continue block7;
                    if (!Objects.equals(position, this.currentBlockPos) || this.currentBlockState == null) {
                        if (this.currentBlockPos != null) {
                            this.handleAbortBreaking(this.currentBlockPos);
                        }
                        this.preStartBreakHandle(position, blockFace, packet.getTick());
                        continue block7;
                    }
                    if (i < packet.getPlayerActions().size() - 1 && Objects.equals((nextAction = packet.getPlayerActions().get(i + 1)).getBlockPosition(), position)) continue block7;
                    BlockState state = this.session.getGeyser().getWorldManager().blockAt(this.session, position);
                    if (!this.canBreak(position, state)) {
                        BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
                        this.restoredBlocks.add(position);
                        continue block7;
                    }
                    this.handleContinueDestroy(position, state, blockFace, packet.getTick());
                    continue block7;
                }
                case BLOCK_PREDICT_DESTROY: {
                    boolean valid;
                    if (this.testForItemFrameEntity(position) || this.testForLastInstaBreakPosOrReset(position)) continue block7;
                    if (!this.restoredBlocks.isEmpty()) {
                        BlockUtils.restoreCorrectBlock(this.session, position);
                        continue block7;
                    }
                    BlockState state = this.session.getGeyser().getWorldManager().blockAt(this.session, position);
                    boolean bl = valid = this.currentBlockState != null && Objects.equals(position, this.currentBlockPos);
                    if (!this.canBreak(position, state) || !valid) {
                        if (!valid) {
                            GeyserImpl.getInstance().getLogger().warning("Player %s tried to break block at %s (%s), without starting to destroy it!".formatted(this.session.bedrockUsername(), position, this.currentBlockState));
                        }
                        BlockUtils.stopBreakAndRestoreBlock(this.session, position, state);
                        this.restoredBlocks.add(position);
                        continue block7;
                    }
                    this.handlePredictDestroy(position, state, blockFace, packet.getTick());
                    continue block7;
                }
                case ABORT_BREAK: {
                    if (Objects.equals(this.lastInstaMinedPosition, position)) {
                        this.lastInstaMinedPosition = null;
                        continue block7;
                    }
                    if (this.testForItemFrameEntity(position)) continue block7;
                    this.handleAbortBreaking(position);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Unknown block break action: " + String.valueOf((Object)actionData.getAction()));
                }
            }
        }
    }

    private void preStartBreakHandle(Vector3i position, int blockFace, long tick) {
        this.lastInstaMinedPosition = null;
        if (this.testForItemFrameEntity(position) || this.abortDueToBlockRestoring(position)) {
            return;
        }
        BlockState state = this.session.getGeyser().getWorldManager().blockAt(this.session, position);
        if (!this.canBreak(position, state)) {
            BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
            this.restoredBlocks.add(position);
            return;
        }
        this.handleStartBreak(position, state, blockFace, tick);
    }

    protected void handleStartBreak(@NonNull Vector3i position, @NonNull BlockState state, int blockFace, long tick) {
        GeyserItemStack item = this.session.getPlayerInventory().getItemInHand();
        Direction direction = Direction.VALUES[blockFace];
        Vector3i fireBlockPos = BlockUtils.getBlockPosition(position, blockFace);
        Block possibleFireBlock = this.session.getGeyser().getWorldManager().blockAt(this.session, fireBlockPos).block();
        if (possibleFireBlock == Blocks.FIRE || possibleFireBlock == Blocks.SOUL_FIRE) {
            ServerboundPlayerActionPacket startBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, fireBlockPos, direction, this.session.getWorldCache().nextPredictionSequence());
            this.session.sendDownstreamGamePacket(startBreakingPacket);
        }
        float breakProgress = this.calculateBreakProgress(state, position, item);
        if (this.session.isInstabuild() || breakProgress >= 1.0f) {
            this.lastInstaMinedPosition = position;
            this.destroyBlock(state, position, direction, true);
        } else {
            ItemMapping mapping = item.getMapping(this.session);
            ItemDefinition customItem = mapping.isTool() ? CustomItemTranslator.getCustomItem(item.getComponents(), mapping) : null;
            CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(state.javaId());
            SkullCache.Skull skull = this.session.getSkullCache().getSkulls().get(position);
            this.blockStartBreakTime = 0L;
            if (((BitSet)BlockRegistries.NON_VANILLA_BLOCK_IDS.get()).get(state.javaId()) || blockStateOverride != null || customItem != null || skull != null && skull.getBlockDefinition() != null) {
                this.blockStartBreakTime = tick;
            }
            LevelEventPacket startBreak = new LevelEventPacket();
            startBreak.setType(LevelEvent.BLOCK_START_BREAK);
            startBreak.setPosition(position.toFloat());
            startBreak.setData((int)(65535.0 / BlockUtils.reciprocal(breakProgress)));
            this.session.sendUpstreamPacket(startBreak);
            BlockUtils.spawnBlockBreakParticles(this.session, direction, position, state);
            this.currentBlockPos = position;
            this.currentBlockState = state;
            this.session.sendDownstreamGamePacket(new ServerboundPlayerActionPacket(PlayerAction.START_DIGGING, position, direction, this.session.getWorldCache().nextPredictionSequence()));
        }
    }

    protected void handleContinueDestroy(Vector3i position, BlockState state, int blockFace, long tick) {
        Direction direction = Direction.VALUES[blockFace];
        BlockUtils.spawnBlockBreakParticles(this.session, direction, position, state);
        double totalBreakTime = BlockUtils.reciprocal(this.calculateBreakProgress(state, position, this.session.getPlayerInventory().getItemInHand()));
        if (this.blockStartBreakTime != 0L) {
            double d;
            long ticksSinceStart = tick - this.blockStartBreakTime;
            totalBreakTime += 2.0;
            if ((double)ticksSinceStart >= d) {
                this.destroyBlock(state, position, direction, false);
                return;
            }
        }
        LevelEventPacket updateBreak = new LevelEventPacket();
        updateBreak.setType(LevelEvent.BLOCK_UPDATE_BREAK);
        updateBreak.setPosition(position.toFloat());
        updateBreak.setData((int)(65535.0 / totalBreakTime));
        this.session.sendUpstreamPacket(updateBreak);
    }

    protected void handlePredictDestroy(Vector3i position, BlockState state, int blockFace, long tick) {
        this.destroyBlock(state, position, Direction.VALUES[blockFace], false);
    }

    protected void handleAbortBreaking(Vector3i position) {
        if (this.currentBlockPos != null) {
            ServerboundPlayerActionPacket abortBreakingPacket = new ServerboundPlayerActionPacket(PlayerAction.CANCEL_DIGGING, this.currentBlockPos, Direction.DOWN, 0);
            this.session.sendDownstreamGamePacket(abortBreakingPacket);
        }
        BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
    }

    protected boolean testForItemFrameEntity(Vector3i position) {
        if (this.itemFramePos != null && this.itemFramePos.equals(position)) {
            return true;
        }
        ItemFrameEntity itemFrameEntity = ItemFrameEntity.getItemFrameEntity(this.session, position);
        if (itemFrameEntity != null) {
            ServerboundInteractPacket attackPacket = new ServerboundInteractPacket(itemFrameEntity.getEntityId(), InteractAction.ATTACK, this.session.isSneaking());
            this.session.sendDownstreamGamePacket(attackPacket);
            this.itemFramePos = position;
            return true;
        }
        return false;
    }

    private boolean abortDueToBlockRestoring(Vector3i position) {
        if (this.restoredBlocks.contains(position)) {
            return true;
        }
        if (!this.restoredBlocks.isEmpty()) {
            BlockUtils.sendBedrockStopBlockBreak(this.session, position.toFloat());
            this.restoredBlocks.add(position);
            return true;
        }
        return false;
    }

    protected boolean canBreak(Vector3i vector, BlockState state) {
        if (this.session.isHandsBusy() || !this.session.getWorldBorder().isInsideBorderBoundaries()) {
            return false;
        }
        switch (this.session.getGameMode()) {
            case SPECTATOR: {
                return false;
            }
            case ADVENTURE: {
                if (this.blockPredicateCache.calculatePredicate(this.session, state, this.session.getPlayerInventory().getItemInHand())) break;
                return false;
            }
        }
        Vector3f playerPosition = this.session.getPlayerEntity().getPosition();
        playerPosition = playerPosition.down(EntityDefinitions.PLAYER.offset() - this.session.getEyeHeight());
        return BedrockInventoryTransactionTranslator.canInteractWithBlock(this.session, playerPosition, vector);
    }

    protected boolean canDestroyBlock(BlockState state) {
        ToolData data;
        boolean instabuild = this.session.isInstabuild();
        if (instabuild && (data = this.session.getPlayerInventory().getItemInHand().getComponent(DataComponentTypes.TOOL)) != null && !data.isCanDestroyBlocksInCreative()) {
            return false;
        }
        if (GAME_MASTER_BLOCKS.contains(state.block()) && (!instabuild || this.session.getOpPermissionLevel() < 2)) {
            return false;
        }
        return !state.is(Blocks.AIR);
    }

    protected void destroyBlock(BlockState state, Vector3i vector, Direction direction, boolean instamine) {
        this.session.sendDownstreamGamePacket(new ServerboundPlayerActionPacket(instamine ? PlayerAction.START_DIGGING : PlayerAction.FINISH_DIGGING, vector, direction, this.session.getWorldCache().nextPredictionSequence()));
        this.session.getWorldCache().markPositionInSequence(vector);
        if (this.canDestroyBlock(state)) {
            BlockUtils.spawnBlockBreakParticles(this.session, direction, vector, state);
            BlockUtils.sendBedrockBlockDestroy(this.session, vector.toFloat(), state.javaId());
        } else {
            BlockUtils.restoreCorrectBlock(this.session, vector, state);
        }
        this.clearCurrentVariables();
    }

    protected float calculateBreakProgress(BlockState state, Vector3i vector, GeyserItemStack stack) {
        return BlockUtils.getBlockMiningProgressPerTick(this.session, state.block(), stack);
    }

    protected boolean testForLastInstaBreakPosOrReset(Vector3i position) {
        if (Objects.equals(this.lastInstaMinedPosition, position)) {
            return true;
        }
        this.lastInstaMinedPosition = null;
        return false;
    }

    protected void clearCurrentVariables() {
        this.currentBlockPos = null;
        this.currentBlockState = null;
        this.blockStartBreakTime = 0L;
    }

    public void reset() {
        this.clearCurrentVariables();
        this.lastInstaMinedPosition = null;
        this.destructionStageCache.invalidateAll();
    }

    public Cache<Vector3i, Pair<Long, BlockBreakStage>> getDestructionStageCache() {
        return this.destructionStageCache;
    }

    private static class BlockPredicateCache {
        private BlockState lastBlockState;
        private GeyserItemStack lastItemStack;
        private Boolean lastResult;

        private BlockPredicateCache() {
        }

        private boolean calculatePredicate(GeyserSession session, BlockState state, GeyserItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            AdventureModePredicate canBreak = stack.getComponent(DataComponentTypes.CAN_BREAK);
            if (canBreak == null) {
                return false;
            }
            if (state.equals(this.lastBlockState) && stack.equals(this.lastItemStack) && this.lastResult != null) {
                return this.lastResult;
            }
            this.lastBlockState = state;
            this.lastItemStack = stack;
            for (AdventureModePredicate.BlockPredicate predicate : canBreak.getPredicates()) {
                if (!BlockUtils.blockMatchesPredicate(session, state, predicate)) continue;
                this.lastResult = true;
                return this.lastResult;
            }
            this.lastResult = false;
            return this.lastResult;
        }
    }
}

