/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;

public class MovePlayerPacket
implements BedrockPacket {
    private long runtimeEntityId;
    private Vector3f position;
    private Vector3f rotation;
    private Mode mode;
    private boolean onGround;
    private long ridingRuntimeEntityId;
    private TeleportationCause teleportationCause;
    private int entityType;
    private long tick;

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.MOVE_PLAYER;
    }

    @Override
    public MovePlayerPacket clone() {
        try {
            return (MovePlayerPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public long getRidingRuntimeEntityId() {
        return this.ridingRuntimeEntityId;
    }

    public TeleportationCause getTeleportationCause() {
        return this.teleportationCause;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public long getTick() {
        return this.tick;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    public void setRidingRuntimeEntityId(long ridingRuntimeEntityId) {
        this.ridingRuntimeEntityId = ridingRuntimeEntityId;
    }

    public void setTeleportationCause(TeleportationCause teleportationCause) {
        this.teleportationCause = teleportationCause;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
    }

    public void setTick(long tick) {
        this.tick = tick;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MovePlayerPacket)) {
            return false;
        }
        MovePlayerPacket other = (MovePlayerPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.runtimeEntityId != other.runtimeEntityId) {
            return false;
        }
        if (this.onGround != other.onGround) {
            return false;
        }
        if (this.ridingRuntimeEntityId != other.ridingRuntimeEntityId) {
            return false;
        }
        if (this.entityType != other.entityType) {
            return false;
        }
        if (this.tick != other.tick) {
            return false;
        }
        Vector3f this$position = this.position;
        Vector3f other$position = other.position;
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector3f this$rotation = this.rotation;
        Vector3f other$rotation = other.rotation;
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        Mode this$mode = this.mode;
        Mode other$mode = other.mode;
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        TeleportationCause this$teleportationCause = this.teleportationCause;
        TeleportationCause other$teleportationCause = other.teleportationCause;
        return !(this$teleportationCause == null ? other$teleportationCause != null : !((Object)((Object)this$teleportationCause)).equals((Object)other$teleportationCause));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MovePlayerPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $runtimeEntityId = this.runtimeEntityId;
        result = result * 59 + (int)($runtimeEntityId >>> 32 ^ $runtimeEntityId);
        result = result * 59 + (this.onGround ? 79 : 97);
        long $ridingRuntimeEntityId = this.ridingRuntimeEntityId;
        result = result * 59 + (int)($ridingRuntimeEntityId >>> 32 ^ $ridingRuntimeEntityId);
        result = result * 59 + this.entityType;
        long $tick = this.tick;
        result = result * 59 + (int)($tick >>> 32 ^ $tick);
        Vector3f $position = this.position;
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector3f $rotation = this.rotation;
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        Mode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        TeleportationCause $teleportationCause = this.teleportationCause;
        result = result * 59 + ($teleportationCause == null ? 43 : ((Object)((Object)$teleportationCause)).hashCode());
        return result;
    }

    public String toString() {
        return "MovePlayerPacket(runtimeEntityId=" + this.runtimeEntityId + ", position=" + this.position + ", rotation=" + this.rotation + ", mode=" + (Object)((Object)this.mode) + ", onGround=" + this.onGround + ", ridingRuntimeEntityId=" + this.ridingRuntimeEntityId + ", teleportationCause=" + (Object)((Object)this.teleportationCause) + ", entityType=" + this.entityType + ", tick=" + this.tick + ")";
    }

    public static enum TeleportationCause {
        UNKNOWN,
        PROJECTILE,
        CHORUS_FRUIT,
        COMMAND,
        BEHAVIOR;

        private static final InternalLogger log;
        private static final TeleportationCause[] VALUES;

        public static TeleportationCause byId(int id) {
            if (id >= 0 && id < VALUES.length) {
                return VALUES[id];
            }
            log.debug("Unknown teleportation cause ID: {}", (Object)id);
            return UNKNOWN;
        }

        static {
            log = InternalLoggerFactory.getInstance(TeleportationCause.class);
            VALUES = TeleportationCause.values();
        }
    }

    public static enum Mode {
        NORMAL,
        RESPAWN,
        TELEPORT,
        HEAD_ROTATION;

    }
}

