/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipFile;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.core.TreeNode;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;

public final class AssetUtils {
    private static final String CLIENT_JAR_HASH_FILE = "client_jar.hash";
    private static final Map<String, Asset> ASSET_MAP = new HashMap<String, Asset>();
    private static VersionDownload CLIENT_JAR_INFO;
    private static final Queue<ClientJarTask> CLIENT_JAR_TASKS;
    private static boolean FORCE_DOWNLOAD_JAR;

    public static Asset getAsset(String name) {
        return ASSET_MAP.get(name);
    }

    public static boolean isAssetKnown(String name) {
        return ASSET_MAP.containsKey(name);
    }

    public static void addTask(boolean required, ClientJarTask task) {
        CLIENT_JAR_TASKS.add(task);
        FORCE_DOWNLOAD_JAR |= required;
    }

    public static CompletableFuture<Void> generateAssetCache() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                VersionManifest versionManifest = GeyserImpl.JSON_MAPPER.readValue(WebUtils.getBody("https://launchermeta.mojang.com/mc/game/version_manifest.json"), VersionManifest.class);
                String latestInfoURL = "";
                for (Version version : versionManifest.getVersions()) {
                    if (!version.getId().equals(GameProtocol.getJavaCodec().getMinecraftVersion())) continue;
                    latestInfoURL = version.getUrl();
                    break;
                }
                if (latestInfoURL.isEmpty()) {
                    throw new Exception(GeyserLocale.getLocaleStringLog("geyser.locale.fail.latest_version"));
                }
                VersionInfo versionInfo = GeyserImpl.JSON_MAPPER.readValue(WebUtils.getBody(latestInfoURL), VersionInfo.class);
                GeyserImpl.getInstance().getLogger().debug(GeyserImpl.JSON_MAPPER.writeValueAsString(versionInfo.getDownloads()));
                CLIENT_JAR_INFO = versionInfo.getDownloads().get("client");
                GeyserImpl.getInstance().getLogger().debug(GeyserImpl.JSON_MAPPER.writeValueAsString(CLIENT_JAR_INFO));
                JsonNode assets = GeyserImpl.JSON_MAPPER.readTree(WebUtils.getBody(versionInfo.getAssetIndex().getUrl())).get("objects");
                Iterator<Map.Entry<String, JsonNode>> assetIterator = assets.fields();
                while (assetIterator.hasNext()) {
                    Map.Entry<String, JsonNode> entry = assetIterator.next();
                    if (!entry.getKey().startsWith("minecraft/lang/")) continue;
                    Asset asset = GeyserImpl.JSON_MAPPER.treeToValue((TreeNode)entry.getValue(), Asset.class);
                    ASSET_MAP.put(entry.getKey(), asset);
                }
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.locale.fail.asset_cache", new Object[]{!e.getMessage().isEmpty() ? e.getMessage() : e.getStackTrace()}));
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadAndRunClientJarTasks() {
        ClientJarTask task;
        if (CLIENT_JAR_INFO == null) {
            GeyserImpl.getInstance().getLogger().debug("Skipping en_US hash check as client jar is null.");
            return;
        }
        if (!FORCE_DOWNLOAD_JAR) {
            String curHash;
            block24: {
                curHash = null;
                try {
                    File hashFile = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve(CLIENT_JAR_HASH_FILE).toFile();
                    if (!hashFile.exists()) break block24;
                    try (BufferedReader br = new BufferedReader(new FileReader(hashFile));){
                        curHash = br.readLine().trim();
                    }
                }
                catch (IOException hashFile) {
                    // empty catch block
                }
            }
            String targetHash = CLIENT_JAR_INFO.getSha1();
            if (targetHash.equals(curHash)) {
                while ((task = CLIENT_JAR_TASKS.poll()) != null) {
                    task.whenDone.run();
                }
                return;
            }
        }
        try {
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.locale.download.en_us"));
            GeyserImpl.getInstance().getLogger().debug("Download URL: " + CLIENT_JAR_INFO.getUrl());
            Path tmpFilePath = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("tmp_locale.jar");
            WebUtils.downloadFile(CLIENT_JAR_INFO.getUrl(), tmpFilePath.toString());
            try (ZipFile localeJar = new ZipFile(tmpFilePath.toString());){
                while ((task = CLIENT_JAR_TASKS.poll()) != null) {
                    InputStream fileStream = localeJar.getInputStream(localeJar.getEntry(task.asset));
                    try {
                        task.ifNewDownload.accept(fileStream);
                        task.whenDone.run();
                    }
                    finally {
                        if (fileStream == null) continue;
                        fileStream.close();
                    }
                }
            }
            Path cache = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache");
            Files.createDirectories(cache, new FileAttribute[0]);
            FileUtils.writeFile(cache.resolve(CLIENT_JAR_HASH_FILE).toString(), CLIENT_JAR_INFO.getSha1().toCharArray());
            Files.delete(tmpFilePath);
            GeyserImpl.getInstance().getLogger().info(GeyserLocale.getLocaleStringLog("geyser.locale.download.en_us.done"));
            return;
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.locale.fail.en_us"), e);
        }
    }

    public static void saveFile(Path location, InputStream fileStream) throws IOException {
        try (OutputStream outStream = Files.newOutputStream(location, new OpenOption[0]);){
            int length;
            byte[] buf = new byte[fileStream.available()];
            while ((length = fileStream.read(buf)) != -1) {
                outStream.write(buf, 0, length);
            }
            outStream.flush();
        }
    }

    private AssetUtils() {
    }

    static {
        CLIENT_JAR_TASKS = new ArrayDeque<ClientJarTask>();
        FORCE_DOWNLOAD_JAR = false;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Asset {
        @JsonProperty(value="hash")
        private String hash;
        @JsonProperty(value="size")
        private int size;

        public String getHash() {
            return this.hash;
        }

        public int getSize() {
            return this.size;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionDownload {
        @JsonProperty(value="sha1")
        private String sha1;
        @JsonProperty(value="size")
        private int size;
        @JsonProperty(value="url")
        private String url;

        VersionDownload() {
        }

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public record ClientJarTask(String asset, InputStreamConsumer ifNewDownload, Runnable whenDone) {
    }

    @FunctionalInterface
    public static interface InputStreamConsumer {
        public void accept(InputStream var1) throws IOException;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionManifest {
        @JsonProperty(value="latest")
        private LatestVersion latestVersion;
        @JsonProperty(value="versions")
        private List<Version> versions;

        VersionManifest() {
        }

        public LatestVersion getLatestVersion() {
            return this.latestVersion;
        }

        public List<Version> getVersions() {
            return this.versions;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Version {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="time")
        private String time;
        @JsonProperty(value="releaseTime")
        private String releaseTime;

        Version() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getTime() {
            return this.time;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionInfo {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="time")
        private String time;
        @JsonProperty(value="releaseTime")
        private String releaseTime;
        @JsonProperty(value="assetIndex")
        private AssetIndex assetIndex;
        @JsonProperty(value="downloads")
        private Map<String, VersionDownload> downloads;

        VersionInfo() {
        }

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public String getTime() {
            return this.time;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }

        public AssetIndex getAssetIndex() {
            return this.assetIndex;
        }

        public Map<String, VersionDownload> getDownloads() {
            return this.downloads;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class AssetIndex {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="sha1")
        private String sha1;
        @JsonProperty(value="size")
        private int size;
        @JsonProperty(value="totalSize")
        private int totalSize;
        @JsonProperty(value="url")
        private String url;

        AssetIndex() {
        }

        public String getId() {
            return this.id;
        }

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public String getUrl() {
            return this.url;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class LatestVersion {
        @JsonProperty(value="release")
        private String release;
        @JsonProperty(value="snapshot")
        private String snapshot;

        LatestVersion() {
        }

        public String getRelease() {
            return this.release;
        }

        public String getSnapshot() {
            return this.snapshot;
        }
    }
}

