/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;

public record Equippable(EquipmentSlot slot, Sound equipSound, @Nullable Key model, @Nullable Key cameraOverlay, @Nullable HolderSet allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract) {
    public static @NonNull EquippableBuilder builder() {
        return new EquippableBuilder();
    }

    public @NonNull EquippableBuilder toBuilder() {
        return new EquippableBuilder().slot(this.slot).equipSound(this.equipSound).model(this.model).cameraOverlay(this.cameraOverlay).allowedEntities(this.allowedEntities).dispensable(this.dispensable).swappable(this.swappable).damageOnHurt(this.damageOnHurt).equipOnInteract(this.equipOnInteract);
    }

    public static class EquippableBuilder {
        private EquipmentSlot slot;
        private Sound equipSound;
        private Key model;
        private Key cameraOverlay;
        private HolderSet allowedEntities;
        private boolean dispensable;
        private boolean swappable;
        private boolean damageOnHurt;
        private boolean equipOnInteract;

        EquippableBuilder() {
        }

        public @NonNull EquippableBuilder slot(EquipmentSlot slot) {
            this.slot = slot;
            return this;
        }

        public @NonNull EquippableBuilder equipSound(Sound equipSound) {
            this.equipSound = equipSound;
            return this;
        }

        public @NonNull EquippableBuilder model(@Nullable Key model) {
            this.model = model;
            return this;
        }

        public @NonNull EquippableBuilder cameraOverlay(@Nullable Key cameraOverlay) {
            this.cameraOverlay = cameraOverlay;
            return this;
        }

        public @NonNull EquippableBuilder allowedEntities(@Nullable HolderSet allowedEntities) {
            this.allowedEntities = allowedEntities;
            return this;
        }

        public @NonNull EquippableBuilder dispensable(boolean dispensable) {
            this.dispensable = dispensable;
            return this;
        }

        public @NonNull EquippableBuilder swappable(boolean swappable) {
            this.swappable = swappable;
            return this;
        }

        public @NonNull EquippableBuilder damageOnHurt(boolean damageOnHurt) {
            this.damageOnHurt = damageOnHurt;
            return this;
        }

        public @NonNull EquippableBuilder equipOnInteract(boolean equipOnInteract) {
            this.equipOnInteract = equipOnInteract;
            return this;
        }

        public @NonNull Equippable build() {
            return new Equippable(this.slot, this.equipSound, this.model, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt, this.equipOnInteract);
        }

        public @NonNull String toString() {
            return "Equippable.EquippableBuilder(slot=" + String.valueOf((Object)this.slot) + ", equipSound=" + String.valueOf(this.equipSound) + ", model=" + String.valueOf(this.model) + ", cameraOverlay=" + String.valueOf(this.cameraOverlay) + ", allowedEntities=" + String.valueOf(this.allowedEntities) + ", dispensable=" + this.dispensable + ", swappable=" + this.swappable + ", damageOnHurt=" + this.damageOnHurt + ", equipOnInteract=" + this.equipOnInteract + ")";
        }
    }
}

