/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FoodProperties {
    private final int nutrition;
    private final float saturationModifier;
    private final boolean canAlwaysEat;

    public static @NonNull FoodPropertiesBuilder builder() {
        return new FoodPropertiesBuilder();
    }

    public @NonNull FoodPropertiesBuilder toBuilder() {
        return new FoodPropertiesBuilder().nutrition(this.nutrition).saturationModifier(this.saturationModifier).canAlwaysEat(this.canAlwaysEat);
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public boolean isCanAlwaysEat() {
        return this.canAlwaysEat;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FoodProperties)) {
            return false;
        }
        FoodProperties other = (FoodProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNutrition() != other.getNutrition()) {
            return false;
        }
        if (Float.compare(this.getSaturationModifier(), other.getSaturationModifier()) != 0) {
            return false;
        }
        return this.isCanAlwaysEat() == other.isCanAlwaysEat();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FoodProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNutrition();
        result = result * 59 + Float.floatToIntBits(this.getSaturationModifier());
        result = result * 59 + (this.isCanAlwaysEat() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "FoodProperties(nutrition=" + this.getNutrition() + ", saturationModifier=" + this.getSaturationModifier() + ", canAlwaysEat=" + this.isCanAlwaysEat() + ")";
    }

    public FoodProperties(int nutrition, float saturationModifier, boolean canAlwaysEat) {
        this.nutrition = nutrition;
        this.saturationModifier = saturationModifier;
        this.canAlwaysEat = canAlwaysEat;
    }

    public static class FoodPropertiesBuilder {
        private int nutrition;
        private float saturationModifier;
        private boolean canAlwaysEat;

        FoodPropertiesBuilder() {
        }

        public @NonNull FoodPropertiesBuilder nutrition(int nutrition) {
            this.nutrition = nutrition;
            return this;
        }

        public @NonNull FoodPropertiesBuilder saturationModifier(float saturationModifier) {
            this.saturationModifier = saturationModifier;
            return this;
        }

        public @NonNull FoodPropertiesBuilder canAlwaysEat(boolean canAlwaysEat) {
            this.canAlwaysEat = canAlwaysEat;
            return this;
        }

        public @NonNull FoodProperties build() {
            return new FoodProperties(this.nutrition, this.saturationModifier, this.canAlwaysEat);
        }

        public @NonNull String toString() {
            return "FoodProperties.FoodPropertiesBuilder(nutrition=" + this.nutrition + ", saturationModifier=" + this.saturationModifier + ", canAlwaysEat=" + this.canAlwaysEat + ")";
        }
    }
}

