/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.GeyserInstrument;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Instrument;

public class GoatHornItem
extends Item {
    public GoatHornItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public ItemData.Builder translateToBedrock(GeyserSession session, int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        GeyserInstrument instrument;
        int bedrockId;
        ItemData.Builder builder = super.translateToBedrock(session, count, components, mapping, mappings);
        if (components == null) {
            return builder;
        }
        Holder<Instrument> holder = components.get(DataComponentTypes.INSTRUMENT);
        if (holder != null && (bedrockId = (instrument = GeyserInstrument.fromHolder(session, holder)).bedrockId()) >= 0) {
            builder.damage(bedrockId);
        }
        return builder;
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        GeyserInstrument instrument;
        super.translateComponentsToBedrock(session, components, builder);
        Holder<Instrument> holder = components.get(DataComponentTypes.INSTRUMENT);
        if (holder != null && components.get(DataComponentTypes.HIDE_TOOLTIP) == null && components.get(DataComponentTypes.HIDE_ADDITIONAL_TOOLTIP) == null && (instrument = GeyserInstrument.fromHolder(session, holder)).bedrockInstrument() == null) {
            builder.getOrCreateLore().add(instrument.description());
        }
    }

    @Override
    public @NonNull GeyserItemStack translateToJava(GeyserSession session, @NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        GeyserItemStack itemStack = super.translateToJava(session, itemData, mapping, mappings);
        int damage = itemData.getDamage();
        itemStack.getOrCreateComponents().put(DataComponentTypes.INSTRUMENT, Holder.ofId(GeyserInstrument.bedrockIdToJava(session, damage)));
        return itemStack;
    }

    @Override
    public boolean ignoreDamage() {
        return true;
    }
}

