/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import org.geysermc.mcprotocollib.network.packet.PacketHeader;

public class PacketSizerCodec
extends ByteToMessageCodec<ByteBuf> {
    private final PacketHeader header;

    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        int size = this.header.getLengthSize();
        if (size == 0) {
            out.writeBytes(in);
            return;
        }
        int length = in.readableBytes();
        out.ensureWritable(this.header.getLengthSize(length) + length);
        this.header.writeLength(out, length);
        out.writeBytes(in);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) {
        int size = this.header.getLengthSize();
        if (size == 0) {
            out.add(buf.retain());
            return;
        }
        buf.markReaderIndex();
        byte[] lengthBytes = new byte[size];
        for (int index = 0; index < lengthBytes.length; ++index) {
            if (!buf.isReadable()) {
                buf.resetReaderIndex();
                return;
            }
            lengthBytes[index] = buf.readByte();
            if ((!this.header.isLengthVariable() || lengthBytes[index] < 0) && index != size - 1) continue;
            int length = this.header.readLength(Unpooled.wrappedBuffer((byte[])lengthBytes), buf.readableBytes());
            if (buf.readableBytes() < length) {
                buf.resetReaderIndex();
                return;
            }
            out.add(buf.readBytes(length));
            return;
        }
        throw new CorruptedFrameException("Length is too long.");
    }

    public PacketSizerCodec(PacketHeader header) {
        this.header = header;
    }
}

