/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.dump;

import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.geysermc.floodgate.util.DeviceOs;
import org.geysermc.floodgate.util.FloodgateInfoHolder;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.util.CpuUtils;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;

public class DumpInfo {
    @JsonIgnore
    private static final long MEGABYTE = 0x100000L;
    private final VersionInfo versionInfo;
    private final int cpuCount;
    private final String cpuName;
    private final Locale systemLocale;
    private final String systemEncoding;
    private final GitInfo gitInfo;
    private final GeyserConfiguration config;
    private final Floodgate floodgate;
    private final Object2IntMap<DeviceOs> userPlatforms;
    private final int connectionAttempts;
    private final HashInfo hashInfo;
    private final RamInfo ramInfo;
    private LogsInfo logsInfo;
    private final BootstrapDumpInfo bootstrapInfo;
    private final FlagsInfo flagsInfo;
    private final List<ExtensionInfo> extensionInfo;

    public DumpInfo(GeyserImpl geyser, boolean addLog) {
        String sha256Hash;
        String md5Hash;
        block5: {
            this.versionInfo = new VersionInfo();
            this.cpuCount = Runtime.getRuntime().availableProcessors();
            this.cpuName = CpuUtils.tryGetProcessorName();
            this.systemLocale = Locale.getDefault();
            this.systemEncoding = System.getProperty("file.encoding");
            this.gitInfo = new GitInfo("841", "f104a3d4caee12c86e49cd7e8cda26e6573b7e0b".substring(0, 7), "f104a3d4caee12c86e49cd7e8cda26e6573b7e0b", "master", "https://github.com/GeyserMC/Geyser");
            this.config = geyser.getConfig();
            this.floodgate = new Floodgate();
            md5Hash = "unknown";
            sha256Hash = "unknown";
            try {
                File file = new File(DumpInfo.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                ByteSource byteSource = com.google.common.io.Files.asByteSource((File)file);
                md5Hash = byteSource.hash(Hashing.md5()).toString();
                sha256Hash = byteSource.hash(Hashing.sha256()).toString();
            }
            catch (Exception e) {
                if (!this.config.isDebugMode()) break block5;
                e.printStackTrace();
            }
        }
        this.hashInfo = new HashInfo(md5Hash, sha256Hash);
        this.ramInfo = new RamInfo();
        if (addLog) {
            this.logsInfo = new LogsInfo(geyser);
        }
        this.userPlatforms = new Object2IntOpenHashMap<DeviceOs>();
        for (GeyserSession session : geyser.getSessionManager().getAllSessions()) {
            DeviceOs device = session.getClientData().getDeviceOs();
            this.userPlatforms.put(device, this.userPlatforms.getOrDefault((Object)device, 0) + 1);
        }
        this.connectionAttempts = geyser.getGeyserServer() != null ? geyser.getGeyserServer().getConnectionAttempts() : 0;
        this.bootstrapInfo = geyser.getBootstrap().getDumpInfo();
        this.flagsInfo = new FlagsInfo();
        this.extensionInfo = new ArrayList<ExtensionInfo>();
        for (Extension extension : GeyserApi.api().extensionManager().extensions()) {
            this.extensionInfo.add(new ExtensionInfo(extension.isEnabled(), extension.name(), extension.description().version(), extension.description().apiVersion(), extension.description().main(), extension.description().authors()));
        }
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public String getCpuName() {
        return this.cpuName;
    }

    public Locale getSystemLocale() {
        return this.systemLocale;
    }

    public String getSystemEncoding() {
        return this.systemEncoding;
    }

    public GitInfo getGitInfo() {
        return this.gitInfo;
    }

    public GeyserConfiguration getConfig() {
        return this.config;
    }

    public Floodgate getFloodgate() {
        return this.floodgate;
    }

    public Object2IntMap<DeviceOs> getUserPlatforms() {
        return this.userPlatforms;
    }

    public int getConnectionAttempts() {
        return this.connectionAttempts;
    }

    public HashInfo getHashInfo() {
        return this.hashInfo;
    }

    public RamInfo getRamInfo() {
        return this.ramInfo;
    }

    public LogsInfo getLogsInfo() {
        return this.logsInfo;
    }

    public BootstrapDumpInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    public FlagsInfo getFlagsInfo() {
        return this.flagsInfo;
    }

    public List<ExtensionInfo> getExtensionInfo() {
        return this.extensionInfo;
    }

    public static class VersionInfo {
        private final String name;
        private final String version;
        private final String javaName = System.getProperty("java.vm.name");
        private final String javaVendor = System.getProperty("java.vendor");
        private final String javaVersion = ManagementFactory.getRuntimeMXBean().getVmVersion();
        private final String architecture = System.getProperty("os.arch");
        private final String operatingSystem = System.getProperty("os.name");
        private final String operatingSystemVersion = System.getProperty("os.version");
        private final NetworkInfo network = new NetworkInfo();
        private final MCInfo mcInfo = new MCInfo();

        VersionInfo() {
            this.name = "Geyser";
            this.version = "2.7.1-b841 (git-master-f104a3d)";
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public String getJavaVendor() {
            return this.javaVendor;
        }

        public String getJavaVersion() {
            return this.javaVersion;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getOperatingSystem() {
            return this.operatingSystem;
        }

        public String getOperatingSystemVersion() {
            return this.operatingSystemVersion;
        }

        public NetworkInfo getNetwork() {
            return this.network;
        }

        public MCInfo getMcInfo() {
            return this.mcInfo;
        }
    }

    public record GitInfo(String buildNumber, @JsonProperty(value="git.commit.id.abbrev") String commitHashAbbrev, @JsonProperty(value="git.commit.id") String commitHash, @JsonProperty(value="git.branch") String branchName, @JsonProperty(value="git.remote.origin.url") String originUrl) {
    }

    public static class Floodgate {
        private final Properties gitInfo = FloodgateInfoHolder.getGitProperties();
        private final Object config = FloodgateInfoHolder.getConfig();

        Floodgate() {
        }

        public Properties getGitInfo() {
            return this.gitInfo;
        }

        public Object getConfig() {
            return this.config;
        }
    }

    public record HashInfo(String md5Hash, String sha256Hash) {
    }

    public record RamInfo(long free, long total, long max) {
        public RamInfo() {
            this(Runtime.getRuntime().freeMemory() / 0x100000L, Runtime.getRuntime().totalMemory() / 0x100000L, Runtime.getRuntime().maxMemory() / 0x100000L);
        }
    }

    public static class LogsInfo {
        private String link;

        public LogsInfo(GeyserImpl geyser) {
            try {
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("content", FileUtils.readAllLines(geyser.getBootstrap().getLogsPath()).collect(Collectors.joining("\n")));
                JsonNode logData = GeyserImpl.JSON_MAPPER.readTree(WebUtils.postForm("https://api.mclo.gs/1/log", fields));
                this.link = logData.get("url").textValue();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getLink() {
            return this.link;
        }
    }

    public record FlagsInfo(List<String> flags) {
        public FlagsInfo() {
            this(ManagementFactory.getRuntimeMXBean().getInputArguments());
        }
    }

    public record ExtensionInfo(boolean enabled, String name, String version, String apiVersion, String main, List<String> authors) {
    }

    public static class MCInfo {
        private final List<String> bedrockVersions = GameProtocol.SUPPORTED_BEDROCK_CODECS.stream().map(BedrockCodec::getMinecraftVersion).toList();
        private final List<Integer> bedrockProtocols = GameProtocol.SUPPORTED_BEDROCK_CODECS.stream().map(BedrockCodec::getProtocolVersion).toList();
        private final int defaultBedrockProtocol = GameProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion();
        private final List<String> javaVersions = GameProtocol.getJavaVersions();
        private final int javaProtocol = GameProtocol.getJavaProtocolVersion();

        MCInfo() {
        }

        public List<String> getBedrockVersions() {
            return this.bedrockVersions;
        }

        public List<Integer> getBedrockProtocols() {
            return this.bedrockProtocols;
        }

        public int getDefaultBedrockProtocol() {
            return this.defaultBedrockProtocol;
        }

        public List<String> getJavaVersions() {
            return this.javaVersions;
        }

        public int getJavaProtocol() {
            return this.javaProtocol;
        }
    }

    public static class NetworkInfo {
        private final boolean dockerCheck;
        private String internalIP;

        NetworkInfo() {
            if (AsteriskSerializer.showSensitive) {
                try (Socket socket = new Socket();){
                    socket.connect(new InetSocketAddress("geysermc.org", 80));
                    this.internalIP = socket.getLocalAddress().getHostAddress();
                }
                catch (IOException e1) {
                    try {
                        this.internalIP = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            } else {
                this.internalIP = "***";
            }
            this.dockerCheck = this.checkDockerBasic();
        }

        private boolean checkDockerBasic() {
            try {
                String output;
                String OS = System.getProperty("os.name").toLowerCase();
                if ((OS.contains("nix") || OS.contains("nux") || OS.indexOf("aix") > 0) && (output = new String(Files.readAllBytes(Paths.get("/proc/1/cgroup", new String[0])))).contains("docker")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public boolean isDockerCheck() {
            return this.dockerCheck;
        }

        public String getInternalIP() {
            return this.internalIP;
        }
    }
}

