/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster;

import java.util.Optional;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.MonsterEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;

public class CreakingEntity
extends MonsterEntity {
    public static final String CREAKING_STATE = "minecraft:creaking_state";
    public static final String CREAKING_SWAYING_TICKS = "minecraft:creaking_swaying_ticks";
    private Vector3i homePosition;

    public CreakingEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.setFlag(EntityFlag.FIRE_IMMUNE, true);
    }

    @Override
    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
        this.propertyManager.add(CREAKING_STATE, "neutral");
        this.propertyManager.add(CREAKING_SWAYING_TICKS, 0);
        this.propertyManager.applyIntProperties(addEntityPacket.getProperties().getIntProperties());
    }

    public void setCanMove(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        this.setFlag(EntityFlag.BODY_ROTATION_BLOCKED, booleanEntityMetadata.getValue() == false);
        this.propertyManager.add(CREAKING_STATE, booleanEntityMetadata.getValue() != false ? "hostile_unobserved" : "hostile_observed");
        this.updateBedrockEntityProperties();
    }

    public void setActive(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        if (!booleanEntityMetadata.getValue().booleanValue()) {
            this.propertyManager.add(CREAKING_STATE, "neutral");
        }
    }

    public void setIsTearingDown(EntityMetadata<Boolean, ? extends MetadataType<Boolean>> booleanEntityMetadata) {
        if (booleanEntityMetadata.getValue().booleanValue()) {
            this.propertyManager.add(CREAKING_STATE, "crumbling");
            this.updateBedrockEntityProperties();
        }
    }

    public void setHomePos(EntityMetadata<Optional<Vector3i>, ? extends MetadataType<Optional<Vector3i>>> optionalEntityMetadata) {
        this.homePosition = optionalEntityMetadata.getValue().isPresent() ? optionalEntityMetadata.getValue().get() : null;
    }

    public void createParticleBeam() {
        if (this.homePosition != null) {
            LevelEventGenericPacket levelEventGenericPacket = new LevelEventGenericPacket();
            levelEventGenericPacket.setType(LevelEvent.PARTICLE_CREAKING_HEART_TRIAL);
            levelEventGenericPacket.setTag(NbtMap.builder().putInt("CreakingAmount", 20).putFloat("CreakingX", this.position.getX()).putFloat("CreakingY", this.position.getY()).putFloat("CreakingZ", this.position.getZ()).putInt("HeartAmount", 20).putFloat("HeartX", (float)this.homePosition.getX()).putFloat("HeartY", (float)this.homePosition.getY()).putFloat("HeartZ", (float)this.homePosition.getZ()).build());
            this.session.sendUpstreamPacket(levelEventGenericPacket);
        }
    }
}

