/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.event.type;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.bedrock.SessionLoadResourcePacksEvent;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.api.pack.exception.ResourcePackException;
import org.geysermc.geyser.api.pack.option.PriorityOption;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.ResourcePackHolder;
import org.geysermc.geyser.pack.option.OptionHolder;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePackStackPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePacksInfoPacket;

public class SessionLoadResourcePacksEventImpl
extends SessionLoadResourcePacksEvent {
    private final Map<UUID, ResourcePackHolder> packs = new Object2ObjectLinkedOpenHashMap((Map)Registries.RESOURCE_PACKS.get());
    private final Map<UUID, OptionHolder> sessionPackOptionOverrides = new Object2ObjectOpenHashMap();

    public SessionLoadResourcePacksEventImpl(GeyserSession session) {
        super(session);
    }

    @Override
    public @NonNull List<ResourcePack> resourcePacks() {
        return this.packs.values().stream().map(ResourcePackHolder::resourcePack).toList();
    }

    @Override
    public boolean register(@NonNull ResourcePack resourcePack) {
        try {
            this.register(resourcePack, PriorityOption.NORMAL);
        }
        catch (ResourcePackException e) {
            GeyserImpl.getInstance().getLogger().error("An exception occurred while registering resource pack: " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    public void register(@NonNull ResourcePack resourcePack, ResourcePackOption<?> ... options) {
        Objects.requireNonNull(resourcePack);
        if (!(resourcePack instanceof GeyserResourcePack)) {
            throw new ResourcePackException(ResourcePackException.Cause.UNKNOWN_IMPLEMENTATION);
        }
        GeyserResourcePack pack = (GeyserResourcePack)resourcePack;
        UUID uuid = resourcePack.uuid();
        if (this.packs.containsKey(uuid)) {
            throw new ResourcePackException(ResourcePackException.Cause.DUPLICATE);
        }
        this.attemptRegisterOptions(pack, options);
        this.packs.put(uuid, ResourcePackHolder.of(pack));
    }

    @Override
    public void registerOptions(@NonNull UUID uuid, ResourcePackOption<?> ... options) {
        Objects.requireNonNull(uuid, "uuid cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        ResourcePackHolder holder = this.packs.get(uuid);
        if (holder == null) {
            throw new ResourcePackException(ResourcePackException.Cause.PACK_NOT_FOUND);
        }
        this.attemptRegisterOptions(holder.pack(), options);
    }

    @Override
    public Collection<ResourcePackOption<?>> options(@NonNull UUID uuid) {
        Objects.requireNonNull(uuid);
        ResourcePackHolder packHolder = this.packs.get(uuid);
        if (packHolder == null) {
            throw new ResourcePackException(ResourcePackException.Cause.PACK_NOT_FOUND);
        }
        OptionHolder optionHolder = this.sessionPackOptionOverrides.get(uuid);
        if (optionHolder == null) {
            return packHolder.optionHolder().immutableValues();
        }
        return optionHolder.immutableValues(packHolder.optionHolder());
    }

    @Override
    public @Nullable ResourcePackOption<?> option(@NonNull UUID uuid, @NonNull ResourcePackOption.Type type) {
        Objects.requireNonNull(uuid);
        Objects.requireNonNull(type);
        ResourcePackHolder packHolder = this.packs.get(uuid);
        if (packHolder == null) {
            throw new ResourcePackException(ResourcePackException.Cause.PACK_NOT_FOUND);
        }
        @Nullable OptionHolder additionalOptions = this.sessionPackOptionOverrides.get(uuid);
        OptionHolder defaultHolder = packHolder.optionHolder();
        Objects.requireNonNull(defaultHolder);
        return OptionHolder.optionByType(type, additionalOptions, defaultHolder);
    }

    @Override
    public boolean unregister(@NonNull UUID uuid) {
        this.sessionPackOptionOverrides.remove(uuid);
        return this.packs.remove(uuid) != null;
    }

    private void attemptRegisterOptions(@NonNull GeyserResourcePack pack, ResourcePackOption<?> ... options) {
        if (options == null) {
            return;
        }
        OptionHolder holder = this.sessionPackOptionOverrides.computeIfAbsent(pack.uuid(), $ -> new OptionHolder());
        holder.validateAndAdd(pack, options);
    }

    public List<ResourcePackStackPacket.Entry> orderedPacks() {
        return this.packs.values().stream().map(holder -> new AbstractMap.SimpleEntry<GeyserResourcePack, Double>(holder.pack(), this.priority(holder.pack()))).sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(entry -> {
            ResourcePackManifest.Header header = ((GeyserResourcePack)entry.getKey()).manifest().header();
            return new ResourcePackStackPacket.Entry(header.uuid().toString(), header.version().toString(), this.subpackName((GeyserResourcePack)entry.getKey()));
        }).toList();
    }

    public List<ResourcePacksInfoPacket.Entry> infoPacketEntries() {
        ArrayList<ResourcePacksInfoPacket.Entry> entries = new ArrayList<ResourcePacksInfoPacket.Entry>();
        for (ResourcePackHolder holder : this.packs.values()) {
            GeyserResourcePack pack = holder.pack();
            ResourcePackManifest.Header header = pack.manifest().header();
            entries.add(new ResourcePacksInfoPacket.Entry(header.uuid(), header.version().toString(), pack.codec().size(), pack.contentKey(), this.subpackName(pack), header.uuid().toString(), false, false, false, this.subpackName(pack)));
        }
        return entries;
    }

    public <T> T value(UUID uuid, ResourcePackOption.Type type, T defaultValue) {
        OptionHolder holder = this.sessionPackOptionOverrides.get(uuid);
        OptionHolder defaultHolder = this.packs.get(uuid).optionHolder();
        Objects.requireNonNull(defaultHolder);
        return OptionHolder.valueOrFallback(type, holder, defaultHolder, defaultValue);
    }

    private double priority(GeyserResourcePack pack) {
        return this.value(pack.uuid(), ResourcePackOption.Type.PRIORITY, (Integer)PriorityOption.NORMAL.value()).intValue();
    }

    private String subpackName(GeyserResourcePack pack) {
        return this.value(pack.uuid(), ResourcePackOption.Type.SUBPACK, "");
    }

    public Map<UUID, ResourcePackHolder> getPacks() {
        return this.packs;
    }
}

