/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.TeleportCache;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.RespawnPacket;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PositionElement;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.player.ClientboundPlayerPositionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.level.ServerboundAcceptTeleportationPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;

@Translator(packet=ClientboundPlayerPositionPacket.class)
public class JavaPlayerPositionTranslator
extends PacketTranslator<ClientboundPlayerPositionPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerPositionPacket packet) {
        if (!session.isLoggedIn()) {
            return;
        }
        SessionPlayerEntity entity = session.getPlayerEntity();
        Vector3d pos = packet.getPosition();
        if (!session.isSpawned()) {
            entity.setPosition(pos.toFloat());
            entity.setYaw(packet.getYRot());
            entity.setPitch(packet.getXRot());
            entity.setHeadYaw(packet.getYRot());
            RespawnPacket respawnPacket = new RespawnPacket();
            respawnPacket.setRuntimeEntityId(0L);
            respawnPacket.setPosition(entity.getPosition());
            respawnPacket.setState(RespawnPacket.State.SERVER_READY);
            session.sendUpstreamPacket(respawnPacket);
            entity.updateBedrockMetadata();
            MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
            movePlayerPacket.setRuntimeEntityId(entity.getGeyserId());
            movePlayerPacket.setPosition(entity.getPosition());
            movePlayerPacket.setRotation(entity.getBedrockRotation());
            movePlayerPacket.setMode(MovePlayerPacket.Mode.RESPAWN);
            session.sendUpstreamPacket(movePlayerPacket);
            entity.updateOwnRotation(entity.getYaw(), entity.getPitch(), entity.getHeadYaw());
            session.setSpawned(true);
            session.setUnconfirmedTeleport(new TeleportCache(packet.getPosition().getX(), packet.getPosition().getY(), packet.getPosition().getZ(), packet.getXRot(), packet.getYRot(), packet.getId()));
            this.acceptTeleport(session, packet.getPosition().getX(), packet.getPosition().getY(), packet.getPosition().getZ(), packet.getYRot(), packet.getXRot(), packet.getId());
            if (session.getServerRenderDistance() > 32 && !session.isEmulatePost1_13Logic()) {
                ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
                chunkRadiusUpdatedPacket.setRadius(session.getServerRenderDistance());
                session.sendUpstreamPacket(chunkRadiusUpdatedPacket);
                session.setLastChunkPosition(null);
            }
            ChunkUtils.updateChunkPosition(session, pos.toInt());
            if (session.getGeyser().getConfig().isDebugMode()) {
                session.getGeyser().getLogger().debug("Spawned player at " + String.valueOf(packet.getPosition()));
            }
            return;
        }
        double newX = pos.getX() + (double)(packet.getRelatives().contains((Object)PositionElement.X) ? entity.getPosition().getX() : 0.0f);
        double newY = pos.getY() + (double)(packet.getRelatives().contains((Object)PositionElement.Y) ? entity.getPosition().getY() - EntityDefinitions.PLAYER.offset() : 0.0f);
        double newZ = pos.getZ() + (double)(packet.getRelatives().contains((Object)PositionElement.Z) ? entity.getPosition().getZ() : 0.0f);
        float newPitch = packet.getXRot() + (packet.getRelatives().contains((Object)PositionElement.X_ROT) ? entity.getPitch() : 0.0f);
        float newYaw = packet.getYRot() + (packet.getRelatives().contains((Object)PositionElement.Y_ROT) ? entity.getYaw() : 0.0f);
        int id = packet.getId();
        session.getGeyser().getLogger().debug("Teleport (" + id + ") from " + entity.getPosition().getX() + " " + (entity.getPosition().getY() - EntityDefinitions.PLAYER.offset()) + " " + entity.getPosition().getZ());
        Vector3f lastPlayerPosition = entity.getPosition().down(EntityDefinitions.PLAYER.offset());
        float lastPlayerPitch = entity.getPitch();
        Vector3f teleportDestination = Vector3f.from((double)newX, (double)newY, (double)newZ);
        entity.moveAbsolute(teleportDestination, newYaw, newPitch, false, true);
        session.getGeyser().getLogger().debug("to " + entity.getPosition().getX() + " " + (entity.getPosition().getY() - EntityDefinitions.PLAYER.offset()) + " " + entity.getPosition().getZ());
        if ((double)lastPlayerPosition.distanceSquared(teleportDestination) < 0.001 && Math.abs(newPitch - lastPlayerPitch) < 5.0f) {
            session.setUnconfirmedTeleport(null);
        } else {
            session.setUnconfirmedTeleport(new TeleportCache(newX, newY, newZ, newPitch, newYaw, id));
        }
        this.acceptTeleport(session, newX, newY, newZ, newYaw, newPitch, id);
    }

    private void acceptTeleport(GeyserSession session, double x, double y, double z, float yaw, float pitch, int id) {
        ServerboundAcceptTeleportationPacket teleportConfirmPacket = new ServerboundAcceptTeleportationPacket(id);
        session.sendDownstreamGamePacket(teleportConfirmPacket);
        ServerboundMovePlayerPosRotPacket positionPacket = new ServerboundMovePlayerPosRotPacket(false, false, x, y, z, yaw, pitch);
        session.sendDownstreamGamePacket(positionPacket);
    }
}

