/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.text;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.format.TextFormat;
import net.kyori.adventure.text.renderer.TranslatableComponentRenderer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.json.LegacyHoverEventSerializer;
import net.kyori.adventure.text.serializer.legacy.CharacterAndFormat;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.geysermc.geyser.text.ChatDecoration;
import org.geysermc.geyser.text.DummyLegacyHoverEventSerializer;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.GsonComponentSerializerWrapper;
import org.geysermc.geyser.text.MinecraftTranslationRegistry;
import org.geysermc.mcprotocollib.protocol.data.DefaultComponentSerializer;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatTypeDecoration;

public class MessageTranslator {
    private static final TranslatableComponentRenderer<String> RENDERER = new MinecraftTranslationRegistry();
    private static final GsonComponentSerializer GSON_SERIALIZER;
    private static final LegacyComponentSerializer BEDROCK_SERIALIZER;
    private static final String BEDROCK_COLORS;
    private static final String BASE = "\u00a7";
    private static final String RESET = "\u00a7r";
    private static final Pattern RESET_PATTERN;

    public static String convertMessage(Component message, String locale) {
        return MessageTranslator.convertMessage(message, locale, true);
    }

    public static String convertMessageForTooltip(Component message, String locale) {
        return "\u00a7r\u00a77" + MessageTranslator.convertMessageRaw(message, locale);
    }

    public static String convertMessageRaw(Component message, String locale) {
        return MessageTranslator.convertMessage(message, locale, false);
    }

    private static String convertMessage(Component message, String locale, boolean addLeadingResetFormat) {
        try {
            message = RENDERER.render(message, (Object)locale);
            String legacy = BEDROCK_SERIALIZER.serialize(message);
            StringBuilder finalLegacy = new StringBuilder();
            char[] legacyChars = legacy.toCharArray();
            boolean lastFormatReset = !addLeadingResetFormat;
            for (int i = 0; i < legacyChars.length; ++i) {
                char next;
                char legacyChar = legacyChars[i];
                if (legacyChar != '\u00a7' || i >= legacyChars.length - 1) {
                    finalLegacy.append(legacyChar);
                    lastFormatReset = false;
                    continue;
                }
                if (BEDROCK_COLORS.indexOf(next = legacyChars[++i]) != -1 && !lastFormatReset) {
                    finalLegacy.append(RESET);
                }
                finalLegacy.append(BASE).append(next);
                lastFormatReset = next == 'r';
            }
            String finalLegacyString = finalLegacy.toString();
            if ((finalLegacyString = RESET_PATTERN.matcher(finalLegacyString).replaceAll(RESET)).endsWith(RESET)) {
                finalLegacyString = finalLegacyString.substring(0, finalLegacyString.length() - 2);
            }
            if (finalLegacyString.contains("\n")) {
                StringBuilder output = new StringBuilder();
                StringBuilder lastColors = new StringBuilder();
                for (int i = 0; i < finalLegacyString.length(); ++i) {
                    char c = finalLegacyString.charAt(i);
                    output.append(c);
                    if (c == '\u00a7') {
                        char newColor = finalLegacyString.charAt(i + 1);
                        if (newColor == 'r') {
                            lastColors = new StringBuilder();
                            continue;
                        }
                        lastColors.append('\u00a7').append(newColor);
                        continue;
                    }
                    if (c != '\n' || lastColors.isEmpty()) continue;
                    output.append((CharSequence)lastColors);
                }
                return output.toString();
            }
            return finalLegacyString;
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().debug((String)GSON_SERIALIZER.serialize(message));
            GeyserImpl.getInstance().getLogger().error("Failed to parse message", e);
            return "";
        }
    }

    public static String convertJsonMessage(String message, String locale) {
        return MessageTranslator.convertMessage(GSON_SERIALIZER.deserialize((Object)message), locale);
    }

    public static String convertMessage(GeyserSession session, Component message) {
        return MessageTranslator.convertMessage(message, session.locale());
    }

    public static String convertMessage(Component message) {
        return MessageTranslator.convertMessage(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertMessageLenient(String message, String locale) {
        if (message == null) {
            return "";
        }
        if (message.isBlank()) {
            return message;
        }
        try {
            return MessageTranslator.convertJsonMessage(message, locale);
        }
        catch (Exception ignored) {
            Object convertedMessage = MessageTranslator.convertMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message), locale);
            if (message.startsWith(RESET) && !((String)convertedMessage).startsWith(RESET)) {
                convertedMessage = RESET + (String)convertedMessage;
            }
            return convertedMessage;
        }
    }

    public static String convertMessageLenient(String message) {
        return MessageTranslator.convertMessageLenient(message, GeyserLocale.getDefaultLocale());
    }

    public static String convertToJavaMessage(String message) {
        TextComponent component = BEDROCK_SERIALIZER.deserialize(message);
        return (String)GSON_SERIALIZER.serialize((Component)component);
    }

    public static String convertToPlainText(Component message, String locale) {
        if (message == null) {
            return "";
        }
        return PlainTextComponentSerializer.plainText().serialize(RENDERER.render(message, (Object)locale));
    }

    public static String convertToPlainText(String message) {
        char[] input = message.toCharArray();
        char[] output = new char[input.length];
        int outputSize = 0;
        int inputLength = input.length;
        for (int i = 0; i < inputLength; ++i) {
            char c = input[i];
            if (c == '\u00a7') {
                ++i;
                continue;
            }
            output[outputSize++] = c;
        }
        return new String(output, 0, outputSize);
    }

    public static String convertToPlainTextLenient(String message, String locale) {
        if (message == null) {
            return "";
        }
        TextComponent messageComponent = null;
        if (message.startsWith("{") && message.endsWith("}")) {
            try {
                messageComponent = GSON_SERIALIZER.deserialize((Object)message);
                messageComponent = RENDERER.render((Component)messageComponent, (Object)locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageComponent == null) {
            messageComponent = LegacyComponentSerializer.legacySection().deserialize(message);
        }
        return PlainTextComponentSerializer.plainText().serialize(messageComponent);
    }

    public static void handleChatPacket(GeyserSession session, Component message, Holder<ChatType> chatTypeHolder, Component targetName, Component sender) {
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid(session.getAuthData().xuid());
        textPacket.setType(TextPacket.Type.CHAT);
        textPacket.setNeedsTranslation(false);
        ChatType chatType = chatTypeHolder.getOrCompute(session.getRegistryCache().registry(JavaRegistries.CHAT_TYPE)::byId);
        if (chatType != null && chatType.chat() != null) {
            ChatTypeDecoration chat = chatType.chat();
            TranslatableComponent.Builder withDecoration = (TranslatableComponent.Builder)Component.translatable().key(chat.translationKey()).style(ChatDecoration.getStyle(chat));
            List<ChatTypeDecoration.Parameter> parameters = chat.parameters();
            ArrayList<Component> args = new ArrayList<Component>(3);
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.TARGET)) {
                args.add(targetName);
            }
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.SENDER)) {
                args.add(sender);
            }
            if (parameters.contains((Object)ChatTypeDecoration.Parameter.CONTENT)) {
                args.add(message);
            }
            withDecoration.arguments(args);
            textPacket.setMessage(MessageTranslator.convertMessage((Component)withDecoration.build(), session.locale()));
        } else {
            session.getGeyser().getLogger().debug("Likely illegal chat type detection found.");
            if (session.getGeyser().getConfig().isDebugMode()) {
                Thread.dumpStack();
            }
            textPacket.setMessage(MessageTranslator.convertMessage(message, session.locale()));
        }
        session.sendUpstreamPacket(textPacket);
    }

    public static boolean isTooLong(String message, GeyserSession session) {
        if (message.length() > 256) {
            session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.too_long", session.locale(), message.length()));
            return true;
        }
        return false;
    }

    public static String normalizeSpace(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        int size = string.length();
        char[] newChars = new char[size];
        int count = 0;
        int whitespacesCount = 0;
        boolean startWhitespaces = true;
        for (int i = 0; i < size; ++i) {
            char actualChar = string.charAt(i);
            boolean isWhitespace = Character.isWhitespace(actualChar);
            if (isWhitespace) {
                if (whitespacesCount == 0 && !startWhitespaces) {
                    newChars[count++] = 32;
                }
                ++whitespacesCount;
                continue;
            }
            startWhitespaces = false;
            newChars[count++] = actualChar == '\u00a0' ? 32 : (int)actualChar;
            whitespacesCount = 0;
        }
        if (startWhitespaces) {
            return "";
        }
        return new String(newChars, 0, count - (whitespacesCount > 0 ? 1 : 0)).trim();
    }

    public static String deserializeDescription(GeyserSession session, NbtMap tag) {
        Object description = tag.get((Object)"description");
        Component parsed = MessageTranslator.componentFromNbtTag(description);
        return MessageTranslator.convertMessage(session, parsed);
    }

    public static String deserializeDescriptionForTooltip(GeyserSession session, NbtMap tag) {
        Object description = tag.get((Object)"description");
        Component parsed = MessageTranslator.componentFromNbtTag(description);
        return MessageTranslator.convertMessageForTooltip(parsed, session.locale());
    }

    public static Component componentFromNbtTag(Object nbtTag) {
        return MessageTranslator.componentFromNbtTag(nbtTag, Style.empty());
    }

    public static List<String> signTextFromNbtTag(GeyserSession session, List<?> nbtTag) {
        List<Component> components = MessageTranslator.componentsFromNbtList(nbtTag, Style.empty());
        ArrayList<String> messages = new ArrayList<String>();
        for (Component component : components) {
            messages.add(MessageTranslator.convertMessageRaw(component, session.locale()));
        }
        return messages;
    }

    private static Component componentFromNbtTag(Object nbtTag, Style style) {
        if (nbtTag instanceof String) {
            String literal = (String)nbtTag;
            return Component.text((String)literal).style(style);
        }
        if (nbtTag instanceof List) {
            List list = (List)nbtTag;
            return Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), MessageTranslator.componentsFromNbtList(list, style));
        }
        if (nbtTag instanceof NbtMap) {
            NbtMap map = (NbtMap)nbtTag;
            TextComponent component = null;
            String text = map.getString("text", map.getString("", null));
            if (text != null) {
                component = Component.text((String)text);
            } else {
                String translateKey = map.getString("translate", null);
                if (translateKey != null) {
                    String fallback = map.getString("fallback", "");
                    List<Component> args = new ArrayList<Component>();
                    Object with = map.get((Object)"with");
                    if (with instanceof List) {
                        List list = (List)with;
                        args = MessageTranslator.componentsFromNbtList(list, style);
                    } else if (with != null) {
                        args.add(MessageTranslator.componentFromNbtTag(with, style));
                    }
                    component = Component.translatable((String)translateKey, (String)fallback, args, (StyleBuilderApplicable[])new StyleBuilderApplicable[0]);
                }
            }
            if (component != null) {
                Style newStyle = MessageTranslator.getStyleFromNbtMap(map, style);
                component = component.style(newStyle);
                Object extra = map.get((Object)"extra");
                if (extra != null) {
                    component = component.append(MessageTranslator.componentFromNbtTag(extra, newStyle));
                }
                return component;
            }
        }
        GeyserImpl.getInstance().getLogger().error("Expected tag to be a literal string, a list of components, or a component object with a text/translate key: " + String.valueOf(nbtTag));
        return Component.empty();
    }

    private static List<Component> componentsFromNbtList(List<?> list, Style style) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Object entry : list) {
            components.add(MessageTranslator.componentFromNbtTag(entry, style));
        }
        return components;
    }

    public static Style getStyleFromNbtMap(NbtMap map) {
        Style.Builder style = Style.style();
        String colorString = map.getString("color", null);
        if (colorString != null) {
            if (colorString.startsWith("#")) {
                style.color(TextColor.fromHexString((String)colorString));
            } else {
                style.color((TextColor)NamedTextColor.NAMES.value((Object)colorString));
            }
        }
        map.listenForBoolean("bold", value -> style.decoration(TextDecoration.BOLD, value));
        map.listenForBoolean("italic", value -> style.decoration(TextDecoration.ITALIC, value));
        map.listenForBoolean("underlined", value -> style.decoration(TextDecoration.UNDERLINED, value));
        map.listenForBoolean("strikethrough", value -> style.decoration(TextDecoration.STRIKETHROUGH, value));
        map.listenForBoolean("obfuscated", value -> style.decoration(TextDecoration.OBFUSCATED, value));
        return style.build();
    }

    public static Style getStyleFromNbtMap(NbtMap map, Style base) {
        return base.merge(MessageTranslator.getStyleFromNbtMap(map));
    }

    public static void init() {
    }

    static {
        RESET_PATTERN = Pattern.compile("(\u00a7r){2,}");
        GsonComponentSerializer source = ((GsonComponentSerializer.Builder)DefaultComponentSerializer.get().toBuilder()).legacyHoverEventSerializer((LegacyHoverEventSerializer)new DummyLegacyHoverEventSerializer()).build();
        GSON_SERIALIZER = new GsonComponentSerializerWrapper(source);
        DefaultComponentSerializer.set(GSON_SERIALIZER);
        ArrayList<CharacterAndFormat> formats = new ArrayList<CharacterAndFormat>(CharacterAndFormat.defaults());
        formats.remove(CharacterAndFormat.STRIKETHROUGH);
        formats.remove(CharacterAndFormat.UNDERLINED);
        formats.add(CharacterAndFormat.characterAndFormat((char)'g', (TextFormat)TextColor.color((int)221, (int)214, (int)5)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'h', (TextFormat)TextColor.color((int)227, (int)212, (int)209)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'i', (TextFormat)TextColor.color((int)206, (int)202, (int)202)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'j', (TextFormat)TextColor.color((int)68, (int)58, (int)59)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'m', (TextFormat)TextColor.color((int)151, (int)22, (int)7)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'n', (TextFormat)TextColor.color((int)180, (int)104, (int)77)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'p', (TextFormat)TextColor.color((int)222, (int)177, (int)45)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'q', (TextFormat)TextColor.color((int)17, (int)160, (int)54)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'s', (TextFormat)TextColor.color((int)44, (int)186, (int)168)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'t', (TextFormat)TextColor.color((int)33, (int)73, (int)123)));
        formats.add(CharacterAndFormat.characterAndFormat((char)'u', (TextFormat)TextColor.color((int)154, (int)92, (int)198)));
        ComponentFlattener flattener = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).mapper(ScoreComponent.class, component -> "").build();
        BEDROCK_SERIALIZER = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacySection().toBuilder()).formats(formats).flattener(flattener).build();
        StringBuilder colorBuilder = new StringBuilder();
        for (CharacterAndFormat format : formats) {
            if (!(format.format() instanceof TextColor)) continue;
            colorBuilder.append(format.character());
        }
        BEDROCK_COLORS = colorBuilder.toString();
    }
}

