/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.helper.TransportHelper;
import org.geysermc.mcprotocollib.network.netty.DefaultPacketHandlerExecutor;
import org.geysermc.mcprotocollib.network.netty.MinecraftChannelInitializer;
import org.geysermc.mcprotocollib.network.server.AbstractServer;
import org.geysermc.mcprotocollib.network.session.NetworkSession;
import org.geysermc.mcprotocollib.network.session.ServerNetworkSession;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkServer
extends AbstractServer {
    private static final Logger log = LoggerFactory.getLogger(NetworkServer.class);
    private final Supplier<Executor> packetHandlerExecutorFactory;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private Channel channel;

    public NetworkServer(SocketAddress bindAddress, Supplier<? extends MinecraftProtocol> protocol) {
        this(bindAddress, protocol, DefaultPacketHandlerExecutor::createExecutor);
    }

    public NetworkServer(SocketAddress bindAddress, Supplier<? extends MinecraftProtocol> protocol, Supplier<Executor> packetHandlerExecutorFactory) {
        super(bindAddress, protocol);
        this.packetHandlerExecutorFactory = packetHandlerExecutorFactory;
    }

    @Override
    public boolean isListening() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public void bindImpl(boolean wait, Runnable callback) {
        if (this.bossGroup != null || this.workerGroup != null || this.channel != null) {
            return;
        }
        this.bossGroup = this.createBossEventLoopGroup();
        this.workerGroup = this.createWorkerEventLoopGroup();
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(this.getChannelFactory())).group(this.bossGroup, this.workerGroup).localAddress(this.getBindAddress())).childHandler(this.getChannelHandler());
        this.setOptions(bootstrap);
        CompletableFuture handleFuture = new CompletableFuture();
        bootstrap.bind().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                this.channel = future.channel();
                if (callback != null) {
                    callback.run();
                }
            } else {
                log.error("Failed to bind connection listener.", future.cause());
            }
            handleFuture.complete(null);
        }));
        if (wait) {
            handleFuture.join();
        }
    }

    protected ChannelFactory<? extends ServerChannel> getChannelFactory() {
        return TransportHelper.TRANSPORT_TYPE.serverSocketChannelFactory();
    }

    protected EventLoopGroup createBossEventLoopGroup() {
        return TransportHelper.TRANSPORT_TYPE.eventLoopGroupFactory().apply(null);
    }

    protected EventLoopGroup createWorkerEventLoopGroup() {
        return TransportHelper.TRANSPORT_TYPE.eventLoopGroupFactory().apply(null);
    }

    protected void setOptions(ServerBootstrap bootstrap) {
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.IP_TOS, (Object)24);
        if (this.getGlobalFlag(BuiltinFlags.TCP_FAST_OPEN, false).booleanValue() && TransportHelper.TRANSPORT_TYPE.supportsTcpFastOpenServer()) {
            bootstrap.option(ChannelOption.TCP_FASTOPEN, (Object)3);
        }
    }

    protected ChannelHandler getChannelHandler() {
        return new MinecraftChannelInitializer<NetworkSession>(channel -> {
            MinecraftProtocol protocol = this.createPacketProtocol();
            ServerNetworkSession session = new ServerNetworkSession(channel.remoteAddress(), protocol, this, this.packetHandlerExecutorFactory.get());
            session.getPacketProtocol().newServerSession(this, session);
            return session;
        }, false);
    }

    @Override
    public void closeImpl(boolean wait, Runnable callback) {
        this.closeChannel(callback, wait);
        this.closeWorkerGroup(wait);
        this.closeBossGroup(wait);
    }

    private void closeChannel(Runnable callback, boolean wait) {
        if (this.channel == null) {
            return;
        }
        if (this.channel.isOpen()) {
            CompletableFuture handleFuture = new CompletableFuture();
            this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    if (callback != null) {
                        callback.run();
                    }
                } else {
                    log.error("Failed to close connection listener.", future.cause());
                }
                handleFuture.complete(null);
            }));
            if (wait) {
                handleFuture.join();
            }
        }
        this.channel = null;
    }

    private void closeWorkerGroup(boolean wait) {
        if (this.workerGroup == null) {
            return;
        }
        CompletableFuture handleFuture = new CompletableFuture();
        this.workerGroup.shutdownGracefully().addListener(future -> {
            if (!future.isSuccess()) {
                log.debug("Failed to close connection listener.", future.cause());
            }
            handleFuture.complete(null);
        });
        if (wait) {
            handleFuture.join();
        }
        this.workerGroup = null;
    }

    private void closeBossGroup(boolean wait) {
        if (this.bossGroup == null) {
            return;
        }
        CompletableFuture handleFuture = new CompletableFuture();
        this.bossGroup.shutdownGracefully().addListener(future -> {
            if (!future.isSuccess()) {
                log.debug("Failed to close connection listener.", future.cause());
            }
            handleFuture.complete(null);
        });
        if (wait) {
            handleFuture.join();
        }
        this.bossGroup = null;
    }
}

