/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.registry.mappings.util.CustomBlockMapping;
import org.geysermc.geyser.registry.mappings.versions.MappingsReader;
import org.geysermc.geyser.registry.mappings.versions.MappingsReader_v1;

public class MappingsConfigReader {
    private final Int2ObjectMap<MappingsReader> mappingReaders = new Int2ObjectOpenHashMap<MappingsReader>();
    private final Path customMappingsDirectory = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("custom_mappings");

    public MappingsConfigReader() {
        this.mappingReaders.put(1, (MappingsReader)new MappingsReader_v1());
    }

    public Path[] getCustomMappingsFiles() {
        try {
            return (Path[])Files.walk(this.customMappingsDirectory, new FileVisitOption[0]).filter(child -> child.toString().endsWith(".json")).toArray(Path[]::new);
        }
        catch (IOException e) {
            return new Path[0];
        }
    }

    public boolean ensureMappingsDirectory(Path mappingsDirectory) {
        if (!Files.exists(mappingsDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(mappingsDirectory, new FileAttribute[0]);
                return true;
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().error("Failed to create mappings directory", e);
                return false;
            }
        }
        return true;
    }

    public void loadItemMappingsFromJson(BiConsumer<String, CustomItemData> consumer) {
        Path[] mappingsFiles;
        if (!this.ensureMappingsDirectory(this.customMappingsDirectory)) {
            return;
        }
        for (Path mappingsFile : mappingsFiles = this.getCustomMappingsFiles()) {
            this.readItemMappingsFromJson(mappingsFile, consumer);
        }
    }

    public void loadBlockMappingsFromJson(BiConsumer<String, CustomBlockMapping> consumer) {
        Path[] mappingsFiles;
        if (!this.ensureMappingsDirectory(this.customMappingsDirectory)) {
            return;
        }
        for (Path mappingsFile : mappingsFiles = this.getCustomMappingsFiles()) {
            this.readBlockMappingsFromJson(mappingsFile, consumer);
        }
    }

    public @Nullable JsonObject getMappingsRoot(Path file) {
        JsonObject mappingsRoot;
        try (FileReader reader = new FileReader(file.toFile());){
            mappingsRoot = (JsonObject)new JsonParser().parse((Reader)reader);
        }
        catch (IOException e) {
            GeyserImpl.getInstance().getLogger().error("Failed to read custom mapping file: " + String.valueOf(file), e);
            return null;
        }
        if (!mappingsRoot.has("format_version")) {
            GeyserImpl.getInstance().getLogger().error("Mappings file " + String.valueOf(file) + " is missing the format version field!");
            return null;
        }
        return mappingsRoot;
    }

    public int getFormatVersion(JsonObject mappingsRoot, Path file) {
        int formatVersion = mappingsRoot.get("format_version").getAsInt();
        if (!this.mappingReaders.containsKey(formatVersion)) {
            GeyserImpl.getInstance().getLogger().error("Mappings file " + String.valueOf(file) + " has an unknown format version: " + formatVersion);
            return -1;
        }
        return formatVersion;
    }

    public void readItemMappingsFromJson(Path file, BiConsumer<String, CustomItemData> consumer) {
        JsonObject mappingsRoot = this.getMappingsRoot(file);
        if (mappingsRoot == null) {
            return;
        }
        int formatVersion = this.getFormatVersion(mappingsRoot, file);
        if (formatVersion < 0) {
            return;
        }
        ((MappingsReader)this.mappingReaders.get(formatVersion)).readItemMappings(file, mappingsRoot, consumer);
    }

    public void readBlockMappingsFromJson(Path file, BiConsumer<String, CustomBlockMapping> consumer) {
        JsonObject mappingsRoot = this.getMappingsRoot(file);
        if (mappingsRoot == null) {
            return;
        }
        int formatVersion = this.getFormatVersion(mappingsRoot, file);
        if (formatVersion < 0) {
            return;
        }
        ((MappingsReader)this.mappingReaders.get(formatVersion)).readBlockMappings(file, mappingsRoot, consumer);
    }
}

