/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.property;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.geysermc.geyser.level.block.property.Property;

public final class EnumProperty<T extends Enum<T>>
extends Property<T> {
    private final IntList ordinalValues;

    private EnumProperty(String name, T[] values) {
        super(name);
        this.ordinalValues = new IntArrayList(values.length);
        for (T anEnum : values) {
            this.ordinalValues.add(((Enum)anEnum).ordinal());
        }
    }

    @Override
    public int valuesCount() {
        return this.ordinalValues.size();
    }

    @Override
    public int indexOf(T value) {
        return this.ordinalValues.indexOf(((Enum)value).ordinal());
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumProperty<T> create(String name, T ... values) {
        return new EnumProperty(name, values);
    }
}

