/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationVisitor;

public final class ConfigurationCommentMover
implements ConfigurationVisitor.Stateless<RuntimeException> {
    private final CommentedConfigurationNode otherRoot;

    private ConfigurationCommentMover(@NonNull CommentedConfigurationNode otherNode) {
        this.otherRoot = otherNode;
    }

    public void enterNode(ConfigurationNode node) {
        if (!(node instanceof CommentedConfigurationNode)) {
            throw new IllegalStateException(String.valueOf(node.path()) + " is not a CommentedConfigurationNode");
        }
        CommentedConfigurationNode destination = (CommentedConfigurationNode)node;
        CommentedConfigurationNode source = (CommentedConfigurationNode)this.otherRoot.node((Iterable)node.path());
        ConfigurationCommentMover.moveSingle(source, destination);
    }

    private static void moveSingle(@NonNull CommentedConfigurationNode source, @NonNull CommentedConfigurationNode destination) {
        String comment = source.comment();
        if (comment != null) {
            destination.comment(comment);
        }
    }

    public static void moveComments(@NonNull CommentedConfigurationNode source, @NonNull CommentedConfigurationNode destination) {
        if (source.parent() != null) {
            throw new IllegalArgumentException("source is not the base of the tree it is within: " + String.valueOf(source.path()));
        }
        if (source.isNull()) {
            ConfigurationCommentMover.moveSingle(source, destination);
        } else {
            destination.visit((ConfigurationVisitor)new ConfigurationCommentMover(source));
        }
    }
}

