/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.geysermc.erosion.packet.ErosionPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBatchBlockEntityPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBatchBlockRequestPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBlockEntityPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundBlockRequestPacket;
import org.geysermc.erosion.packet.backendbound.BackendboundInitializePacket;
import org.geysermc.erosion.packet.backendbound.BackendboundPickBlockPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBatchBlockIdPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockEntityPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockIdPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockLookupFailPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundBlockPlacePacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundHandshakePacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPickBlockPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPistonEventPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.VarInts;

public final class Packets {
    public static final Object2IntMap<Class<? extends ErosionPacket<?>>> SENDING = new Object2IntOpenHashMap();
    public static final List<Function<ByteBuf, ? extends ErosionPacket<?>>> RECEIVING = new ArrayList();
    private static boolean INITIALIZED = false;

    public static void initBackend() {
        if (INITIALIZED) {
            return;
        }
        int id = 0;
        Packets.registerSending(GeyserboundHandshakePacket.class, id++);
        Packets.registerSending(GeyserboundBatchBlockIdPacket.class, id++);
        Packets.registerSending(GeyserboundBlockEntityPacket.class, id++);
        Packets.registerSending(GeyserboundBlockIdPacket.class, id++);
        Packets.registerSending(GeyserboundBlockLookupFailPacket.class, id++);
        Packets.registerSending(GeyserboundBlockPlacePacket.class, id++);
        Packets.registerSending(GeyserboundPickBlockPacket.class, id++);
        Packets.registerSending(GeyserboundPistonEventPacket.class, id++);
        Packets.registerReceiving(BackendboundInitializePacket::new);
        Packets.registerReceiving(BackendboundBatchBlockEntityPacket::new);
        Packets.registerReceiving(BackendboundBatchBlockRequestPacket::new);
        Packets.registerReceiving(BackendboundBlockEntityPacket::new);
        Packets.registerReceiving(BackendboundBlockRequestPacket::new);
        Packets.registerReceiving(BackendboundPickBlockPacket::new);
        INITIALIZED = true;
    }

    public static void initGeyser() {
        if (INITIALIZED) {
            return;
        }
        int id = 0;
        Packets.registerSending(BackendboundInitializePacket.class, id++);
        Packets.registerSending(BackendboundBatchBlockEntityPacket.class, id++);
        Packets.registerSending(BackendboundBatchBlockRequestPacket.class, id++);
        Packets.registerSending(BackendboundBlockEntityPacket.class, id++);
        Packets.registerSending(BackendboundBlockRequestPacket.class, id++);
        Packets.registerSending(BackendboundPickBlockPacket.class, id++);
        Packets.registerReceiving(GeyserboundHandshakePacket::new);
        Packets.registerReceiving(GeyserboundBatchBlockIdPacket::new);
        Packets.registerReceiving(GeyserboundBlockEntityPacket::new);
        Packets.registerReceiving(GeyserboundBlockIdPacket::new);
        Packets.registerReceiving(GeyserboundBlockLookupFailPacket::new);
        Packets.registerReceiving(GeyserboundBlockPlacePacket::new);
        Packets.registerReceiving(GeyserboundPickBlockPacket::new);
        Packets.registerReceiving(GeyserboundPistonEventPacket::new);
        INITIALIZED = true;
    }

    private static void registerSending(Class<? extends ErosionPacket<?>> packetClass, int id) {
        SENDING.put(packetClass, id);
    }

    private static void registerReceiving(Function<ByteBuf, ? extends ErosionPacket<?>> constructor) {
        RECEIVING.add(constructor);
    }

    public static ErosionPacket<?> decode(ByteBuf in) {
        int id = VarInts.readUnsignedInt(in);
        if (id >= RECEIVING.size()) {
            throw new RuntimeException("ID " + id + " does not exist");
        }
        Function<ByteBuf, ErosionPacket<?>> constructor = RECEIVING.get(id);
        ErosionPacket<?> packet = constructor.apply(in);
        if (in.isReadable()) {
            StringBuilder builder = new StringBuilder("There are leftover bytes to read after reading " + String.valueOf(packet.getClass()));
            ByteBufUtil.appendPrettyHexDump((StringBuilder)builder, (ByteBuf)in);
            throw new RuntimeException(builder.toString());
        }
        return packet;
    }

    public static void encode(ByteBuf out, ErosionPacket<?> packet) throws IOException {
        int id = SENDING.getOrDefault(packet.getClass(), -1);
        if (id == -1) {
            throw new IOException("Unregistered packet class! " + String.valueOf(packet));
        }
        VarInts.writeUnsignedInt(out, id);
        packet.serialize(out);
    }

    private Packets() {
    }
}

