/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import java.io.IOException;
import java.util.List;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.MinecraftVersion;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.context.CommandContext;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.WebUtils;

public class VersionCommand
extends GeyserCommand {
    private static final String SUPPORTED_BEDROCK_RANGE;
    private static final String SUPPORTED_JAVA_RANGE;
    private final GeyserImpl geyser;

    public VersionCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission, TriState.NOT_SET);
        this.geyser = geyser;
    }

    @Override
    public void execute(CommandContext<GeyserCommandSource> context) {
        GeyserCommandSource source = context.sender();
        source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.version", source.locale(), "Geyser", "2.8.4-b943 (git-master-a1cb9bd)", SUPPORTED_JAVA_RANGE, SUPPORTED_BEDROCK_RANGE));
        if (!GeyserImpl.getInstance().isProductionEnvironment() || !source.isConsole() && this.geyser.getPlatformType() == PlatformType.STANDALONE) {
            return;
        }
        if (GeyserImpl.IS_DEV) {
            source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.core.dev_build", source.locale(), "https://discord.gg/geysermc"));
            return;
        }
        source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.checking", source.locale()));
        try {
            int buildNumber = this.geyser.buildNumber();
            JsonNode response = WebUtils.getJson("https://download.geysermc.org/v2/projects/geyser/versions/latest/builds/latest");
            int latestBuildNumber = response.get("build").asInt();
            if (latestBuildNumber == buildNumber) {
                source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.no_updates", source.locale()));
                return;
            }
            source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.version.outdated", source.locale(), latestBuildNumber - buildNumber, "https://geysermc.org/download"));
        }
        catch (IOException e) {
            GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.version.failed"), e);
            source.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.version.failed", source.locale()));
        }
    }

    static {
        List<MinecraftVersion> bedrockVersions = GameProtocol.SUPPORTED_BEDROCK_VERSIONS;
        SUPPORTED_BEDROCK_RANGE = bedrockVersions.size() > 1 ? bedrockVersions.get(0).versionString() + " - " + bedrockVersions.get(bedrockVersions.size() - 1).versionString() : bedrockVersions.get(0).versionString();
        List<String> javaVersions = GameProtocol.getJavaVersions();
        SUPPORTED_JAVA_RANGE = javaVersions.size() > 1 ? javaVersions.get(0) + " - " + javaVersions.get(javaVersions.size() - 1) : javaVersions.get(0);
    }
}

