/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.level.BedrockDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.util.AttributeUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class SessionPlayerEntity
extends PlayerEntity {
    protected final Map<GeyserAttributeType, AttributeData> attributes = new Object2ObjectOpenHashMap();
    private double blockInteractionRange = GeyserAttributeType.BLOCK_INTERACTION_RANGE.getDefaultValue();
    private boolean isRidingInFront;
    private Vector2f vehicleInput = Vector2f.ZERO;
    private int vehicleJumpStrength;
    private int lastAirSupply = this.getMaxAir();
    private boolean voidPositionDesynched;

    public SessionPlayerEntity(GeyserSession session) {
        super(session, -1, 1L, null, Vector3f.ZERO, Vector3f.ZERO, 0.0f, 0.0f, 0.0f, null, null);
        this.valid = true;
    }

    @Override
    protected void setClientSideSilent() {
    }

    @Override
    public void spawnEntity() {
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        if (this.voidPositionDesynched && !this.isBelowVoidFloor()) {
            this.voidPositionDesynched = false;
        }
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
        this.session.getCollisionManager().updatePlayerBoundingBox(this.position.down(this.definition.offset()));
    }

    @Override
    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        if (this.voidPositionDesynched && !this.isBelowVoidFloor()) {
            this.voidPositionDesynched = false;
        }
        super.moveAbsolute(position, yaw, pitch, headYaw, isOnGround, teleported);
    }

    @Override
    public void setPosition(Vector3f position) {
        if (this.valid) {
            this.session.getCollisionManager().updatePlayerBoundingBox(position);
        }
        this.position = position.add(0.0f, this.definition.offset(), 0.0f);
    }

    public void updateOwnRotation(float yaw, float pitch, float headYaw) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(this.isOnGround());
        movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
        movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
        this.session.sendUpstreamPacket(movePlayerPacket);
    }

    public void setPositionManual(Vector3f position) {
        this.position = position;
    }

    @Override
    public void setFlags(ByteEntityMetadata entityMetadata) {
        if (!this.session.getGameMode().equals(GameMode.SPECTATOR)) {
            super.setFlags(entityMetadata);
        }
    }

    public void updateBoundingBox() {
        this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(this.getBoundingBoxHeight()));
        this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(this.getBoundingBoxWidth()));
        this.updateBedrockMetadata();
    }

    @Override
    public boolean setBoundingBoxHeight(float height) {
        if (super.setBoundingBoxHeight(height)) {
            if (this.valid) {
                this.session.getCollisionManager().updatePlayerBoundingBox();
            }
            return true;
        }
        return false;
    }

    @Override
    public void setPose(Pose pose) {
        super.setPose(pose);
        this.session.setPose(pose);
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    @Override
    protected void setAirSupply(int amount) {
        this.setFlag(EntityFlag.BREATHING, amount >= this.lastAirSupply);
        this.lastAirSupply = amount;
        super.setAirSupply(amount);
    }

    @Override
    public void setRiderSeatPosition(Vector3f position) {
        super.setRiderSeatPosition(position);
        this.isRidingInFront = position != null && position.getX() > 0.0f;
    }

    @Override
    public AttributeData createHealthAttribute() {
        if (this.maxHealth % 2.0f == 1.0f) {
            this.maxHealth += 1.0f;
        }
        return super.createHealthAttribute();
    }

    @Override
    protected boolean hasShield(boolean offhand) {
        if (offhand) {
            return this.session.getPlayerInventory().getOffhand().asItem() == Items.SHIELD;
        }
        return this.session.getPlayerInventory().getItemInHand().asItem() == Items.SHIELD;
    }

    @Override
    protected void updateAttribute(Attribute javaAttribute, List<AttributeData> newAttributes) {
        if (javaAttribute.getType() == AttributeType.Builtin.ATTACK_SPEED) {
            this.session.setAttackSpeed(AttributeUtils.calculateValue(javaAttribute));
        } else if (javaAttribute.getType() == AttributeType.Builtin.BLOCK_INTERACTION_RANGE) {
            this.blockInteractionRange = AttributeUtils.calculateValue(javaAttribute);
        } else {
            super.updateAttribute(javaAttribute, newAttributes);
        }
    }

    @Override
    protected AttributeData calculateAttribute(Attribute javaAttribute, GeyserAttributeType type) {
        AttributeData attributeData = super.calculateAttribute(javaAttribute, type);
        this.attributes.put(type, attributeData);
        return attributeData;
    }

    public float attributeOrDefault(GeyserAttributeType type) {
        AttributeData attribute = this.attributes.get((Object)type);
        if (attribute == null) {
            return type.getDefaultValue();
        }
        return attribute.getValue();
    }

    public void setLastDeathPosition(@Nullable GlobalPos pos) {
        if (pos != null) {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_LAST_DEATH_POS, pos.getPosition());
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_LAST_DEATH_DIMENSION, DimensionUtils.javaToBedrock(pos.getDimension().asString()));
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_HAS_DIED, true);
        } else {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_HAS_DIED, false);
        }
        this.setVoidPositionDesynched(false);
    }

    @Override
    public UUID getTabListUuid() {
        return this.session.getAuthData().uuid();
    }

    @Override
    public void setAbsorptionHearts(FloatEntityMetadata entityMetadata) {
        this.attributes.put(GeyserAttributeType.ABSORPTION, GeyserAttributeType.ABSORPTION.getAttribute(entityMetadata.getPrimitiveValue()));
        super.setAbsorptionHearts(entityMetadata);
    }

    @Override
    public void resetMetadata() {
        super.resetMetadata();
        this.resetAir();
        this.attributes.remove((Object)GeyserAttributeType.ABSORPTION);
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.ABSORPTION.getAttribute(0.0f)));
        this.session.sendUpstreamPacket(attributesPacket);
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, 0);
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_AMBIENCE, (byte)0);
        this.dirtyMetadata.put(EntityDataTypes.FREEZING_EFFECT_STRENGTH, Float.valueOf(0.0f));
        this.silent = false;
    }

    public void resetAttributes() {
        this.attributes.clear();
        this.maxHealth = GeyserAttributeType.MAX_HEALTH.getDefaultValue();
        this.blockInteractionRange = GeyserAttributeType.BLOCK_INTERACTION_RANGE.getDefaultValue();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.MOVEMENT_SPEED.getAttribute()));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void resetAir() {
        this.setAirSupply(this.getMaxAir());
    }

    public void setVehicleInput(Vector2f vehicleInput) {
        this.vehicleInput = Vector2f.from((float)MathUtils.clamp(vehicleInput.getX(), -1.0f, 1.0f), (float)MathUtils.clamp(vehicleInput.getY(), -1.0f, 1.0f));
    }

    public void setVehicleJumpStrength(int vehicleJumpStrength) {
        this.vehicleJumpStrength = MathUtils.constrain(vehicleJumpStrength, 0, 100);
    }

    private boolean isBelowVoidFloor() {
        return this.position.getY() < (float)this.voidFloorPosition();
    }

    public int voidFloorPosition() {
        BedrockDimension bedrockDimension = this.session.getBedrockDimension();
        return bedrockDimension.minY() - 40;
    }

    public void teleportVoidFloorFix(boolean up) {
        if (this.voidPositionDesynched && !up || !this.voidPositionDesynched && up) {
            return;
        }
        Vector3f newPosition = this.getPosition();
        if (up) {
            newPosition = newPosition.up(4.0f);
            this.voidPositionDesynched = false;
        } else {
            newPosition = newPosition.down(4.0f);
            this.voidPositionDesynched = true;
        }
        this.setPositionManual(newPosition);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(newPosition);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
        movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
        this.session.sendUpstreamPacketImmediately(movePlayerPacket);
    }

    public Map<GeyserAttributeType, AttributeData> getAttributes() {
        return this.attributes;
    }

    public double getBlockInteractionRange() {
        return this.blockInteractionRange;
    }

    public boolean isRidingInFront() {
        return this.isRidingInFront;
    }

    public Vector2f getVehicleInput() {
        return this.vehicleInput;
    }

    public int getVehicleJumpStrength() {
        return this.vehicleJumpStrength;
    }

    public boolean isVoidPositionDesynched() {
        return this.voidPositionDesynched;
    }

    public void setVoidPositionDesynched(boolean voidPositionDesynched) {
        this.voidPositionDesynched = voidPositionDesynched;
    }
}

