/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import com.google.common.hash.HashCode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.components.Rarity;
import org.geysermc.geyser.item.hashing.ComponentHasher;
import org.geysermc.geyser.item.hashing.MapBuilder;
import org.geysermc.geyser.item.hashing.MinecraftHashEncoder;
import org.geysermc.geyser.item.hashing.MinecraftHasher;
import org.geysermc.geyser.item.hashing.RegistryHasher;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.data.game.item.HashedStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BlockStateProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BlocksAttacks;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Consumable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ConsumeEffect;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.CustomModelData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Fireworks;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.FoodProperties;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.IntComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemAttributeModifiers;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.LodestoneTracker;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectDetails;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.MobEffectInstance;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ToolData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.TooltipDisplay;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Unit;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.UseCooldown;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Weapon;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WritableBookContent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.WrittenBookContent;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;

public class DataComponentHashers {
    private static final Map<DataComponentType<?>, MinecraftHasher<?>> hashers = new HashMap();

    private static void registerUnit(DataComponentType<Unit> component) {
        DataComponentHashers.register(component, MinecraftHasher.UNIT);
    }

    private static void registerInt(IntComponentType component) {
        DataComponentHashers.register(component, MinecraftHasher.INT);
    }

    private static <T> void registerMap(DataComponentType<T> component, MapBuilder<T> builder) {
        DataComponentHashers.register(component, MinecraftHasher.mapBuilder(builder));
    }

    private static <T> void register(DataComponentType<T> component, MinecraftHasher<T> hasher) {
        if (hashers.containsKey(component)) {
            throw new IllegalArgumentException("Tried to register a hasher for a component twice");
        }
        hashers.put(component, hasher);
    }

    public static <T> MinecraftHasher<T> hasher(DataComponentType<T> component) {
        MinecraftHasher<?> hasher = hashers.get(component);
        if (hasher == null) {
            throw new IllegalStateException("Unregistered hasher for component " + String.valueOf(component) + "!");
        }
        return hasher;
    }

    public static <T> HashCode hash(GeyserSession session, DataComponentType<T> component, T value) {
        try {
            return DataComponentHashers.hasher(component).hash(value, new MinecraftHashEncoder(session));
        }
        catch (Exception exception) {
            GeyserImpl.getInstance().getLogger().error("Failed to hash item data component " + String.valueOf(component.getKey()) + " with value " + String.valueOf(value) + "!");
            GeyserImpl.getInstance().getLogger().error("This is a Geyser bug, please report this!");
            throw exception;
        }
    }

    public static HashedStack hashStack(GeyserSession session, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        DataComponents patch = stack.getDataComponentsPatch();
        if (patch == null) {
            return new HashedStack(stack.getId(), stack.getAmount(), Map.of(), Set.of());
        }
        Map<DataComponentType<?>, DataComponent<?, ?>> components = patch.getDataComponents();
        HashMap hashedAdditions = new HashMap();
        HashSet removals = new HashSet();
        for (Map.Entry<DataComponentType<?>, DataComponent<?, ?>> component : components.entrySet()) {
            if (component.getValue().getValue() == null) {
                removals.add(component.getKey());
                continue;
            }
            hashedAdditions.put(component.getKey(), DataComponentHashers.hash(session, component.getKey(), component.getValue().getValue()).asInt());
        }
        return new HashedStack(stack.getId(), stack.getAmount(), hashedAdditions, removals);
    }

    public static void testHashing(GeyserSession session) {
        NbtMap customData = NbtMap.builder().putString("hello", "g'day").putBoolean("nice?", false).putByte("coolness", (byte)100).putCompound("geyser", NbtMap.builder().putString("is", "very cool").build()).putList("a list", NbtType.LIST, List.of(new NbtList(NbtType.STRING, (Object[])new String[]{"in a list"}))).build();
        DataComponentHashers.testHash(session, DataComponentTypes.CUSTOM_DATA, customData, -385053299);
        DataComponentHashers.testHash(session, DataComponentTypes.MAX_STACK_SIZE, 64, 733160003);
        DataComponentHashers.testHash(session, DataComponentTypes.MAX_DAMAGE, 13, -801733367);
        DataComponentHashers.testHash(session, DataComponentTypes.DAMAGE, 459, 1211405277);
        DataComponentHashers.testHash(session, DataComponentTypes.UNBREAKABLE, Unit.INSTANCE, -982207288);
        DataComponentHashers.testHash(session, DataComponentTypes.CUSTOM_NAME, Component.text((String)"simple component test!"), 950545066);
        DataComponentHashers.testHash(session, DataComponentTypes.CUSTOM_NAME, Component.translatable((String)"a.translatable"), 1983484873);
        DataComponentHashers.testHash(session, DataComponentTypes.CUSTOM_NAME, Component.text((String)"component with *style*").style(style -> style.color((TextColor)NamedTextColor.RED).decorate(TextDecoration.ITALIC)), -886479206);
        DataComponentHashers.testHash(session, DataComponentTypes.CUSTOM_NAME, Component.text((String)"component with more stuff").children(List.of((TranslatableComponent)Component.translatable((String)"a.translate.string", (String)"fallback!").style(style -> style.color(TextColor.color((int)0x446688)).decorate(TextDecoration.BOLD)))), -1591253390);
        DataComponentHashers.testHash(session, DataComponentTypes.ITEM_MODEL, MinecraftKey.key("testing"), -689946239);
        DataComponentHashers.testHash(session, DataComponentTypes.RARITY, Rarity.COMMON.ordinal(), 75150990);
        DataComponentHashers.testHash(session, DataComponentTypes.RARITY, Rarity.RARE.ordinal(), -1420566726);
        DataComponentHashers.testHash(session, DataComponentTypes.RARITY, Rarity.EPIC.ordinal(), -292715907);
        DataComponentHashers.testHash(session, DataComponentTypes.ENCHANTMENTS, new ItemEnchantments(Map.of(0, 1)), 0);
        DataComponentHashers.testHash(session, DataComponentTypes.CUSTOM_MODEL_DATA, new CustomModelData(List.of(Float.valueOf(5.0f), Float.valueOf(3.0f), Float.valueOf(-1.0f)), List.of(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false)), List.of("1", "3", "2"), List.of(Integer.valueOf(3424), Integer.valueOf(-123), Integer.valueOf(345))), 1947635619);
        DataComponentHashers.testHash(session, DataComponentTypes.CUSTOM_MODEL_DATA, new CustomModelData(List.of(Float.valueOf(5.03f), Float.valueOf(3.0f), Float.valueOf(-1.11f)), List.of(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false)), List.of("2", "5", "7"), List.of()), -512419908);
        DataComponentHashers.testHash(session, DataComponentTypes.TOOLTIP_DISPLAY, new TooltipDisplay(false, List.of(DataComponentTypes.CONSUMABLE, DataComponentTypes.DAMAGE)), -816418453);
        DataComponentHashers.testHash(session, DataComponentTypes.TOOLTIP_DISPLAY, new TooltipDisplay(true, List.of()), 14016722);
        DataComponentHashers.testHash(session, DataComponentTypes.TOOLTIP_DISPLAY, new TooltipDisplay(false, List.of()), -982207288);
        DataComponentHashers.testHash(session, DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, true, -1019818302);
        DataComponentHashers.testHash(session, DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, false, 828198337);
        DataComponentHashers.testHash(session, DataComponentTypes.FOOD, new FoodProperties(5, 1.4f, false), 445786378);
        DataComponentHashers.testHash(session, DataComponentTypes.FOOD, new FoodProperties(3, 5.7f, true), 1917653498);
        DataComponentHashers.testHash(session, DataComponentTypes.FOOD, new FoodProperties(7, 0.15f, false), -184166204);
        DataComponentHashers.testHash(session, DataComponentTypes.CONSUMABLE, new Consumable(2.0f, Consumable.ItemUseAnimation.EAT, BuiltinSound.ITEM_OMINOUS_BOTTLE_DISPOSE, true, List.of(new ConsumeEffect.RemoveEffects(new HolderSet(new int[]{Effect.BAD_OMEN.ordinal(), Effect.REGENERATION.ordinal()})), new ConsumeEffect.TeleportRandomly(3.0f))), 1742669333);
        DataComponentHashers.testHash(session, DataComponentTypes.USE_REMAINDER, new ItemStack(Items.MELON.javaId(), 52), -1279684916);
        DataComponents specialComponents = new DataComponents(new HashMap());
        specialComponents.put(DataComponentTypes.ITEM_MODEL, MinecraftKey.key("testing"));
        specialComponents.put(DataComponentTypes.MAX_STACK_SIZE, 44);
        DataComponentHashers.testHash(session, DataComponentTypes.USE_REMAINDER, new ItemStack(Items.PUMPKIN.javaId(), 32, specialComponents), 1991032843);
        DataComponentHashers.testHash(session, DataComponentTypes.DAMAGE_RESISTANT, MinecraftKey.key("testing"), -1230493835);
        DataComponentHashers.testHash(session, DataComponentTypes.TOOL, new ToolData(List.of(), 5.0f, 3, false), -1789071928);
        DataComponentHashers.testHash(session, DataComponentTypes.TOOL, new ToolData(List.of(), 3.0f, 1, true), -7422944);
        DataComponentHashers.testHash(session, DataComponentTypes.TOOL, new ToolData(List.of(new ToolData.Rule(new HolderSet(MinecraftKey.key("acacia_logs")), null, null), new ToolData.Rule(new HolderSet(new int[]{Blocks.JACK_O_LANTERN.javaId(), Blocks.WALL_TORCH.javaId()}), Float.valueOf(4.2f), true), new ToolData.Rule(new HolderSet(new int[]{Blocks.PUMPKIN.javaId()}), Float.valueOf(7.0f), false)), 1.0f, 1, true), 2103678261);
        DataComponentHashers.testHash(session, DataComponentTypes.WEAPON, new Weapon(5, 2.0f), -154556976);
        DataComponentHashers.testHash(session, DataComponentTypes.WEAPON, new Weapon(1, 7.3f), 885347995);
        DataComponentHashers.testHash(session, DataComponentTypes.ENCHANTABLE, 3, -1834983819);
        DataComponentHashers.testHash(session, DataComponentTypes.EQUIPPABLE, new Equippable(EquipmentSlot.BODY, BuiltinSound.ITEM_ARMOR_EQUIP_GENERIC, null, null, null, true, true, true, false), 1294431019);
        DataComponentHashers.testHash(session, DataComponentTypes.EQUIPPABLE, new Equippable(EquipmentSlot.BODY, BuiltinSound.ITEM_ARMOR_EQUIP_CHAIN, MinecraftKey.key("testing"), null, null, true, true, true, false), 1226203061);
        DataComponentHashers.testHash(session, DataComponentTypes.EQUIPPABLE, new Equippable(EquipmentSlot.BODY, BuiltinSound.AMBIENT_CAVE, null, null, null, false, true, false, false), 1416408052);
        DataComponentHashers.testHash(session, DataComponentTypes.EQUIPPABLE, new Equippable(EquipmentSlot.BODY, BuiltinSound.ENTITY_BREEZE_WIND_BURST, null, MinecraftKey.key("testing"), new HolderSet(new int[]{EntityType.ACACIA_BOAT.ordinal()}), false, true, false, false), 1711275245);
        DataComponentHashers.testHash(session, DataComponentTypes.EQUIPPABLE, new Equippable(EquipmentSlot.HELMET, BuiltinSound.ITEM_ARMOR_EQUIP_GENERIC, null, null, null, true, true, true, false), 497790992);
        DataComponentHashers.testHash(session, DataComponentTypes.REPAIRABLE, new HolderSet(new int[]{Items.AMETHYST_BLOCK.javaId(), Items.PUMPKIN.javaId()}), -36715567);
        NbtMap mapDecorations = NbtMap.builder().putCompound("test_decoration", NbtMap.builder().putString("type", "minecraft:player").putDouble("x", 45.0).putDouble("z", 67.4).putFloat("rotation", 39.5f).build()).build();
        DataComponentHashers.testHash(session, DataComponentTypes.MAP_DECORATIONS, mapDecorations, -625782954);
        ItemStack bundleStack1 = new ItemStack(Items.PUMPKIN.javaId());
        ItemStack bundleStack2 = new ItemStack(Items.MELON.javaId(), 24);
        DataComponents bundleStackComponents = new DataComponents(new HashMap());
        bundleStackComponents.put(DataComponentTypes.CUSTOM_NAME, Component.text((String)"magic potato!"));
        ItemStack bundleStack3 = new ItemStack(Items.POTATO.javaId(), 30, bundleStackComponents);
        DataComponentHashers.testHash(session, DataComponentTypes.BUNDLE_CONTENTS, List.of(bundleStack1, bundleStack2, bundleStack3), 1817891504);
        DataComponentHashers.testHash(session, DataComponentTypes.POTION_CONTENTS, new PotionContents(Potion.FIRE_RESISTANCE.ordinal(), -1, List.of(), null), -772576502);
        DataComponentHashers.testHash(session, DataComponentTypes.POTION_CONTENTS, new PotionContents(-1, 20, List.of(new MobEffectInstance(Effect.CONDUIT_POWER, new MobEffectDetails(0, 0, false, true, true, null))), null), -902075187);
        DataComponentHashers.testHash(session, DataComponentTypes.POTION_CONTENTS, new PotionContents(-1, 96, List.of(new MobEffectInstance(Effect.JUMP_BOOST, new MobEffectDetails(57, 17, true, false, false, null))), null), -17231244);
        DataComponentHashers.testHash(session, DataComponentTypes.POTION_CONTENTS, new PotionContents(-1, 87, List.of(new MobEffectInstance(Effect.SPEED, new MobEffectDetails(29, 1004, false, true, true, null))), "testing"), 2007296036);
        DataComponentHashers.testHash(session, DataComponentTypes.LODESTONE_TRACKER, new LodestoneTracker(new GlobalPos(MinecraftKey.key("overworld"), Vector3i.from((int)5, (int)6, (int)7)), true), 63561894);
        DataComponentHashers.testHash(session, DataComponentTypes.LODESTONE_TRACKER, new LodestoneTracker(null, false), 1595667667);
    }

    private static <T> void testHash(GeyserSession session, DataComponentType<T> component, T value, int expected) {
        int got = DataComponentHashers.hash(session, component, value).asInt();
        System.out.println("Testing hashing component " + String.valueOf(component.getKey()) + ", expected " + expected + ", got " + got + " " + (got == expected ? "PASS" : "ERROR"));
    }

    static {
        DataComponentHashers.register(DataComponentTypes.CUSTOM_DATA, MinecraftHasher.NBT_MAP);
        DataComponentHashers.registerInt(DataComponentTypes.MAX_STACK_SIZE);
        DataComponentHashers.registerInt(DataComponentTypes.MAX_DAMAGE);
        DataComponentHashers.registerInt(DataComponentTypes.DAMAGE);
        DataComponentHashers.registerUnit(DataComponentTypes.UNBREAKABLE);
        DataComponentHashers.register(DataComponentTypes.CUSTOM_NAME, ComponentHasher.COMPONENT);
        DataComponentHashers.register(DataComponentTypes.ITEM_NAME, ComponentHasher.COMPONENT);
        DataComponentHashers.register(DataComponentTypes.ITEM_MODEL, MinecraftHasher.KEY);
        DataComponentHashers.register(DataComponentTypes.LORE, ComponentHasher.COMPONENT.list());
        DataComponentHashers.register(DataComponentTypes.RARITY, MinecraftHasher.RARITY);
        DataComponentHashers.register(DataComponentTypes.ENCHANTMENTS, RegistryHasher.ITEM_ENCHANTMENTS);
        DataComponentHashers.register(DataComponentTypes.CAN_PLACE_ON, RegistryHasher.ADVENTURE_MODE_PREDICATE);
        DataComponentHashers.register(DataComponentTypes.CAN_BREAK, RegistryHasher.ADVENTURE_MODE_PREDICATE);
        DataComponentHashers.register(DataComponentTypes.ATTRIBUTE_MODIFIERS, RegistryHasher.ATTRIBUTE_MODIFIER_ENTRY.list().cast(ItemAttributeModifiers::getModifiers));
        DataComponentHashers.registerMap(DataComponentTypes.CUSTOM_MODEL_DATA, builder -> builder.optionalList("floats", MinecraftHasher.FLOAT, CustomModelData::floats).optionalList("flags", MinecraftHasher.BOOL, CustomModelData::flags).optionalList("strings", MinecraftHasher.STRING, CustomModelData::strings).optionalList("colors", MinecraftHasher.INT, CustomModelData::colors));
        DataComponentHashers.registerMap(DataComponentTypes.TOOLTIP_DISPLAY, builder -> builder.optional("hide_tooltip", MinecraftHasher.BOOL, TooltipDisplay::hideTooltip, false).optionalList("hidden_components", RegistryHasher.DATA_COMPONENT_TYPE, TooltipDisplay::hiddenComponents));
        DataComponentHashers.registerInt(DataComponentTypes.REPAIR_COST);
        DataComponentHashers.register(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, MinecraftHasher.BOOL);
        DataComponentHashers.registerUnit(DataComponentTypes.INTANGIBLE_PROJECTILE);
        DataComponentHashers.registerMap(DataComponentTypes.FOOD, builder -> builder.accept("nutrition", MinecraftHasher.INT, FoodProperties::getNutrition).accept("saturation", MinecraftHasher.FLOAT, FoodProperties::getSaturationModifier).optional("can_always_eat", MinecraftHasher.BOOL, FoodProperties::isCanAlwaysEat, false));
        DataComponentHashers.registerMap(DataComponentTypes.CONSUMABLE, builder -> builder.optional("consume_seconds", MinecraftHasher.FLOAT, Consumable::consumeSeconds, Float.valueOf(1.6f)).optional("animation", RegistryHasher.ITEM_USE_ANIMATION, Consumable::animation, Consumable.ItemUseAnimation.EAT).optional("sound", RegistryHasher.SOUND_EVENT, Consumable::sound, BuiltinSound.ENTITY_GENERIC_EAT).optional("has_consume_particles", MinecraftHasher.BOOL, Consumable::hasConsumeParticles, true).optionalList("on_consume_effects", RegistryHasher.CONSUME_EFFECT, Consumable::onConsumeEffects));
        DataComponentHashers.register(DataComponentTypes.USE_REMAINDER, RegistryHasher.ITEM_STACK);
        DataComponentHashers.registerMap(DataComponentTypes.USE_COOLDOWN, builder -> builder.accept("seconds", MinecraftHasher.FLOAT, UseCooldown::seconds).optionalNullable("cooldown_group", MinecraftHasher.KEY, UseCooldown::cooldownGroup));
        DataComponentHashers.registerMap(DataComponentTypes.DAMAGE_RESISTANT, builder -> builder.accept("types", MinecraftHasher.TAG, Function.identity()));
        DataComponentHashers.registerMap(DataComponentTypes.TOOL, builder -> builder.acceptList("rules", RegistryHasher.TOOL_RULE, ToolData::getRules).optional("default_mining_speed", MinecraftHasher.FLOAT, ToolData::getDefaultMiningSpeed, Float.valueOf(1.0f)).optional("damage_per_block", MinecraftHasher.INT, ToolData::getDamagePerBlock, 1).optional("can_destroy_blocks_in_creative", MinecraftHasher.BOOL, ToolData::isCanDestroyBlocksInCreative, true));
        DataComponentHashers.registerMap(DataComponentTypes.WEAPON, builder -> builder.optional("item_damage_per_attack", MinecraftHasher.INT, Weapon::itemDamagePerAttack, 1).optional("disable_blocking_for_seconds", MinecraftHasher.FLOAT, Weapon::disableBlockingForSeconds, Float.valueOf(0.0f)));
        DataComponentHashers.registerMap(DataComponentTypes.ENCHANTABLE, builder -> builder.accept("value", MinecraftHasher.INT, Function.identity()));
        DataComponentHashers.registerMap(DataComponentTypes.EQUIPPABLE, builder -> builder.accept("slot", MinecraftHasher.EQUIPMENT_SLOT, Equippable::slot).optional("equip_sound", RegistryHasher.SOUND_EVENT, Equippable::equipSound, BuiltinSound.ITEM_ARMOR_EQUIP_GENERIC).optionalNullable("asset_id", MinecraftHasher.KEY, Equippable::model).optionalNullable("camera_overlay", MinecraftHasher.KEY, Equippable::cameraOverlay).optionalNullable("allowed_entities", RegistryHasher.ENTITY_TYPE.holderSet(), Equippable::allowedEntities).optional("dispensable", MinecraftHasher.BOOL, Equippable::dispensable, true).optional("swappable", MinecraftHasher.BOOL, Equippable::swappable, true).optional("damage_on_hurt", MinecraftHasher.BOOL, Equippable::damageOnHurt, true).optional("equip_on_interact", MinecraftHasher.BOOL, Equippable::equipOnInteract, false));
        DataComponentHashers.registerMap(DataComponentTypes.REPAIRABLE, builder -> builder.accept("items", RegistryHasher.ITEM.holderSet(), Function.identity()));
        DataComponentHashers.registerUnit(DataComponentTypes.GLIDER);
        DataComponentHashers.register(DataComponentTypes.TOOLTIP_STYLE, MinecraftHasher.KEY);
        DataComponentHashers.registerMap(DataComponentTypes.DEATH_PROTECTION, builder -> builder.optionalList("death_effects", RegistryHasher.CONSUME_EFFECT, Function.identity()));
        DataComponentHashers.registerMap(DataComponentTypes.BLOCKS_ATTACKS, builder -> builder.optional("block_delay_seconds", MinecraftHasher.FLOAT, BlocksAttacks::blockDelaySeconds, Float.valueOf(0.0f)).optional("disable_cooldown_scale", MinecraftHasher.FLOAT, BlocksAttacks::disableCooldownScale, Float.valueOf(1.0f)).optional("damage_reductions", RegistryHasher.BLOCKS_ATTACKS_DAMAGE_REDUCTION.list(), BlocksAttacks::damageReductions, List.of(new BlocksAttacks.DamageReduction(90.0f, null, 0.0f, 1.0f))).optional("item_damage", RegistryHasher.BLOCKS_ATTACKS_ITEM_DAMAGE_FUNCTION, BlocksAttacks::itemDamage, new BlocksAttacks.ItemDamageFunction(1.0f, 0.0f, 1.0f)).optionalNullable("bypassed_by", MinecraftHasher.TAG, BlocksAttacks::bypassedBy).optionalNullable("block_sound", RegistryHasher.SOUND_EVENT, BlocksAttacks::blockSound).optionalNullable("disabled_sound", RegistryHasher.SOUND_EVENT, BlocksAttacks::disableSound));
        DataComponentHashers.register(DataComponentTypes.STORED_ENCHANTMENTS, RegistryHasher.ITEM_ENCHANTMENTS);
        DataComponentHashers.registerInt(DataComponentTypes.DYED_COLOR);
        DataComponentHashers.registerInt(DataComponentTypes.MAP_COLOR);
        DataComponentHashers.registerInt(DataComponentTypes.MAP_ID);
        DataComponentHashers.register(DataComponentTypes.MAP_DECORATIONS, MinecraftHasher.NBT_MAP);
        DataComponentHashers.register(DataComponentTypes.CHARGED_PROJECTILES, RegistryHasher.ITEM_STACK.list());
        DataComponentHashers.register(DataComponentTypes.BUNDLE_CONTENTS, RegistryHasher.ITEM_STACK.list());
        DataComponentHashers.registerMap(DataComponentTypes.POTION_CONTENTS, builder -> builder.optional("potion", RegistryHasher.POTION, PotionContents::getPotionId, -1).optional("custom_color", MinecraftHasher.INT, PotionContents::getCustomColor, -1).optionalList("custom_effects", RegistryHasher.MOB_EFFECT_INSTANCE, PotionContents::getCustomEffects).optionalNullable("custom_name", MinecraftHasher.STRING, PotionContents::getCustomName));
        DataComponentHashers.register(DataComponentTypes.POTION_DURATION_SCALE, MinecraftHasher.FLOAT);
        DataComponentHashers.register(DataComponentTypes.SUSPICIOUS_STEW_EFFECTS, RegistryHasher.SUSPICIOUS_STEW_EFFECT.list());
        DataComponentHashers.registerMap(DataComponentTypes.WRITABLE_BOOK_CONTENT, builder -> builder.optionalList("pages", MinecraftHasher.STRING.filterable(), WritableBookContent::getPages));
        DataComponentHashers.registerMap(DataComponentTypes.WRITTEN_BOOK_CONTENT, builder -> builder.accept("title", MinecraftHasher.STRING.filterable(), WrittenBookContent::getTitle).accept("author", MinecraftHasher.STRING, WrittenBookContent::getAuthor).accept("generation", MinecraftHasher.INT, WrittenBookContent::getGeneration).optionalList("pages", ComponentHasher.COMPONENT.filterable(), WrittenBookContent::getPages).optional("resolved", MinecraftHasher.BOOL, WrittenBookContent::isResolved, false));
        DataComponentHashers.register(DataComponentTypes.TRIM, RegistryHasher.ARMOR_TRIM);
        DataComponentHashers.register(DataComponentTypes.DEBUG_STICK_STATE, MinecraftHasher.NBT_MAP);
        DataComponentHashers.register(DataComponentTypes.ENTITY_DATA, MinecraftHasher.NBT_MAP);
        DataComponentHashers.register(DataComponentTypes.BUCKET_ENTITY_DATA, MinecraftHasher.NBT_MAP);
        DataComponentHashers.register(DataComponentTypes.BLOCK_ENTITY_DATA, MinecraftHasher.NBT_MAP);
        DataComponentHashers.register(DataComponentTypes.INSTRUMENT, RegistryHasher.INSTRUMENT_COMPONENT);
        DataComponentHashers.register(DataComponentTypes.PROVIDES_TRIM_MATERIAL, RegistryHasher.PROVIDES_TRIM_MATERIAL);
        DataComponentHashers.registerInt(DataComponentTypes.OMINOUS_BOTTLE_AMPLIFIER);
        DataComponentHashers.register(DataComponentTypes.JUKEBOX_PLAYABLE, RegistryHasher.JUKEBOX_PLAYABLE);
        DataComponentHashers.register(DataComponentTypes.PROVIDES_BANNER_PATTERNS, MinecraftHasher.TAG);
        DataComponentHashers.register(DataComponentTypes.RECIPES, MinecraftHasher.NBT_LIST);
        DataComponentHashers.registerMap(DataComponentTypes.LODESTONE_TRACKER, builder -> builder.optionalNullable("target", MinecraftHasher.GLOBAL_POS, LodestoneTracker::getPos).optional("tracked", MinecraftHasher.BOOL, LodestoneTracker::isTracked, true));
        DataComponentHashers.register(DataComponentTypes.FIREWORK_EXPLOSION, RegistryHasher.FIREWORK_EXPLOSION);
        DataComponentHashers.registerMap(DataComponentTypes.FIREWORKS, builder -> builder.optional("flight_duration", MinecraftHasher.BYTE, fireworks -> (byte)fireworks.getFlightDuration(), (byte)0).optionalList("explosions", RegistryHasher.FIREWORK_EXPLOSION, Fireworks::getExplosions));
        DataComponentHashers.register(DataComponentTypes.PROFILE, MinecraftHasher.GAME_PROFILE);
        DataComponentHashers.register(DataComponentTypes.NOTE_BLOCK_SOUND, MinecraftHasher.KEY);
        DataComponentHashers.register(DataComponentTypes.BANNER_PATTERNS, RegistryHasher.BANNER_PATTERN_LAYER.list());
        DataComponentHashers.register(DataComponentTypes.BASE_COLOR, MinecraftHasher.DYE_COLOR);
        DataComponentHashers.register(DataComponentTypes.POT_DECORATIONS, RegistryHasher.ITEM.list());
        DataComponentHashers.register(DataComponentTypes.CONTAINER, RegistryHasher.ITEM_CONTAINER_CONTENTS);
        DataComponentHashers.register(DataComponentTypes.BLOCK_STATE, MinecraftHasher.map(MinecraftHasher.STRING, MinecraftHasher.STRING).cast(BlockStateProperties::getProperties));
        DataComponentHashers.register(DataComponentTypes.BEES, RegistryHasher.BEEHIVE_OCCUPANT.list());
        DataComponentHashers.register(DataComponentTypes.LOCK, MinecraftHasher.NBT_MAP);
        DataComponentHashers.register(DataComponentTypes.CONTAINER_LOOT, MinecraftHasher.NBT_MAP);
        DataComponentHashers.register(DataComponentTypes.BREAK_SOUND, RegistryHasher.SOUND_EVENT);
        DataComponentHashers.register(DataComponentTypes.VILLAGER_VARIANT, RegistryHasher.VILLAGER_TYPE);
        DataComponentHashers.register(DataComponentTypes.WOLF_VARIANT, RegistryHasher.WOLF_VARIANT);
        DataComponentHashers.register(DataComponentTypes.WOLF_SOUND_VARIANT, RegistryHasher.WOLF_SOUND_VARIANT);
        DataComponentHashers.register(DataComponentTypes.WOLF_COLLAR, MinecraftHasher.DYE_COLOR);
        DataComponentHashers.register(DataComponentTypes.FOX_VARIANT, RegistryHasher.FOX_VARIANT);
        DataComponentHashers.register(DataComponentTypes.SALMON_SIZE, RegistryHasher.SALMON_VARIANT);
        DataComponentHashers.register(DataComponentTypes.PARROT_VARIANT, RegistryHasher.PARROT_VARIANT);
        DataComponentHashers.register(DataComponentTypes.TROPICAL_FISH_PATTERN, RegistryHasher.TROPICAL_FISH_PATTERN);
        DataComponentHashers.register(DataComponentTypes.TROPICAL_FISH_BASE_COLOR, MinecraftHasher.DYE_COLOR);
        DataComponentHashers.register(DataComponentTypes.TROPICAL_FISH_PATTERN_COLOR, MinecraftHasher.DYE_COLOR);
        DataComponentHashers.register(DataComponentTypes.MOOSHROOM_VARIANT, RegistryHasher.MOOSHROOM_VARIANT);
        DataComponentHashers.register(DataComponentTypes.RABBIT_VARIANT, RegistryHasher.RABBIT_VARIANT);
        DataComponentHashers.register(DataComponentTypes.PIG_VARIANT, RegistryHasher.PIG_VARIANT);
        DataComponentHashers.register(DataComponentTypes.COW_VARIANT, RegistryHasher.COW_VARIANT);
        DataComponentHashers.register(DataComponentTypes.CHICKEN_VARIANT, MinecraftHasher.KEY.sessionCast((session, holder) -> holder.getOrCompute(id -> JavaRegistries.CHICKEN_VARIANT.keyFromNetworkId((GeyserSession)session, id))));
        DataComponentHashers.register(DataComponentTypes.FROG_VARIANT, RegistryHasher.FROG_VARIANT);
        DataComponentHashers.register(DataComponentTypes.HORSE_VARIANT, RegistryHasher.HORSE_VARIANT);
        DataComponentHashers.register(DataComponentTypes.PAINTING_VARIANT, RegistryHasher.PAINTING_VARIANT.holder());
        DataComponentHashers.register(DataComponentTypes.LLAMA_VARIANT, RegistryHasher.LLAMA_VARIANT);
        DataComponentHashers.register(DataComponentTypes.AXOLOTL_VARIANT, RegistryHasher.AXOLOTL_VARIANT);
        DataComponentHashers.register(DataComponentTypes.CAT_VARIANT, RegistryHasher.CAT_VARIANT);
        DataComponentHashers.register(DataComponentTypes.CAT_COLLAR, MinecraftHasher.DYE_COLOR);
        DataComponentHashers.register(DataComponentTypes.SHEEP_COLOR, MinecraftHasher.DYE_COLOR);
        DataComponentHashers.register(DataComponentTypes.SHULKER_COLOR, MinecraftHasher.DYE_COLOR);
    }
}

