/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.OptionalInt;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector2f;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.bedrock.SessionInitializeEvent;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.api.pack.UrlPackCodec;
import org.geysermc.geyser.api.pack.option.ResourcePackOption;
import org.geysermc.geyser.event.type.SessionLoadResourcePacksEventImpl;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.network.LoggingPacketHandler;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.ResourcePackHolder;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.loader.ResourcePackLoader;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.codec.compat.BedrockCompat;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.ResourcePackType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.codec.compression.SimpleCompressionStrategy;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.netty.codec.compression.ZlibCompression;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.LoginPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ModalFormResponsePacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.NetworkSettingsPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.PlayerAuthInputPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.RequestNetworkSettingsPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePackChunkDataPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePackChunkRequestPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePackClientResponsePacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePackDataInfoPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePackStackPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.ResourcePacksInfoPacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.SetTitlePacket;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.common.util.Zlib;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.LoginEncryptionUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.geyser.util.VersionCheckUtils;

public class UpstreamPacketHandler
extends LoggingPacketHandler {
    private boolean networkSettingsRequested = false;
    private final Deque<String> packsToSend = new ArrayDeque<String>();
    private final CompressionStrategy compressionStrategy;
    private SessionLoadResourcePacksEventImpl resourcePackLoadEvent;

    public UpstreamPacketHandler(GeyserImpl geyser, GeyserSession session) {
        super(geyser, session);
        ZlibCompression compression = new ZlibCompression(Zlib.RAW);
        compression.setLevel(this.geyser.getConfig().getBedrock().getCompressionLevel());
        this.compressionStrategy = new SimpleCompressionStrategy(compression);
    }

    private PacketSignal translateAndDefault(BedrockPacket packet) {
        Registries.BEDROCK_PACKET_TRANSLATORS.translate(packet.getClass(), packet, this.session, false);
        return PacketSignal.HANDLED;
    }

    @Override
    PacketSignal defaultHandler(BedrockPacket packet) {
        return this.translateAndDefault(packet);
    }

    private boolean setCorrectCodec(int protocolVersion) {
        BedrockCodec packetCodec = GameProtocol.getBedrockCodec(protocolVersion);
        if (packetCodec == null) {
            String supportedVersions = GameProtocol.getAllSupportedBedrockVersions();
            if (protocolVersion > GameProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()) {
                Object disconnectMessage = GeyserLocale.getLocaleStringLog("geyser.network.outdated.server", supportedVersions);
                OptionalInt latestRelease = VersionCheckUtils.getLatestBedrockRelease();
                if (latestRelease.isPresent() && latestRelease.getAsInt() == protocolVersion) {
                    disconnectMessage = (String)disconnectMessage + "\n" + GeyserLocale.getLocaleStringLog("geyser.version.new.on_disconnect", "https://geysermc.org/download");
                }
                this.session.disconnect((String)disconnectMessage);
                return false;
            }
            if (protocolVersion < GameProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()) {
                this.session.getUpstream().getSession().setCodec(BedrockCompat.disconnectCompat(protocolVersion));
                this.session.disconnect(GeyserLocale.getLocaleStringLog("geyser.network.outdated.client", supportedVersions));
                return false;
            }
            throw new IllegalStateException("Default codec of protocol version " + protocolVersion + " should have been found");
        }
        this.session.getUpstream().getSession().setCodec(packetCodec);
        return true;
    }

    @Override
    public void onDisconnect(String reason) {
        if ("disconnect.closed".equals(reason)) {
            this.session.getUpstream().getSession().setDisconnectReason(GeyserLocale.getLocaleStringLog("geyser.network.disconnect.closed_by_remote_peer"));
        } else if ("disconnect.timeout".equals(reason)) {
            this.session.getUpstream().getSession().setDisconnectReason(GeyserLocale.getLocaleStringLog("geyser.network.disconnect.timed_out"));
        }
        this.session.disconnect(this.session.getUpstream().getSession().getDisconnectReason());
    }

    @Override
    public PacketSignal handle(RequestNetworkSettingsPacket packet) {
        if (!this.setCorrectCodec(packet.getProtocolVersion())) {
            return PacketSignal.HANDLED;
        }
        PacketCompressionAlgorithm algorithm = PacketCompressionAlgorithm.ZLIB;
        NetworkSettingsPacket responsePacket = new NetworkSettingsPacket();
        responsePacket.setCompressionAlgorithm(algorithm);
        responsePacket.setCompressionThreshold(512);
        this.session.sendUpstreamPacketImmediately(responsePacket);
        this.session.getUpstream().getSession().getPeer().setCompression(this.compressionStrategy);
        this.networkSettingsRequested = true;
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(LoginPacket loginPacket) {
        if (this.geyser.isShuttingDown() || this.geyser.isReloading()) {
            this.session.disconnect(GeyserLocale.getLocaleStringLog("geyser.core.shutdown.kick.message"));
            return PacketSignal.HANDLED;
        }
        if (!this.networkSettingsRequested) {
            this.session.disconnect(GeyserLocale.getLocaleStringLog("geyser.network.outdated.client", GameProtocol.getAllSupportedBedrockVersions()));
            return PacketSignal.HANDLED;
        }
        this.session.setBlockMappings(BlockRegistries.BLOCKS.forVersion(loginPacket.getProtocolVersion()));
        this.session.setItemMappings(Registries.ITEMS.forVersion(loginPacket.getProtocolVersion()));
        LoginEncryptionUtils.encryptPlayerConnection(this.session, loginPacket);
        if (this.session.isClosed()) {
            return PacketSignal.HANDLED;
        }
        this.geyser.eventBus().fire(new SessionInitializeEvent(this.session));
        PlayStatusPacket playStatus = new PlayStatusPacket();
        playStatus.setStatus(PlayStatusPacket.Status.LOGIN_SUCCESS);
        this.session.sendUpstreamPacket(playStatus);
        this.geyser.getSessionManager().addPendingSession(this.session);
        this.resourcePackLoadEvent = new SessionLoadResourcePacksEventImpl(this.session);
        this.geyser.eventBus().fire(this.resourcePackLoadEvent);
        ResourcePacksInfoPacket resourcePacksInfo = new ResourcePacksInfoPacket();
        resourcePacksInfo.getResourcePackInfos().addAll(this.resourcePackLoadEvent.infoPacketEntries());
        resourcePacksInfo.setForcedToAccept(GeyserImpl.getInstance().getConfig().isForceResourcePacks());
        resourcePacksInfo.setWorldTemplateId(UUID.randomUUID());
        resourcePacksInfo.setWorldTemplateVersion("*");
        this.session.sendUpstreamPacket(resourcePacksInfo);
        GeyserLocale.loadGeyserLocale(this.session.locale());
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(ResourcePackClientResponsePacket packet) {
        switch (packet.getStatus()) {
            case COMPLETED: {
                if (this.geyser.getConfig().getRemote().authType() != AuthType.ONLINE) {
                    this.session.authenticate(this.session.getAuthData().name());
                } else if (!this.couldLoginUserByName(this.session.getAuthData().name())) {
                    this.session.connect();
                }
                this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.connect", this.session.getAuthData().name()));
                break;
            }
            case SEND_PACKS: {
                this.packsToSend.addAll(packet.getPackIds());
                this.sendPackDataInfo(this.packsToSend.pop());
                break;
            }
            case HAVE_ALL_PACKS: {
                ResourcePackStackPacket stackPacket = new ResourcePackStackPacket();
                stackPacket.setExperimentsPreviouslyToggled(false);
                stackPacket.setForcedToAccept(false);
                stackPacket.setGameVersion(this.session.getClientData().getGameVersion());
                stackPacket.getResourcePacks().addAll(this.resourcePackLoadEvent.orderedPacks());
                this.session.sendUpstreamPacket(stackPacket);
                break;
            }
            default: {
                this.session.disconnect("disconnectionScreen.resourcePack");
            }
        }
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(ModalFormResponsePacket packet) {
        this.session.executeInEventLoop(() -> this.session.getFormCache().handleResponse(packet));
        return PacketSignal.HANDLED;
    }

    private boolean couldLoginUserByName(String bedrockUsername) {
        String authChain;
        if (this.geyser.getConfig().getSavedUserLogins().contains(bedrockUsername) && (authChain = this.geyser.authChainFor(bedrockUsername)) != null) {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.auth.stored_credentials", this.session.getAuthData().name()));
            this.session.authenticateWithAuthChain(authChain);
            return true;
        }
        PendingMicrosoftAuthentication.AuthenticationTask task = this.geyser.getPendingMicrosoftAuthentication().getTask(this.session.getAuthData().xuid());
        if (task != null) {
            return task.getAuthentication().isDone() && this.session.onMicrosoftLoginComplete(task);
        }
        return false;
    }

    @Override
    public PacketSignal handle(PlayerAuthInputPacket packet) {
        if (this.session.isLoggingIn() && !packet.getMotion().equals(Vector2f.ZERO)) {
            SetTitlePacket titlePacket = new SetTitlePacket();
            titlePacket.setType(SetTitlePacket.Type.ACTIONBAR);
            titlePacket.setText(GeyserLocale.getPlayerLocaleString("geyser.auth.login.wait", this.session.locale()));
            titlePacket.setFadeInTime(0);
            titlePacket.setFadeOutTime(1);
            titlePacket.setStayTime(2);
            titlePacket.setXuid("");
            titlePacket.setPlatformOnlineId("");
            this.session.sendUpstreamPacket(titlePacket);
        }
        return this.translateAndDefault(packet);
    }

    @Override
    public PacketSignal handle(ResourcePackChunkRequestPacket packet) {
        ResourcePackHolder holder = this.resourcePackLoadEvent.getPacks().get(packet.getPackId());
        if (holder == null) {
            GeyserImpl.getInstance().getLogger().debug("Client {0} tried to request pack id {1} not sent to it!", this.session.bedrockUsername(), packet.getPackId());
            this.session.disconnect("disconnectionScreen.resourcePack");
            return PacketSignal.HANDLED;
        }
        GeyserResourcePack pack = holder.pack();
        ResourcePackChunkDataPacket data = new ResourcePackChunkDataPacket();
        PackCodec codec = pack.codec();
        if (codec instanceof UrlPackCodec) {
            UrlPackCodec urlPackCodec = (UrlPackCodec)codec;
            ResourcePackLoader.testRemotePack(this.session, urlPackCodec, packet.getPackId(), packet.getPackVersion());
            if (!this.resourcePackLoadEvent.value(pack.uuid(), ResourcePackOption.Type.FALLBACK, true).booleanValue()) {
                this.session.disconnect("Unable to provide downloaded resource pack. Contact an administrator!");
                return PacketSignal.HANDLED;
            }
        }
        data.setChunkIndex(packet.getChunkIndex());
        data.setProgress((long)packet.getChunkIndex() * 102400L);
        data.setPackVersion(packet.getPackVersion());
        data.setPackId(packet.getPackId());
        int offset = packet.getChunkIndex() * 102400;
        long remainingSize = codec.size() - (long)offset;
        byte[] packData = new byte[(int)MathUtils.constrain(remainingSize, 0.0, 102400.0)];
        try (SeekableByteChannel channel = codec.serialize();){
            channel.position(offset);
            channel.read(ByteBuffer.wrap(packData, 0, packData.length));
        }
        catch (IOException e) {
            this.session.disconnect("disconnectionScreen.resourcePack");
            e.printStackTrace();
        }
        data.setData(Unpooled.wrappedBuffer((byte[])packData));
        this.session.sendUpstreamPacket(data);
        if (remainingSize <= 102400L && !this.packsToSend.isEmpty()) {
            this.sendPackDataInfo(this.packsToSend.pop());
        }
        return PacketSignal.HANDLED;
    }

    private void sendPackDataInfo(String id) {
        UUID packId;
        ResourcePackDataInfoPacket data = new ResourcePackDataInfoPacket();
        String[] packID = id.split("_");
        if (packID.length < 2) {
            GeyserImpl.getInstance().getLogger().debug("Client {0} tried to request invalid pack id {1}!", this.session.bedrockUsername(), packID);
            this.session.disconnect("disconnectionScreen.resourcePack");
            return;
        }
        try {
            packId = UUID.fromString(packID[0]);
        }
        catch (IllegalArgumentException e) {
            GeyserImpl.getInstance().getLogger().debug("Client {0} tried to request pack with an invalid id {1})", this.session.bedrockUsername(), id);
            this.session.disconnect("disconnectionScreen.resourcePack");
            return;
        }
        ResourcePackHolder holder = this.resourcePackLoadEvent.getPacks().get(packId);
        if (holder == null) {
            GeyserImpl.getInstance().getLogger().debug("Client {0} tried to request pack id {1} not sent to it!", this.session.bedrockUsername(), id);
            this.session.disconnect("disconnectionScreen.resourcePack");
            return;
        }
        GeyserResourcePack pack = holder.pack();
        PackCodec codec = pack.codec();
        ResourcePackManifest.Header header = pack.manifest().header();
        data.setPackId(header.uuid());
        int chunkCount = (int)Math.ceil((double)codec.size() / 102400.0);
        data.setChunkCount(chunkCount);
        data.setCompressedPackSize(codec.size());
        data.setMaxChunkSize(102400L);
        data.setHash(codec.sha256());
        data.setPackVersion(packID[1]);
        data.setPremium(false);
        data.setType(ResourcePackType.RESOURCES);
        this.session.sendUpstreamPacket(data);
    }
}

