/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import java.util.Objects;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.LecternContainer;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory.ClientboundOpenBookPacket;

@Translator(packet=ClientboundOpenBookPacket.class)
public class JavaOpenBookTranslator
extends PacketTranslator<ClientboundOpenBookPacket> {
    private static final int FAKE_LECTERN_WINDOW_ID = -69;

    @Override
    public void translate(GeyserSession session, ClientboundOpenBookPacket packet) {
        GeyserItemStack stack = session.getPlayerInventory().getItemInHand();
        if (stack.getItemData(session).equals(session.getCurrentBook())) {
            session.setCurrentBook(null);
            return;
        }
        if (stack.asItem().equals(Items.WRITTEN_BOOK)) {
            Inventory openInventory = session.getOpenInventory();
            if (openInventory != null) {
                InventoryUtils.closeInventory(session, openInventory.getJavaId(), true);
                InventoryUtils.sendJavaContainerClose(session, openInventory);
            }
            InventoryTranslator translator = InventoryTranslator.inventoryTranslator(ContainerType.LECTERN);
            Objects.requireNonNull(translator, "could not find lectern inventory translator!");
            Objects.requireNonNull(translator, "lectern translator must exist");
            Inventory inventory = translator.createInventory(session, "", -69, ContainerType.LECTERN, session.getPlayerInventory());
            ((LecternContainer)inventory).setFakeLecternBook(stack, session);
            InventoryUtils.openInventory(session, inventory);
        }
    }
}

