/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.network.netty.LocalSession;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.skin.FloodgateSkinUploader;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.event.session.ConnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.DisconnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.PacketErrorEvent;
import org.geysermc.mcprotocollib.network.event.session.PacketSendingEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionAdapter;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.UnexpectedEncryptionException;
import org.geysermc.mcprotocollib.protocol.packet.handshake.serverbound.ClientIntentionPacket;

public class GeyserSessionAdapter
extends SessionAdapter {
    private final GeyserImpl geyser;
    private final GeyserSession session;
    private final boolean floodgate;
    private final String locale;

    public GeyserSessionAdapter(GeyserSession session) {
        this.session = session;
        this.floodgate = session.remoteServer().authType() == AuthType.FLOODGATE;
        this.geyser = GeyserImpl.getInstance();
        this.locale = session.locale();
    }

    @Override
    public void packetSending(PacketSendingEvent event) {
        Packet packet = event.getPacket();
        if (packet instanceof ClientIntentionPacket) {
            Object addressSuffix;
            ClientIntentionPacket intentionPacket = (ClientIntentionPacket)packet;
            BedrockClientData clientData = this.session.getClientData();
            if (this.floodgate) {
                byte[] encryptedData;
                try {
                    FloodgateSkinUploader skinUploader = this.geyser.getSkinUploader();
                    FloodgateCipher cipher = this.geyser.getCipher();
                    String bedrockAddress = this.session.getUpstream().getAddress().getAddress().getHostAddress();
                    int ipv6ScopeIndex = bedrockAddress.indexOf(37);
                    if (ipv6ScopeIndex != -1) {
                        bedrockAddress = bedrockAddress.substring(0, ipv6ScopeIndex);
                    }
                    encryptedData = cipher.encryptFromString(BedrockData.of(clientData.getGameVersion(), this.session.bedrockUsername(), this.session.xuid(), clientData.getDeviceOs().ordinal(), clientData.getLanguageCode(), clientData.getUiProfile().ordinal(), clientData.getCurrentInputMode().ordinal(), bedrockAddress, skinUploader.getId(), skinUploader.getVerifyCode()).toString());
                }
                catch (Exception e) {
                    this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.auth.floodgate.encrypt_fail"), e);
                    this.session.disconnect(GeyserLocale.getPlayerLocaleString("geyser.auth.floodgate.encrypt_fail", this.locale));
                    return;
                }
                addressSuffix = "\u0000" + new String(encryptedData, StandardCharsets.UTF_8);
            } else {
                addressSuffix = "";
            }
            String address = this.geyser.config().java().forwardHostname() ? this.session.joinAddress() : intentionPacket.getHostname();
            event.setPacket(intentionPacket.withHostname(address + (String)addressSuffix));
        }
    }

    @Override
    public void connected(ConnectedEvent event) {
        this.session.loggingIn = false;
        this.session.loggedIn = true;
        if (this.session.getDownstream().getSession() instanceof LocalSession) {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.connect_internal", this.session.bedrockUsername(), this.session.getProtocol().getProfile().getName()));
        } else {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.connect", this.session.bedrockUsername(), this.session.getProtocol().getProfile().getName(), this.session.remoteServer().address()));
        }
        UUID uuid = this.session.getProtocol().getProfile().getId();
        if (uuid == null) {
            uuid = this.session.remoteServer().authType() == AuthType.FLOODGATE ? new UUID(0L, Long.parseLong(this.session.xuid())) : UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.session.getProtocol().getProfile().getName()).getBytes(StandardCharsets.UTF_8));
        }
        this.session.getPlayerEntity().setUuid(uuid);
        this.session.getPlayerEntity().setUsername(this.session.getProtocol().getProfile().getName());
        String locale = this.session.getClientData().getLanguageCode();
        if (locale.equalsIgnoreCase("en_us") && !MinecraftLocale.LOCALE_MAPPINGS.containsKey("en_us")) {
            this.session.sendMessage("Loading your locale (en_us); if this isn't already downloaded, this may take some time");
        }
        MinecraftLocale.downloadAndLoadLocale(locale);
    }

    @Override
    public void disconnected(DisconnectedEvent event) {
        String disconnectMessage;
        this.session.loggingIn = false;
        String customDisconnectMessage = null;
        Throwable cause = event.getCause();
        if (cause instanceof UnexpectedEncryptionException) {
            if (this.session.remoteServer().authType() != AuthType.FLOODGATE) {
                customDisconnectMessage = GeyserLocale.getPlayerLocaleString("geyser.network.remote.authentication_type_mismatch", this.locale);
                this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog(this.geyser.platformType() == PlatformType.STANDALONE ? "geyser.network.remote.floodgate_explanation_standalone" : "geyser.network.remote.floodgate_explanation_plugin", "https://geysermc.org/download#floodgate"));
            } else {
                customDisconnectMessage = GeyserLocale.getPlayerLocaleString("geyser.network.remote.floodgate_login_error", this.locale);
                if (this.geyser.platformType() == PlatformType.STANDALONE) {
                    this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.remote.floodgate_login_error_standalone"));
                }
            }
        } else if (cause instanceof ConnectException) {
            customDisconnectMessage = GeyserLocale.getPlayerLocaleString("geyser.network.remote.server_offline", this.locale);
        }
        String string = disconnectMessage = customDisconnectMessage != null ? customDisconnectMessage : MessageTranslator.convertMessage(event.getReason());
        if (this.session.getDownstream().getSession() instanceof LocalSession) {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.disconnect_internal", this.session.bedrockUsername(), disconnectMessage));
        } else {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.disconnect", this.session.bedrockUsername(), this.session.remoteServer().address(), disconnectMessage));
        }
        if (cause != null) {
            if (cause.getMessage() != null) {
                GeyserImpl.getInstance().getLogger().error(cause.getMessage());
            } else {
                GeyserImpl.getInstance().getLogger().error("An exception occurred: ", cause);
            }
            if (this.geyser.config().debugMode()) {
                cause.printStackTrace();
            }
        }
        if (!this.session.isClosed() && this.session.loggedIn || cause != null) {
            if (customDisconnectMessage != null) {
                this.session.disconnect(customDisconnectMessage);
            } else {
                this.session.disconnect(event.getReason());
            }
        }
        this.session.loggedIn = false;
    }

    @Override
    public void packetReceived(Session session, Packet packet) {
        Registries.JAVA_PACKET_TRANSLATORS.translate(packet.getClass(), packet, this.session, true);
    }

    @Override
    public void packetError(PacketErrorEvent event) {
        this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.downstream_error", (String)(event.getPacketClass() != null ? "(" + event.getPacketClass().getSimpleName() + ") " : "") + event.getCause().getMessage()));
        if (this.geyser.config().debugMode()) {
            event.getCause().printStackTrace();
        }
        event.setSuppress(true);
    }
}

