/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.MobArmorEquipmentPacket;
import org.cloudburstmc.protocol.bedrock.packet.MobEquipmentPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.vehicle.ClientVehicle;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.util.AttributeUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.Attribute;
import org.geysermc.mcprotocollib.protocol.data.game.entity.attribute.AttributeType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Equippable;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ColorParticleData;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType;

public class LivingEntity
extends Entity {
    protected ItemData helmet = ItemData.AIR;
    protected ItemData chestplate = ItemData.AIR;
    protected ItemData leggings = ItemData.AIR;
    protected ItemData boots = ItemData.AIR;
    protected ItemData body = ItemData.AIR;
    protected ItemData saddle = ItemData.AIR;
    protected ItemData hand = ItemData.AIR;
    protected ItemData offhand = ItemData.AIR;
    protected float health = 1.0f;
    protected float maxHealth = 20.0f;
    private boolean isMaxFrozenState = false;
    private float scale;
    private float attributeScale;

    public LivingEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setHelmet(ItemStack stack) {
        this.helmet = ItemTranslator.translateToBedrock(this.session, stack);
    }

    public void setChestplate(ItemStack stack) {
        this.chestplate = ItemTranslator.translateToBedrock(this.session, stack);
    }

    public void setLeggings(ItemStack stack) {
        this.leggings = ItemTranslator.translateToBedrock(this.session, stack);
    }

    public void setBoots(ItemStack stack) {
        this.boots = ItemTranslator.translateToBedrock(this.session, stack);
    }

    public void setBody(ItemStack stack) {
        this.body = ItemTranslator.translateToBedrock(this.session, stack);
    }

    public void setSaddle(@Nullable ItemStack stack) {
        Item item;
        this.saddle = ItemTranslator.translateToBedrock(this.session, stack);
        boolean saddled = false;
        if (stack != null && (item = Registries.JAVA_ITEMS.get(stack.getId())) != null) {
            DataComponents components = item.gatherComponents(stack.getDataComponentsPatch());
            Equippable equippable = components.get(DataComponentTypes.EQUIPPABLE);
            saddled = equippable != null && equippable.slot() == EquipmentSlot.SADDLE;
        }
        this.updateSaddled(saddled);
    }

    public void setHand(ItemStack stack) {
        this.hand = ItemTranslator.translateToBedrock(this.session, stack);
    }

    public void setOffhand(ItemStack stack) {
        this.offhand = ItemTranslator.translateToBedrock(this.session, stack);
    }

    protected void updateSaddled(boolean saddled) {
        this.setFlag(EntityFlag.SADDLED, saddled);
        this.updateBedrockMetadata();
        Entity mouseoverEntity = this.session.getMouseoverEntity();
        if (mouseoverEntity != null && mouseoverEntity.getEntityId() == this.entityId) {
            mouseoverEntity.updateInteractiveTag();
        }
    }

    public void switchHands() {
        ItemData offhand = this.offhand;
        this.offhand = this.hand;
        this.hand = offhand;
    }

    @Override
    protected void initializeMetadata() {
        this.scale = 1.0f;
        this.attributeScale = 1.0f;
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.STRUCTURAL_INTEGRITY, 1);
    }

    @Override
    public void updateNametag(@Nullable Team team) {
        this.updateNametag(team, team == null || team.isVisibleFor(this.session.getPlayerEntity().getUsername()));
    }

    public void setLivingEntityFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        boolean isUsingItem = (xd & 1) == 1;
        boolean isUsingOffhand = (xd & 2) == 2;
        boolean isUsingShield = this.hasShield(isUsingOffhand);
        this.setFlag(EntityFlag.USING_ITEM, isUsingItem && !isUsingShield);
        this.setFlag(EntityFlag.BLOCKING, isUsingItem && isUsingShield);
        this.setSpinAttack((xd & 4) == 4);
        this.setFlag(EntityFlag.EMERGING, isUsingItem && isUsingOffhand);
    }

    protected void setSpinAttack(boolean value) {
        this.setFlag(EntityFlag.DAMAGE_NEARBY_MOBS, value);
    }

    public void setHealth(FloatEntityMetadata entityMetadata) {
        this.health = entityMetadata.getPrimitiveValue();
        AttributeData healthData = this.createHealthAttribute();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.setAttributes(Collections.singletonList(healthData));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    public void setParticles(ObjectEntityMetadata<List<Particle>> entityMetadata) {
        List<Particle> particles = entityMetadata.getValue();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int count = 0;
        for (Particle particle : particles) {
            if (particle.getType() != ParticleType.ENTITY_EFFECT) continue;
            int color = ((ColorParticleData)particle.getData()).getColor();
            r += (float)(color >> 16 & 0xFF) / 255.0f;
            g += (float)(color >> 8 & 0xFF) / 255.0f;
            b += (float)(color & 0xFF) / 255.0f;
            ++count;
        }
        int result = 0;
        if (count > 0) {
            r = r / (float)count * 255.0f;
            g = g / (float)count * 255.0f;
            b = b / (float)count * 255.0f;
            result = (int)r << 16 | (int)g << 8 | (int)b;
        }
        this.dirtyMetadata.put(EntityDataTypes.EFFECT_COLOR, result);
    }

    public @Nullable Vector3i setBedPosition(EntityMetadata<Optional<Vector3i>, ?> entityMetadata) {
        Optional<Vector3i> optionalPos = entityMetadata.getValue();
        if (optionalPos.isPresent()) {
            Vector3i bedPosition = optionalPos.get();
            this.dirtyMetadata.put(EntityDataTypes.BED_POSITION, bedPosition);
            return bedPosition;
        }
        return null;
    }

    protected boolean hasShield(boolean offhand) {
        ItemMapping shieldMapping = this.session.getItemMappings().getStoredItems().shield();
        if (offhand) {
            return this.offhand.getDefinition().equals(shieldMapping.getBedrockDefinition());
        }
        return this.hand.getDefinition().equals(shieldMapping.getBedrockDefinition());
    }

    @Override
    protected boolean isShaking() {
        return this.isMaxFrozenState;
    }

    @Override
    protected void setDimensionsFromPose(Pose pose) {
        if (pose == Pose.SLEEPING) {
            this.setBoundingBoxWidth(0.2f);
            this.setBoundingBoxHeight(0.2f);
        } else {
            super.setDimensionsFromPose(pose);
        }
    }

    @Override
    public float setFreezing(IntEntityMetadata entityMetadata) {
        float freezingPercentage = super.setFreezing(entityMetadata);
        this.isMaxFrozenState = freezingPercentage >= 1.0f;
        this.setFlag(EntityFlag.SHAKING, this.isShaking());
        return freezingPercentage;
    }

    protected void setScale(float scale) {
        this.scale = scale;
        this.applyScale();
    }

    private void setAttributeScale(float scale) {
        this.attributeScale = MathUtils.clamp(scale, GeyserAttributeType.SCALE.getMinimum(), GeyserAttributeType.SCALE.getMaximum());
        this.applyScale();
    }

    private void applyScale() {
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(this.scale * this.attributeScale));
    }

    protected AttributeData createHealthAttribute() {
        return new AttributeData(GeyserAttributeType.HEALTH.getBedrockIdentifier(), 0.0f, this.maxHealth, (float)Math.ceil(this.health), this.maxHealth);
    }

    @Override
    public boolean isAlive() {
        return this.valid && this.health > 0.0f;
    }

    @Override
    public InteractionResult interact(Hand hand) {
        InteractionResult result;
        GeyserItemStack itemStack = this.session.getPlayerInventory().getItemInHand(hand);
        if (itemStack.asItem() == Items.NAME_TAG && (result = this.checkInteractWithNameTag(itemStack)).consumesAction()) {
            return result;
        }
        return super.interact(hand);
    }

    @Override
    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        LivingEntity livingEntity = this;
        if (livingEntity instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
            if (clientVehicle.isClientControlled()) {
                return;
            }
            clientVehicle.getVehicleComponent().moveRelative(relX, relY, relZ);
        }
        super.moveRelative(relX, relY, relZ, yaw, pitch, headYaw, isOnGround);
    }

    @Override
    public boolean setBoundingBoxHeight(float height) {
        LivingEntity livingEntity;
        if (this.valid && (livingEntity = this) instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
            clientVehicle.getVehicleComponent().setHeight(height);
        }
        return super.setBoundingBoxHeight(height);
    }

    @Override
    public void setBoundingBoxWidth(float width) {
        LivingEntity livingEntity;
        if (this.valid && (livingEntity = this) instanceof ClientVehicle) {
            ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
            clientVehicle.getVehicleComponent().setWidth(width);
        }
        super.setBoundingBoxWidth(width);
    }

    protected final InteractionResult checkInteractWithNameTag(GeyserItemStack itemStack) {
        if (itemStack.getComponent(DataComponentTypes.CUSTOM_NAME) != null) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void updateArmor(GeyserSession session) {
        if (!this.valid) {
            return;
        }
        ItemData helmet = this.helmet;
        ItemData chestplate = this.chestplate;
        ItemMapping banner = session.getItemMappings().getStoredItems().banner();
        if (ItemData.AIR.equals(chestplate) && helmet.getDefinition().equals(banner.getBedrockDefinition())) {
            chestplate = this.helmet;
            helmet = ItemData.AIR;
        } else if (chestplate.getDefinition().equals(banner.getBedrockDefinition())) {
            chestplate = ItemData.AIR;
        }
        MobArmorEquipmentPacket armorEquipmentPacket = new MobArmorEquipmentPacket();
        armorEquipmentPacket.setRuntimeEntityId(this.geyserId);
        armorEquipmentPacket.setHelmet(helmet);
        armorEquipmentPacket.setChestplate(chestplate);
        armorEquipmentPacket.setLeggings(this.leggings);
        armorEquipmentPacket.setBoots(this.boots);
        armorEquipmentPacket.setBody(this.body);
        session.sendUpstreamPacket(armorEquipmentPacket);
    }

    public void updateMainHand(GeyserSession session) {
        if (!this.valid) {
            return;
        }
        MobEquipmentPacket handPacket = new MobEquipmentPacket();
        handPacket.setRuntimeEntityId(this.geyserId);
        handPacket.setItem(this.hand);
        handPacket.setHotbarSlot(-1);
        handPacket.setInventorySlot(0);
        handPacket.setContainerId(0);
        session.sendUpstreamPacket(handPacket);
    }

    public void updateOffHand(GeyserSession session) {
        if (!this.valid) {
            return;
        }
        MobEquipmentPacket offHandPacket = new MobEquipmentPacket();
        offHandPacket.setRuntimeEntityId(this.geyserId);
        offHandPacket.setItem(this.offhand);
        offHandPacket.setHotbarSlot(-1);
        offHandPacket.setInventorySlot(0);
        offHandPacket.setContainerId(119);
        session.sendUpstreamPacket(offHandPacket);
    }

    public boolean useArmSwingAttack() {
        return false;
    }

    public void updateBedrockAttributes(GeyserSession session, List<Attribute> attributes) {
        if (!this.valid) {
            return;
        }
        ArrayList<AttributeData> newAttributes = new ArrayList<AttributeData>();
        for (Attribute attribute : attributes) {
            this.updateAttribute(attribute, newAttributes);
        }
        if (newAttributes.isEmpty()) {
            return;
        }
        UpdateAttributesPacket updateAttributesPacket = new UpdateAttributesPacket();
        updateAttributesPacket.setRuntimeEntityId(this.geyserId);
        updateAttributesPacket.setAttributes(newAttributes);
        session.sendUpstreamPacket(updateAttributesPacket);
    }

    protected void updateAttribute(Attribute javaAttribute, List<AttributeData> newAttributes) {
        AttributeType attributeType = javaAttribute.getType();
        if (attributeType instanceof AttributeType.Builtin) {
            AttributeType.Builtin type = (AttributeType.Builtin)attributeType;
            switch (type) {
                case MAX_HEALTH: {
                    this.maxHealth = Math.max((float)AttributeUtils.calculateValue(javaAttribute), 1.0f);
                    newAttributes.add(this.createHealthAttribute());
                    break;
                }
                case MOVEMENT_SPEED: {
                    AttributeData attributeData = this.calculateAttribute(javaAttribute, GeyserAttributeType.MOVEMENT_SPEED);
                    newAttributes.add(attributeData);
                    LivingEntity livingEntity = this;
                    if (!(livingEntity instanceof ClientVehicle)) break;
                    ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
                    clientVehicle.getVehicleComponent().setMoveSpeed(attributeData.getValue());
                    break;
                }
                case STEP_HEIGHT: {
                    LivingEntity livingEntity = this;
                    if (!(livingEntity instanceof ClientVehicle)) break;
                    ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
                    clientVehicle.getVehicleComponent().setStepHeight((float)AttributeUtils.calculateValue(javaAttribute));
                    break;
                }
                case GRAVITY: {
                    LivingEntity livingEntity = this;
                    if (!(livingEntity instanceof ClientVehicle)) break;
                    ClientVehicle clientVehicle = (ClientVehicle)((Object)livingEntity);
                    clientVehicle.getVehicleComponent().setGravity(AttributeUtils.calculateValue(javaAttribute));
                    break;
                }
                case ATTACK_DAMAGE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.ATTACK_DAMAGE));
                    break;
                }
                case FLYING_SPEED: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.FLYING_SPEED));
                    break;
                }
                case FOLLOW_RANGE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.FOLLOW_RANGE));
                    break;
                }
                case KNOCKBACK_RESISTANCE: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.KNOCKBACK_RESISTANCE));
                    break;
                }
                case JUMP_STRENGTH: {
                    newAttributes.add(this.calculateAttribute(javaAttribute, GeyserAttributeType.HORSE_JUMP_STRENGTH));
                    break;
                }
                case SCALE: {
                    this.setAttributeScale((float)AttributeUtils.calculateValue(javaAttribute));
                    this.updateBedrockMetadata();
                }
            }
        }
    }

    protected AttributeData calculateAttribute(Attribute javaAttribute, GeyserAttributeType type) {
        return type.getAttribute((float)AttributeUtils.calculateValue(javaAttribute));
    }

    public ItemData getHelmet() {
        return this.helmet;
    }

    public ItemData getChestplate() {
        return this.chestplate;
    }

    public ItemData getLeggings() {
        return this.leggings;
    }

    public ItemData getBoots() {
        return this.boots;
    }

    public ItemData getBody() {
        return this.body;
    }

    public ItemData getSaddle() {
        return this.saddle;
    }

    public ItemData getHand() {
        return this.hand;
    }

    public ItemData getOffhand() {
        return this.offhand;
    }

    public boolean isMaxFrozenState() {
        return this.isMaxFrozenState;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void setMaxFrozenState(boolean isMaxFrozenState) {
        this.isMaxFrozenState = isMaxFrozenState;
    }
}

