/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.BaseInventoryTranslator;

public abstract class AbstractBlockInventoryTranslator<Type extends Container>
extends BaseInventoryTranslator<Type> {
    private final InventoryHolder holder;
    private final InventoryUpdater updater;

    public AbstractBlockInventoryTranslator(int size, Block javaBlock, ContainerType containerType, InventoryUpdater updater, Block ... additionalValidBlocks) {
        this(size, javaBlock.defaultBlockState(), containerType, updater, additionalValidBlocks);
    }

    public AbstractBlockInventoryTranslator(int size, BlockState javaBlockState, ContainerType containerType, InventoryUpdater updater, Block ... additionalValidBlocks) {
        super(size);
        this.holder = new BlockInventoryHolder(javaBlockState, containerType, additionalValidBlocks);
        this.updater = updater;
    }

    public AbstractBlockInventoryTranslator(int size, InventoryHolder holder, InventoryUpdater updater) {
        super(size);
        this.holder = holder;
        this.updater = updater;
    }

    @Override
    public boolean requiresOpeningDelay(GeyserSession session, Type container) {
        return !((Container)container).isUsingRealBlock();
    }

    @Override
    public boolean canReuseInventory(GeyserSession session, @NonNull Inventory newInventory, @NonNull Inventory previous) {
        if (super.canReuseInventory(session, newInventory, previous) && newInventory instanceof Container) {
            Container container = (Container)newInventory;
            if (previous instanceof Container) {
                Container previousContainer = (Container)previous;
                return this.holder.canReuseContainer(session, container, previousContainer);
            }
        }
        return false;
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Type container) {
        return this.holder.prepareInventory(session, (Container)container);
    }

    @Override
    public void openInventory(GeyserSession session, Type container) {
        this.holder.openInventory(session, (Container)container);
    }

    @Override
    public void closeInventory(GeyserSession session, Type container, boolean force) {
        this.holder.closeInventory(session, (Container)container, this.closeContainerType(container));
    }

    @Override
    public void updateInventory(GeyserSession session, Type container) {
        this.updater.updateInventory(this, session, (Inventory)container);
    }

    @Override
    public void updateSlot(GeyserSession session, Type container, int slot) {
        this.updater.updateSlot(this, session, (Inventory)container, slot);
    }

    public abstract @Nullable ContainerType closeContainerType(Type var1);
}

