/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.ChestBoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.TextDisplayEntity;
import org.geysermc.geyser.entity.type.living.ArmorStandEntity;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.util.EnvironmentUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.mcprotocollib.protocol.data.game.entity.Effect;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public final class EntityUtils {
    public static final Hand[] HANDS = Hand.values();

    public static String[] getAllEffectIdentifiers() {
        String[] identifiers = new String[Effect.VALUES.length];
        for (int i = 0; i < Effect.VALUES.length; ++i) {
            identifiers[i] = "minecraft:" + Effect.VALUES[i].name().toLowerCase(Locale.ROOT);
        }
        return identifiers;
    }

    public static int toBedrockEffectId(Effect effect) {
        return switch (effect) {
            case Effect.GLOWING, Effect.LUCK, Effect.UNLUCK, Effect.DOLPHINS_GRACE -> 0;
            case Effect.LEVITATION -> 24;
            case Effect.CONDUIT_POWER -> 26;
            case Effect.SLOW_FALLING -> 27;
            case Effect.BAD_OMEN -> 28;
            case Effect.HERO_OF_THE_VILLAGE -> 29;
            case Effect.DARKNESS -> 30;
            case Effect.TRIAL_OMEN -> 31;
            case Effect.WIND_CHARGED -> 32;
            case Effect.WEAVING -> 33;
            case Effect.OOZING -> 34;
            case Effect.INFESTED -> 35;
            case Effect.RAID_OMEN -> 36;
            default -> effect.ordinal() + 1;
        };
    }

    private static float getMountedHeightOffset(Entity mount) {
        BoatEntity boat;
        if (mount instanceof BoatEntity && (boat = (BoatEntity)mount).getVariant() != BoatEntity.BoatVariant.BAMBOO) {
            return -0.1f;
        }
        float height = mount.getBoundingBoxHeight();
        float mountedHeightOffset = height * 0.75f;
        switch (mount.getDefinition().entityType()) {
            case CAMEL: {
                boolean isBaby = mount.getFlag(EntityFlag.BABY);
                mountedHeightOffset = height - (isBaby ? 0.35f : 0.6f);
                break;
            }
            case CAVE_SPIDER: 
            case CHICKEN: 
            case SPIDER: {
                mountedHeightOffset = height * 0.5f;
                break;
            }
            case DONKEY: 
            case MULE: {
                mountedHeightOffset -= 0.25f;
                break;
            }
            case TRADER_LLAMA: 
            case LLAMA: {
                mountedHeightOffset = height * 0.6f;
                break;
            }
            case MINECART: 
            case HOPPER_MINECART: 
            case TNT_MINECART: 
            case CHEST_MINECART: 
            case FURNACE_MINECART: 
            case SPAWNER_MINECART: 
            case COMMAND_BLOCK_MINECART: {
                mountedHeightOffset = 0.0f;
                break;
            }
            case BAMBOO_RAFT: 
            case BAMBOO_CHEST_RAFT: {
                mountedHeightOffset = 0.25f;
                break;
            }
            case HOGLIN: 
            case ZOGLIN: {
                boolean isBaby = mount.getFlag(EntityFlag.BABY);
                mountedHeightOffset = height - (isBaby ? 0.2f : 0.15f);
                break;
            }
            case PIGLIN: {
                mountedHeightOffset = height * 0.92f;
                break;
            }
            case PHANTOM: {
                mountedHeightOffset = height * 0.35f;
                break;
            }
            case RAVAGER: {
                mountedHeightOffset = 2.1f;
                break;
            }
            case SKELETON_HORSE: {
                mountedHeightOffset -= 0.1875f;
                break;
            }
            case SNIFFER: {
                mountedHeightOffset = 1.8f;
                break;
            }
            case STRIDER: {
                mountedHeightOffset = height - 0.19f;
            }
        }
        return mountedHeightOffset;
    }

    private static float getHeightOffset(Entity passenger) {
        switch (passenger.getDefinition().entityType()) {
            case ALLAY: 
            case VEX: {
                return 0.4f;
            }
            case SKELETON: 
            case STRAY: 
            case WITHER_SKELETON: {
                return -0.6f;
            }
            case ARMOR_STAND: {
                if (((ArmorStandEntity)passenger).isMarker()) {
                    return 0.0f;
                }
                return 0.1f;
            }
            case ENDERMITE: 
            case SILVERFISH: {
                return 0.1f;
            }
            case PIGLIN: 
            case PIGLIN_BRUTE: 
            case ZOMBIFIED_PIGLIN: {
                boolean isBaby = passenger.getFlag(EntityFlag.BABY);
                return isBaby ? -0.05f : -0.45f;
            }
            case DROWNED: 
            case HUSK: 
            case ZOMBIE_VILLAGER: 
            case ZOMBIE: {
                boolean isBaby = passenger.getFlag(EntityFlag.BABY);
                return isBaby ? 0.0f : -0.45f;
            }
            case RAVAGER: 
            case EVOKER: 
            case ILLUSIONER: 
            case PILLAGER: 
            case VINDICATOR: 
            case WITCH: {
                return -0.45f;
            }
            case PLAYER: {
                return -0.35f;
            }
            case SHULKER: {
                Entity vehicle = passenger.getVehicle();
                if (!(vehicle instanceof BoatEntity) && vehicle.getDefinition() != EntityDefinitions.MINECART) break;
                return 0.1875f - EntityUtils.getMountedHeightOffset(vehicle);
            }
        }
        if (passenger instanceof AnimalEntity) {
            return 0.14f;
        }
        return 0.0f;
    }

    public static void updateMountOffset(Entity passenger, Entity mount, boolean rider, boolean riding, boolean moreThanOneEntity) {
        passenger.setFlag(EntityFlag.RIDING, riding);
        if (riding) {
            float mountedHeightOffset = EntityUtils.getMountedHeightOffset(mount);
            float heightOffset = EntityUtils.getHeightOffset(passenger);
            float xOffset = 0.0f;
            float yOffset = mountedHeightOffset + heightOffset;
            float zOffset = 0.0f;
            switch (mount.getDefinition().entityType()) {
                case CAMEL: {
                    zOffset = 0.5f;
                    if (moreThanOneEntity) {
                        if (!rider) {
                            zOffset = -0.7f;
                        }
                        if (passenger instanceof AnimalEntity) {
                            zOffset += 0.2f;
                        }
                    }
                    if (!mount.getFlag(EntityFlag.SITTING)) break;
                    if (mount.getFlag(EntityFlag.BABY)) {
                        yOffset += 0.715f;
                        break;
                    }
                    yOffset += 1.43f;
                    break;
                }
                case CHICKEN: {
                    zOffset = -0.1f;
                    break;
                }
                case TRADER_LLAMA: 
                case LLAMA: {
                    zOffset = -0.3f;
                    break;
                }
                case TEXT_DISPLAY: {
                    if (!(passenger instanceof TextDisplayEntity)) break;
                    TextDisplayEntity textDisplay = (TextDisplayEntity)passenger;
                    Vector3f displayTranslation = textDisplay.getTranslation();
                    if (displayTranslation == null) {
                        return;
                    }
                    xOffset = displayTranslation.getX();
                    yOffset = displayTranslation.getY() + 0.2f;
                    zOffset = displayTranslation.getZ();
                    break;
                }
                case PLAYER: {
                    if (!(passenger instanceof TextDisplayEntity)) break;
                    TextDisplayEntity textDisplay = (TextDisplayEntity)passenger;
                    Vector3f displayTranslation = textDisplay.getTranslation();
                    int lines = textDisplay.getLineCount();
                    if (displayTranslation == null || lines == 0) break;
                    float multiplier = 0.1414f;
                    xOffset = displayTranslation.getX();
                    yOffset += displayTranslation.getY() + multiplier * (float)lines;
                    zOffset = displayTranslation.getZ();
                }
            }
            if (mount instanceof ChestBoatEntity) {
                xOffset = 0.15f;
            } else if (mount instanceof BoatEntity && moreThanOneEntity) {
                float f = xOffset = rider ? 0.2f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    xOffset += 0.2f;
                }
            }
            if (mount.getDefinition().entityType() == EntityType.PLAYER) {
                yOffset -= EntityDefinitions.PLAYER.offset();
            }
            if (passenger.getDefinition().entityType() == EntityType.PLAYER) {
                yOffset += EntityDefinitions.PLAYER.offset();
            }
            switch (mount.getDefinition().entityType()) {
                case MINECART: 
                case HOPPER_MINECART: 
                case TNT_MINECART: 
                case CHEST_MINECART: 
                case FURNACE_MINECART: 
                case SPAWNER_MINECART: 
                case COMMAND_BLOCK_MINECART: {
                    yOffset -= mount.getDefinition().height() * 0.5f;
                }
            }
            switch (passenger.getDefinition().entityType()) {
                case MINECART: 
                case HOPPER_MINECART: 
                case TNT_MINECART: 
                case CHEST_MINECART: 
                case FURNACE_MINECART: 
                case SPAWNER_MINECART: 
                case COMMAND_BLOCK_MINECART: {
                    yOffset += passenger.getDefinition().height() * 0.5f;
                    break;
                }
                case FALLING_BLOCK: {
                    yOffset += 0.5f;
                }
            }
            if (mount instanceof BoatEntity) {
                yOffset -= mount.getDefinition().height() * 0.5f;
            }
            if (passenger instanceof BoatEntity) {
                yOffset += passenger.getDefinition().height() * 0.5f;
            }
            if (mount instanceof ArmorStandEntity) {
                ArmorStandEntity armorStand = (ArmorStandEntity)mount;
                yOffset -= armorStand.getYOffset();
            }
            passenger.setRiderSeatPosition(Vector3f.from(xOffset, yOffset, zOffset));
        }
    }

    public static void updateRiderRotationLock(Entity passenger, Entity mount, boolean isRiding) {
        if (isRiding && mount instanceof BoatEntity) {
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, true);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION_DEGREES, Float.valueOf(90.0f));
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_HAS_ROTATION, true);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(-90.0f));
        } else {
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION, false);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_LOCK_RIDER_ROTATION_DEGREES, Float.valueOf(0.0f));
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_HAS_ROTATION, false);
            passenger.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(0.0f));
        }
    }

    public static boolean attemptToBucket(GeyserItemStack itemInHand) {
        return itemInHand.asItem() == Items.WATER_BUCKET;
    }

    public static InteractionResult attemptToSaddle(Entity entityToSaddle, GeyserItemStack itemInHand) {
        if (itemInHand.asItem() == Items.SADDLE && !entityToSaddle.getFlag(EntityFlag.SADDLED) && !entityToSaddle.getFlag(EntityFlag.BABY)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static GameType toBedrockGamemode(GameMode gamemode) {
        return switch (gamemode) {
            case GameMode.CREATIVE -> GameType.CREATIVE;
            case GameMode.ADVENTURE -> GameType.ADVENTURE;
            case GameMode.SPECTATOR -> GameType.SURVIVAL_VIEWER;
            default -> GameType.SURVIVAL;
        };
    }

    private static String translatedEntityName(@NonNull String namespace, @NonNull String name, @NonNull GeyserSession session) {
        if (EnvironmentUtils.IS_UNIT_TESTING) {
            return "entity." + namespace + "." + name;
        }
        return MinecraftLocale.getLocaleString("entity." + namespace + "." + name, session.locale());
    }

    public static String translatedEntityName(@NonNull Key type, @NonNull GeyserSession session) {
        return EntityUtils.translatedEntityName(type.namespace(), type.value(), session);
    }

    public static String translatedEntityName(@Nullable EntityType type, @NonNull GeyserSession session) {
        if (type == EntityType.PLAYER) {
            return "Player";
        }
        if (type == null) {
            return "entity.unregistered_sadface";
        }
        String typeName = type.name().toLowerCase(Locale.ROOT);
        return EntityUtils.translatedEntityName("minecraft", typeName, session);
    }

    private EntityUtils() {
    }
}

