/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.io.AbstractSerializer;
import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Assert;
import java.io.OutputStream;
import java.util.Map;

public class NamedSerializer
extends AbstractSerializer<Map<String, ?>> {
    private final String name;
    private final Serializer<Map<String, ?>> DELEGATE;

    public NamedSerializer(String name, Serializer<Map<String, ?>> serializer) {
        this.DELEGATE = Assert.notNull(serializer, "JSON Serializer cannot be null.");
        this.name = Assert.hasText(name, "Name cannot be null or empty.");
    }

    @Override
    protected void doSerialize(Map<String, ?> m4, OutputStream out) throws SerializationException {
        try {
            this.DELEGATE.serialize(m4, out);
        }
        catch (Throwable t2) {
            String msg = String.format("Cannot serialize %s to JSON. Cause: %s", this.name, t2.getMessage());
            throw new SerializationException(msg, t2);
        }
    }
}

