/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Objects;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public abstract class AbstractSerializer<T>
implements Serializer<T> {
    protected AbstractSerializer() {
    }

    @Override
    public final byte[] serialize(T t2) throws SerializationException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serialize(t2, out);
        return out.toByteArray();
    }

    @Override
    public final void serialize(T t2, OutputStream out) throws SerializationException {
        try {
            this.doSerialize(t2, out);
        }
        catch (Throwable e) {
            if (e instanceof SerializationException) {
                throw (SerializationException)e;
            }
            String msg = "Unable to serialize object of type " + Objects.nullSafeClassName(t2) + ": " + e.getMessage();
            throw new SerializationException(msg, e);
        }
    }

    protected abstract void doSerialize(T var1, OutputStream var2) throws Exception;
}

