/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.protocol.ProtocolConstants;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public class GeyserBungeePingPassthrough
implements IGeyserPingPassthrough,
Listener {
    private final ProxyServer proxyServer;

    @Override
    public GeyserPingInfo getPingInformation(InetSocketAddress inetSocketAddress) {
        ProxyPingEvent event2;
        CompletableFuture future = new CompletableFuture();
        this.proxyServer.getPluginManager().callEvent((Event)new ProxyPingEvent((PendingConnection)new GeyserPendingConnection(inetSocketAddress), this.getPingInfo(), (event, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally(throwable);
            } else {
                future.complete(event);
            }
        }));
        try {
            event2 = (ProxyPingEvent)future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable cause) {
            String address = GeyserImpl.getInstance().getConfig().isLogPlayerIpAddresses() ? inetSocketAddress.toString() : "<IP address withheld>";
            GeyserImpl.getInstance().getLogger().error("Failed to get ping information for " + address, cause);
            return null;
        }
        ServerPing response = event2.getResponse();
        return new GeyserPingInfo((String)GsonComponentSerializer.gson().serialize(BungeeComponentSerializer.get().deserialize(new BaseComponent[]{response.getDescriptionComponent()})), response.getPlayers().getMax(), response.getPlayers().getOnline());
    }

    private static ListenerInfo getDefaultListener() {
        return (ListenerInfo)ProxyServer.getInstance().getConfig().getListeners().iterator().next();
    }

    private ServerPing getPingInfo() {
        return new ServerPing(new ServerPing.Protocol(this.proxyServer.getName() + " " + (String)ProtocolConstants.SUPPORTED_VERSIONS.get(0) + "-" + (String)ProtocolConstants.SUPPORTED_VERSIONS.get(ProtocolConstants.SUPPORTED_VERSIONS.size() - 1), ((Integer)ProtocolConstants.SUPPORTED_VERSION_IDS.get(ProtocolConstants.SUPPORTED_VERSION_IDS.size() - 1)).intValue()), new ServerPing.Players(GeyserBungeePingPassthrough.getDefaultListener().getMaxPlayers(), this.proxyServer.getOnlineCount(), null), TextComponent.fromLegacyText((String)GeyserBungeePingPassthrough.getDefaultListener().getMotd())[0], this.proxyServer.getConfig().getFaviconObject());
    }

    public GeyserBungeePingPassthrough(ProxyServer proxyServer) {
        this.proxyServer = proxyServer;
    }

    private static class GeyserPendingConnection
    implements PendingConnection {
        private static final UUID FAKE_UUID = UUID.nameUUIDFromBytes("geyser!internal".getBytes());
        private final InetSocketAddress remote;

        public GeyserPendingConnection(InetSocketAddress remote) {
            this.remote = remote;
        }

        public String getName() {
            throw new UnsupportedOperationException();
        }

        public int getVersion() {
            return (Integer)ProtocolConstants.SUPPORTED_VERSION_IDS.get(ProtocolConstants.SUPPORTED_VERSION_IDS.size() - 1);
        }

        public @Nullable InetSocketAddress getVirtualHost() {
            return null;
        }

        public ListenerInfo getListener() {
            return GeyserBungeePingPassthrough.getDefaultListener();
        }

        public String getUUID() {
            return FAKE_UUID.toString();
        }

        public UUID getUniqueId() {
            return FAKE_UUID;
        }

        public void setUniqueId(UUID uuid) {
            throw new UnsupportedOperationException();
        }

        public boolean isOnlineMode() {
            return true;
        }

        public void setOnlineMode(boolean b) {
            throw new UnsupportedOperationException();
        }

        public boolean isLegacy() {
            return false;
        }

        public InetSocketAddress getAddress() {
            return this.remote;
        }

        public SocketAddress getSocketAddress() {
            return this.getAddress();
        }

        public void disconnect(String s2) {
            throw new UnsupportedOperationException();
        }

        public void disconnect(BaseComponent ... baseComponents) {
            throw new UnsupportedOperationException();
        }

        public void disconnect(BaseComponent baseComponent) {
            throw new UnsupportedOperationException();
        }

        public boolean isConnected() {
            return false;
        }

        public boolean isTransferred() {
            return false;
        }

        public CompletableFuture<byte[]> retrieveCookie(String s2) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<byte[]> sendData(String s2, byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        public Connection.Unsafe unsafe() {
            throw new UnsupportedOperationException();
        }
    }
}

