/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.util.Arrays;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.core.Base64Variants;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.core.JsonToken;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.node.ValueNode;

public class BinaryNode
extends ValueNode {
    private static final long serialVersionUID = 2L;
    static final BinaryNode EMPTY_BINARY_NODE = new BinaryNode(new byte[0]);
    protected final byte[] _data;

    public BinaryNode(byte[] data) {
        this._data = data;
    }

    public BinaryNode(byte[] data, int offset, int length) {
        if (offset == 0 && length == data.length) {
            this._data = data;
        } else {
            this._data = new byte[length];
            System.arraycopy(data, offset, this._data, 0, length);
        }
    }

    public static BinaryNode valueOf(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(data);
    }

    public static BinaryNode valueOf(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(data, offset, length);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.BINARY;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() {
        return this._data;
    }

    @Override
    public String asText() {
        return Base64Variants.getDefaultVariant().encode(this._data, false);
    }

    @Override
    public final void serialize(JsonGenerator g2, SerializerProvider provider) throws IOException {
        if (this._data == null) {
            g2.writeNull();
            return;
        }
        g2.writeBinary(provider.getConfig().getBase64Variant(), this._data, 0, this._data.length);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BinaryNode) {
            byte[] otherData = ((BinaryNode)o)._data;
            if (this._data == otherData) {
                return true;
            }
            if (this._data == null || otherData == null) {
                return false;
            }
            return Arrays.equals(this._data, otherData);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._data == null ? -1 : this._data.length;
    }
}

