/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.versions;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockPermutation;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.component.BoxComponent;
import org.geysermc.geyser.api.block.custom.component.GeometryComponent;
import org.geysermc.geyser.api.block.custom.component.MaterialInstance;
import org.geysermc.geyser.api.block.custom.component.PlacementConditions;
import org.geysermc.geyser.api.block.custom.component.TransformationComponent;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.level.block.GeyserCustomBlockComponents;
import org.geysermc.geyser.level.block.GeyserCustomBlockData;
import org.geysermc.geyser.level.block.GeyserGeometryComponent;
import org.geysermc.geyser.level.block.GeyserMaterialInstance;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.platform.bungeecord.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.mappings.util.CustomBlockComponentsMapping;
import org.geysermc.geyser.registry.mappings.util.CustomBlockMapping;
import org.geysermc.geyser.registry.mappings.util.CustomBlockStateBuilderMapping;
import org.geysermc.geyser.registry.mappings.util.CustomBlockStateMapping;
import org.geysermc.geyser.registry.mappings.versions.MappingsReader;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.geyser.util.MinecraftKey;

public class MappingsReader_v1
extends MappingsReader {
    @Override
    public void readItemMappings(Path file, JsonNode mappingsRoot, BiConsumer<String, CustomItemData> consumer) {
        this.readItemMappingsV1(file, mappingsRoot, consumer);
    }

    @Override
    public void readBlockMappings(Path file, JsonNode mappingsRoot, BiConsumer<String, CustomBlockMapping> consumer) {
        this.readBlockMappingsV1(file, mappingsRoot, consumer);
    }

    public void readItemMappingsV1(Path file, JsonNode mappingsRoot, BiConsumer<String, CustomItemData> consumer) {
        JsonNode itemsNode = mappingsRoot.get("items");
        if (itemsNode != null && itemsNode.isObject()) {
            itemsNode.fields().forEachRemaining(entry -> {
                if (((JsonNode)entry.getValue()).isArray()) {
                    ((JsonNode)entry.getValue()).forEach(data -> {
                        try {
                            CustomItemData customItemData = this.readItemMappingEntry((JsonNode)data);
                            consumer.accept((String)entry.getKey(), customItemData);
                        }
                        catch (InvalidCustomMappingsFileException e) {
                            GeyserImpl.getInstance().getLogger().error("Error in registering items for custom mapping file: " + file.toString(), e);
                        }
                    });
                }
            });
        }
    }

    public void readBlockMappingsV1(Path file, JsonNode mappingsRoot, BiConsumer<String, CustomBlockMapping> consumer) {
        JsonNode blocksNode = mappingsRoot.get("blocks");
        if (blocksNode != null && blocksNode.isObject()) {
            blocksNode.fields().forEachRemaining(entry -> {
                if (((JsonNode)entry.getValue()).isObject()) {
                    try {
                        String identifier = MinecraftKey.key((String)entry.getKey()).asString();
                        CustomBlockMapping customBlockMapping = this.readBlockMappingEntry(identifier, (JsonNode)entry.getValue());
                        consumer.accept(identifier, customBlockMapping);
                    }
                    catch (Exception e) {
                        GeyserImpl.getInstance().getLogger().error("Error in registering blocks for custom mapping file: " + file.toString());
                        GeyserImpl.getInstance().getLogger().error("due to entry: " + String.valueOf(entry), e);
                    }
                }
            });
        }
    }

    private CustomItemOptions readItemCustomItemOptions(JsonNode node) {
        JsonNode defaultItem;
        JsonNode unbreakable;
        JsonNode damagePredicate;
        CustomItemOptions.Builder customItemOptions = CustomItemOptions.builder();
        JsonNode customModelData = node.get("custom_model_data");
        if (customModelData != null && customModelData.isInt()) {
            customItemOptions.customModelData(customModelData.asInt());
        }
        if ((damagePredicate = node.get("damage_predicate")) != null && damagePredicate.isInt()) {
            customItemOptions.damagePredicate(damagePredicate.asInt());
        }
        if ((unbreakable = node.get("unbreakable")) != null && unbreakable.isBoolean()) {
            customItemOptions.unbreakable(unbreakable.asBoolean());
        }
        if ((defaultItem = node.get("default")) != null && defaultItem.isBoolean()) {
            customItemOptions.defaultItem(defaultItem.asBoolean());
        }
        return customItemOptions.build();
    }

    @Override
    public CustomItemData readItemMappingEntry(JsonNode node) throws InvalidCustomMappingsFileException {
        JsonNode jsonNode;
        if (node == null || !node.isObject()) {
            throw new InvalidCustomMappingsFileException("Invalid item mappings entry");
        }
        JsonNode name = node.get("name");
        if (name == null || !name.isTextual() || name.asText().isEmpty()) {
            throw new InvalidCustomMappingsFileException("An item entry has no name");
        }
        CustomItemData.Builder customItemData = CustomItemData.builder().name(name.asText()).customItemOptions(this.readItemCustomItemOptions(node));
        if (node.has("display_name")) {
            customItemData.displayName(node.get("display_name").asText());
        }
        if (node.has("icon")) {
            customItemData.icon(node.get("icon").asText());
        }
        if (node.has("creative_category")) {
            customItemData.creativeCategory(node.get("creative_category").asInt());
        }
        if (node.has("creative_group")) {
            customItemData.creativeGroup(node.get("creative_group").asText());
        }
        if (node.has("allow_offhand")) {
            customItemData.allowOffhand(node.get("allow_offhand").asBoolean());
        }
        if (node.has("display_handheld")) {
            customItemData.displayHandheld(node.get("display_handheld").asBoolean());
        }
        if (node.has("texture_size")) {
            customItemData.textureSize(node.get("texture_size").asInt());
        }
        if (node.has("render_offsets")) {
            JsonNode tmpNode = node.get("render_offsets");
            customItemData.renderOffsets(this.fromJsonNode(tmpNode));
        }
        if ((jsonNode = node.get("tags")) instanceof ArrayNode) {
            ArrayNode tags = (ArrayNode)jsonNode;
            ObjectOpenHashSet<String> tagsSet = new ObjectOpenHashSet<String>();
            tags.forEach(tag -> tagsSet.add(tag.asText()));
            customItemData.tags(tagsSet);
        }
        return customItemData.build();
    }

    @Override
    public CustomBlockMapping readBlockMappingEntry(String identifier, JsonNode node) throws InvalidCustomMappingsFileException {
        if (node == null || !node.isObject()) {
            throw new InvalidCustomMappingsFileException("Invalid block mappings entry:" + String.valueOf(node));
        }
        String name = node.get("name").asText();
        if (name == null || name.isEmpty()) {
            throw new InvalidCustomMappingsFileException("A block entry has no name");
        }
        boolean includedInCreativeInventory = node.has("included_in_creative_inventory") && node.get("included_in_creative_inventory").asBoolean();
        CreativeCategory creativeCategory = CreativeCategory.NONE;
        if (node.has("creative_category")) {
            String categoryName = node.get("creative_category").asText();
            try {
                creativeCategory = CreativeCategory.valueOf(categoryName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidCustomMappingsFileException("Invalid creative category \"" + categoryName + "\" for block \"" + name + "\"");
            }
        }
        String creativeGroup = "";
        if (node.has("creative_group")) {
            creativeGroup = node.get("creative_group").asText();
        }
        boolean onlyOverrideStates = node.has("only_override_states") && node.get("only_override_states").asBoolean();
        GeyserCustomBlockData.Builder customBlockDataBuilder = new GeyserCustomBlockData.Builder().name(name).includedInCreativeInventory(includedInCreativeInventory).creativeCategory(creativeCategory).creativeGroup(creativeGroup);
        if (((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).containsKey(identifier)) {
            CustomBlockComponentsMapping componentsMapping = this.createCustomBlockComponentsMapping(node, identifier, name);
            CustomBlockData blockData = customBlockDataBuilder.components(componentsMapping.components()).build();
            return new CustomBlockMapping(blockData, Map.of(identifier, new CustomBlockStateMapping(blockData.defaultBlockState(), componentsMapping.extendedCollisionBox())), identifier, !onlyOverrideStates);
        }
        LinkedHashMap<String, CustomBlockComponentsMapping> componentsMap = new LinkedHashMap<String, CustomBlockComponentsMapping>();
        JsonNode stateOverrides = node.get("state_overrides");
        if (stateOverrides != null && stateOverrides.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> fields = stateOverrides.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> overrideEntry = fields.next();
                String state2 = identifier + "[" + overrideEntry.getKey() + "]";
                if (!((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).containsKey(state2)) {
                    throw new InvalidCustomMappingsFileException("Unknown Java block state: " + state2 + " for state_overrides.");
                }
                componentsMap.put(state2, this.createCustomBlockComponentsMapping(overrideEntry.getValue(), state2, name));
            }
        }
        if (componentsMap.isEmpty() && onlyOverrideStates) {
            throw new InvalidCustomMappingsFileException("Block entry for " + identifier + " has only_override_states set to true, but has no state_overrides.");
        }
        if (!onlyOverrideStates) {
            ((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).keySet().stream().filter(s2 -> s2.startsWith(identifier + "[")).filter(Predicate.not(componentsMap::containsKey)).forEach(state -> componentsMap.put((String)state, this.createCustomBlockComponentsMapping(null, (String)state, name)));
        }
        if (componentsMap.isEmpty()) {
            throw new InvalidCustomMappingsFileException("Unknown Java block: " + identifier);
        }
        String firstState = (String)componentsMap.keySet().iterator().next();
        CustomBlockComponentsMapping firstComponentsMapping = this.createCustomBlockComponentsMapping(node, firstState, name);
        customBlockDataBuilder.components(firstComponentsMapping.components());
        return this.createCustomBlockMapping(customBlockDataBuilder, componentsMap, identifier, !onlyOverrideStates);
    }

    private CustomBlockMapping createCustomBlockMapping(CustomBlockData.Builder customBlockDataBuilder, Map<String, CustomBlockComponentsMapping> componentsMap, String identifier, boolean overrideItem) {
        Object2ObjectOpenHashMap<String, LinkedHashSet> valuesMap = new Object2ObjectOpenHashMap<String, LinkedHashSet>();
        ArrayList<CustomBlockPermutation> permutations = new ArrayList<CustomBlockPermutation>();
        Object2ObjectOpenHashMap<String, CustomBlockStateBuilderMapping> blockStateBuilders = new Object2ObjectOpenHashMap<String, CustomBlockStateBuilderMapping>();
        for (Map.Entry<String, CustomBlockComponentsMapping> entry : componentsMap.entrySet()) {
            String state = entry.getKey();
            String[] pairs = this.splitStateString(state);
            CharSequence[] conditions = new String[pairs.length];
            Function blockStateBuilder = Function.identity();
            for (int i = 0; i < pairs.length; ++i) {
                String[] parts = pairs[i].split("=");
                String property = parts[0];
                String value2 = parts[1];
                valuesMap.computeIfAbsent(property, k -> new LinkedHashSet()).add(value2);
                conditions[i] = String.format("q.block_property('%s') == '%s'", property, value2);
                blockStateBuilder = blockStateBuilder.andThen(builder -> builder.stringProperty(property, value2));
            }
            permutations.add(new CustomBlockPermutation(entry.getValue().components(), String.join((CharSequence)" && ", conditions)));
            blockStateBuilders.put(state, new CustomBlockStateBuilderMapping(blockStateBuilder.andThen(CustomBlockState.Builder::build), entry.getValue().extendedCollisionBox()));
        }
        valuesMap.forEach((key, value) -> customBlockDataBuilder.stringProperty((String)key, (List<String>)new ArrayList<String>((Collection<String>)value)));
        CustomBlockData customBlockData = customBlockDataBuilder.permutations(permutations).build();
        Map<String, CustomBlockStateMapping> states = blockStateBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new CustomBlockStateMapping(((CustomBlockStateBuilderMapping)e.getValue()).builder().apply(customBlockData.blockStateBuilder()), ((CustomBlockStateBuilderMapping)e.getValue()).extendedCollisionBox())));
        return new CustomBlockMapping(customBlockData, states, identifier, overrideItem);
    }

    private CustomBlockComponentsMapping createCustomBlockComponentsMapping(JsonNode node, String stateKey, String name) {
        JsonNode conditions;
        JsonNode placementFilter;
        JsonNode materialInstances;
        BoxComponent extendedCollisionBox;
        BoxComponent collisionBox;
        int id = BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault(stateKey, -1);
        BoxComponent boxComponent = this.createBoxComponent(id);
        BoxComponent extendedBoxComponent = this.createExtendedBoxComponent(id);
        GeyserCustomBlockComponents.Builder builder = new GeyserCustomBlockComponents.Builder().collisionBox(boxComponent).selectionBox(boxComponent);
        if (node == null) {
            return new CustomBlockComponentsMapping(builder.build(), extendedBoxComponent);
        }
        BoxComponent selectionBox = this.createBoxComponent(node.get("selection_box"));
        if (selectionBox != null) {
            builder.selectionBox(selectionBox);
        }
        if ((collisionBox = this.createBoxComponent(node.get("collision_box"))) != null) {
            builder.collisionBox(collisionBox);
        }
        if ((extendedCollisionBox = this.createBoxComponent(node.get("extended_collision_box"))) != null) {
            extendedBoxComponent = extendedCollisionBox;
        }
        float destructibleByMining = Float.MAX_VALUE;
        if (node.has("destructible_by_mining")) {
            destructibleByMining = node.get("destructible_by_mining").floatValue();
        }
        builder.destructibleByMining(Float.valueOf(destructibleByMining));
        if (node.has("geometry")) {
            if (node.get("geometry").isTextual()) {
                builder.geometry(new GeyserGeometryComponent.Builder().identifier(node.get("geometry").asText()).build());
            } else {
                JsonNode boneVisibility;
                JsonNode geometry = node.get("geometry");
                GeyserGeometryComponent.Builder geometryBuilder = new GeyserGeometryComponent.Builder();
                if (geometry.has("identifier")) {
                    geometryBuilder.identifier(geometry.get("identifier").asText());
                }
                if (geometry.has("bone_visibility") && (boneVisibility = geometry.get("bone_visibility")).isObject()) {
                    Object2ObjectOpenHashMap<String, String> boneVisibilityMap = new Object2ObjectOpenHashMap<String, String>();
                    boneVisibility.fields().forEachRemaining(entry -> {
                        String key = (String)entry.getKey();
                        String value = ((JsonNode)entry.getValue()).isBoolean() ? (((JsonNode)entry.getValue()).asBoolean() ? "1" : "0") : ((JsonNode)entry.getValue()).asText();
                        boneVisibilityMap.put(key, value);
                    });
                    geometryBuilder.boneVisibility(boneVisibilityMap);
                }
                builder.geometry(geometryBuilder.build());
            }
        }
        String displayName = name;
        if (node.has("display_name")) {
            displayName = node.get("display_name").asText();
        }
        builder.displayName(displayName);
        if (node.has("friction")) {
            builder.friction(Float.valueOf(node.get("friction").floatValue()));
        }
        if (node.has("light_emission")) {
            builder.lightEmission(node.get("light_emission").asInt());
        }
        if (node.has("light_dampening")) {
            builder.lightDampening(node.get("light_dampening").asInt());
        }
        boolean placeAir = true;
        if (node.has("place_air")) {
            placeAir = node.get("place_air").asBoolean();
        }
        builder.placeAir(placeAir);
        if (node.has("transformation")) {
            JsonNode transformation = node.get("transformation");
            int rotationX = 0;
            int rotationY = 0;
            int rotationZ = 0;
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            float scaleZ = 1.0f;
            float transformX = 0.0f;
            float transformY = 0.0f;
            float transformZ = 0.0f;
            if (transformation.has("rotation")) {
                JsonNode rotation = transformation.get("rotation");
                rotationX = rotation.get(0).asInt();
                rotationY = rotation.get(1).asInt();
                rotationZ = rotation.get(2).asInt();
            }
            if (transformation.has("scale")) {
                JsonNode scale = transformation.get("scale");
                scaleX = scale.get(0).floatValue();
                scaleY = scale.get(1).floatValue();
                scaleZ = scale.get(2).floatValue();
            }
            if (transformation.has("translation")) {
                JsonNode translation = transformation.get("translation");
                transformX = translation.get(0).floatValue();
                transformY = translation.get(1).floatValue();
                transformZ = translation.get(2).floatValue();
            }
            builder.transformation(new TransformationComponent(rotationX, rotationY, rotationZ, scaleX, scaleY, scaleZ, transformX, transformY, transformZ));
        }
        if (node.has("unit_cube")) {
            builder.geometry(GeometryComponent.builder().identifier("minecraft:geometry.full_block").build());
        }
        if (node.has("material_instances") && (materialInstances = node.get("material_instances")).isObject()) {
            materialInstances.fields().forEachRemaining(entry -> {
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isObject()) {
                    MaterialInstance materialInstance = this.createMaterialInstanceComponent(value);
                    builder.materialInstance(key, materialInstance);
                }
            });
        }
        if (node.has("placement_filter") && (placementFilter = node.get("placement_filter")).isObject() && placementFilter.has("conditions") && (conditions = placementFilter.get("conditions")).isArray()) {
            List<PlacementConditions> filter = this.createPlacementFilterComponent(conditions);
            builder.placementFilter(filter);
        }
        if ((conditions = node.get("tags")) instanceof ArrayNode) {
            ArrayNode tags = (ArrayNode)conditions;
            ObjectOpenHashSet<String> tagsSet = new ObjectOpenHashSet<String>();
            tags.forEach(tag -> tagsSet.add(tag.asText()));
            builder.tags(tagsSet);
        }
        return new CustomBlockComponentsMapping(builder.build(), extendedBoxComponent);
    }

    private BoxComponent createBoxComponent(int javaId, float heightTranslation) {
        BlockCollision blockCollision = BlockUtils.getCollision(javaId);
        if (blockCollision == null || blockCollision.getBoundingBoxes().length == 0) {
            return BoxComponent.emptyBox();
        }
        float minX = 5.0f;
        float minY = 5.0f;
        float minZ = 5.0f;
        float maxX = -5.0f;
        float maxY = -5.0f;
        float maxZ = -5.0f;
        for (BoundingBox boundingBox : blockCollision.getBoundingBoxes()) {
            double offsetX = boundingBox.getSizeX() * 0.5;
            double offsetY = boundingBox.getSizeY() * 0.5;
            double offsetZ = boundingBox.getSizeZ() * 0.5;
            minX = Math.min(minX, (float)(boundingBox.getMiddleX() - offsetX));
            minY = Math.min(minY, (float)(boundingBox.getMiddleY() - offsetY));
            minZ = Math.min(minZ, (float)(boundingBox.getMiddleZ() - offsetZ));
            maxX = Math.max(maxX, (float)(boundingBox.getMiddleX() + offsetX));
            maxY = Math.max(maxY, (float)(boundingBox.getMiddleY() + offsetY));
            maxZ = Math.max(maxZ, (float)(boundingBox.getMiddleZ() + offsetZ));
        }
        minX = MathUtils.clamp(minX, 0.0f, 1.0f);
        minY = MathUtils.clamp(minY + heightTranslation, 0.0f, 1.0f);
        minZ = MathUtils.clamp(minZ, 0.0f, 1.0f);
        maxX = MathUtils.clamp(maxX, 0.0f, 1.0f);
        maxY = MathUtils.clamp(maxY + heightTranslation, 0.0f, 1.0f);
        maxZ = MathUtils.clamp(maxZ, 0.0f, 1.0f);
        return new BoxComponent(16.0f * (1.0f - maxX) - 8.0f, 16.0f * minY, 16.0f * minZ - 8.0f, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ));
    }

    private BoxComponent createBoxComponent(int javaId) {
        return this.createBoxComponent(javaId, 0.0f);
    }

    private @Nullable BoxComponent createExtendedBoxComponent(int javaId) {
        BlockCollision blockCollision = BlockUtils.getCollision(javaId);
        if (blockCollision == null) {
            return null;
        }
        for (BoundingBox box : blockCollision.getBoundingBoxes()) {
            double maxY = 0.5 * box.getSizeY() + box.getMiddleY();
            if (!(maxY > 1.0)) continue;
            return this.createBoxComponent(javaId, -1.0f);
        }
        return null;
    }

    private @Nullable BoxComponent createBoxComponent(JsonNode node) {
        if (node != null && node.isObject() && node.has("origin") && node.has("size")) {
            JsonNode origin = node.get("origin");
            float originX = origin.get(0).floatValue();
            float originY = origin.get(1).floatValue();
            float originZ = origin.get(2).floatValue();
            JsonNode size = node.get("size");
            float sizeX = size.get(0).floatValue();
            float sizeY = size.get(1).floatValue();
            float sizeZ = size.get(2).floatValue();
            return new BoxComponent(originX, originY, originZ, sizeX, sizeY, sizeZ);
        }
        return null;
    }

    private MaterialInstance createMaterialInstanceComponent(JsonNode node) {
        String texture = null;
        if (node.has("texture")) {
            texture = node.get("texture").asText();
        }
        String renderMethod = "opaque";
        if (node.has("render_method")) {
            renderMethod = node.get("render_method").asText();
        }
        boolean faceDimming = true;
        if (node.has("face_dimming")) {
            faceDimming = node.get("face_dimming").asBoolean();
        }
        boolean ambientOcclusion = true;
        if (node.has("ambient_occlusion")) {
            ambientOcclusion = node.get("ambient_occlusion").asBoolean();
        }
        return new GeyserMaterialInstance.Builder().texture(texture).renderMethod(renderMethod).faceDimming(faceDimming).ambientOcclusion(ambientOcclusion).build();
    }

    private List<PlacementConditions> createPlacementFilterComponent(JsonNode node) {
        ArrayList<PlacementConditions> conditions = new ArrayList<PlacementConditions>();
        node.forEach(condition -> {
            JsonNode blockFilter;
            JsonNode allowedFaces;
            EnumSet<PlacementConditions.Face> faces = EnumSet.noneOf(PlacementConditions.Face.class);
            if (condition.has("allowed_faces") && (allowedFaces = condition.get("allowed_faces")).isArray()) {
                allowedFaces.forEach(face -> faces.add(PlacementConditions.Face.valueOf(face.asText().toUpperCase())));
            }
            LinkedHashMap<String, PlacementConditions.BlockFilterType> blockFilters = new LinkedHashMap<String, PlacementConditions.BlockFilterType>();
            if (condition.has("block_filter") && (blockFilter = condition.get("block_filter")).isArray()) {
                blockFilter.forEach(filter -> {
                    if (filter.isObject()) {
                        if (filter.has("tags")) {
                            JsonNode tags = filter.get("tags");
                            blockFilters.put(tags.asText(), PlacementConditions.BlockFilterType.TAG);
                        }
                    } else if (filter.isTextual()) {
                        blockFilters.put(filter.asText(), PlacementConditions.BlockFilterType.BLOCK);
                    }
                });
            }
            conditions.add(new PlacementConditions(faces, blockFilters));
        });
        return conditions;
    }

    private String[] splitStateString(String state) {
        int openBracketIndex = state.indexOf("[");
        String states = state.substring(openBracketIndex + 1, state.length() - 1);
        return states.split(",");
    }
}

