/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.platform.velocity.shaded.com.fasterxml.jackson.databind.JsonNode;

public class WebUtils {
    private static final Path REMOTE_PACK_CACHE = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("remote_packs");

    public static String getBody(String reqURL) throws IOException {
        try {
            URL url = new URL(reqURL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            return WebUtils.connectionToString(con);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unable to resolve requested url (%s)! Are you offline?".formatted(reqURL), e);
        }
    }

    public static JsonNode getJson(String reqURL) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(reqURL).openConnection();
        con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
        con.setConnectTimeout(10000);
        con.setReadTimeout(10000);
        return GeyserImpl.JSON_MAPPER.readTree(con.getInputStream());
    }

    public static void downloadFile(String reqURL, String fileLocation) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(reqURL).openConnection();
            con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
            InputStream in = con.getInputStream();
            Files.copy(in, Paths.get(fileLocation, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to download and save file: " + fileLocation + " (" + reqURL + ")", e);
        }
    }

    public static @Nullable Path downloadRemotePack(String url, boolean force) {
        GeyserLogger logger = GeyserImpl.getInstance().getLogger();
        try {
            Path downloadLocation;
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            con.setRequestProperty("User-Agent", "Geyser-" + GeyserImpl.getInstance().getPlatformType().platformName() + "/2.7.1-b839 (git-master-4f413d3)");
            con.setInstanceFollowRedirects(true);
            int responseCode = con.getResponseCode();
            if (responseCode >= 400) {
                throw new IllegalStateException(String.format("Invalid response code from remote pack at URL: %s (code: %d)", url, responseCode));
            }
            int size = con.getContentLength();
            String type = con.getContentType();
            if (size <= 0) {
                throw new IllegalArgumentException(String.format("Invalid content length received from remote pack at URL: %s (size: %d)", url, size));
            }
            if (type == null || !type.equals("application/zip")) {
                throw new IllegalArgumentException(String.format("Url %s tries to provide a resource pack using the %s content type, which is not supported by Bedrock edition! Bedrock Edition only supports the application/zip content type.", url, type));
            }
            Path packMetadata = REMOTE_PACK_CACHE.resolve(url.hashCode() + ".metadata");
            if (Files.exists(packMetadata, new LinkOption[0]) && !force) {
                try {
                    List<String> metadata = Files.readAllLines(packMetadata, StandardCharsets.UTF_8);
                    int cachedSize = Integer.parseInt(metadata.get(0));
                    String cachedEtag = metadata.get(1);
                    long cachedLastModified = Long.parseLong(metadata.get(2));
                    downloadLocation = REMOTE_PACK_CACHE.resolve(metadata.get(3));
                    if (cachedSize == size && cachedEtag.equals(con.getHeaderField("ETag")) && cachedLastModified == con.getLastModified() && downloadLocation.toFile().exists()) {
                        logger.debug("Using cached pack (%s) for %s.".formatted(downloadLocation.getFileName(), url));
                        downloadLocation.toFile().setLastModified(System.currentTimeMillis());
                        packMetadata.toFile().setLastModified(System.currentTimeMillis());
                        return downloadLocation;
                    }
                    logger.debug("Deleting cached pack/metadata (%s) as it appears to have changed!".formatted(url));
                    Files.deleteIfExists(packMetadata);
                    Files.deleteIfExists(downloadLocation);
                }
                catch (IOException e) {
                    GeyserImpl.getInstance().getLogger().error("Failed to read cached pack metadata! " + String.valueOf(e));
                    packMetadata.toFile().deleteOnExit();
                }
            }
            downloadLocation = REMOTE_PACK_CACHE.resolve(url.hashCode() + "_" + System.currentTimeMillis() + ".zip");
            Files.copy(con.getInputStream(), downloadLocation, StandardCopyOption.REPLACE_EXISTING);
            long downloadSize = Files.size(downloadLocation);
            if (downloadSize != (long)size) {
                Files.delete(downloadLocation);
                throw new IllegalStateException("Size mismatch with resource pack at url: %s. Downloaded pack has %s bytes, expected %s bytes!".formatted(url, downloadSize, size));
            }
            try {
                Files.write(packMetadata, Arrays.asList(String.valueOf(size), con.getHeaderField("ETag"), String.valueOf(con.getLastModified()), downloadLocation.getFileName().toString()), new OpenOption[0]);
                packMetadata.toFile().setLastModified(System.currentTimeMillis());
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().error("Failed to write cached pack metadata: " + e.getMessage());
                Files.delete(packMetadata);
                Files.delete(downloadLocation);
                return null;
            }
            downloadLocation.toFile().setLastModified(System.currentTimeMillis());
            return downloadLocation;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to download resource pack from malformed URL %s! ".formatted(url));
        }
        catch (ConnectException | SocketTimeoutException e) {
            logger.error("Unable to download pack from url %s due to network error! ( %s )".formatted(url, e.getMessage()));
            logger.debug(e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to download and save remote resource pack from: %s ( %s )!".formatted(url, e.getMessage()));
        }
        return null;
    }

    public static String post(String reqURL, String postContent) throws IOException {
        URL url = new URL(reqURL);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "text/plain");
        con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
        con.setDoOutput(true);
        OutputStream out = con.getOutputStream();
        out.write(postContent.getBytes(StandardCharsets.UTF_8));
        out.close();
        return WebUtils.connectionToString(con);
    }

    private static String connectionToString(HttpURLConnection con) throws IOException {
        con.getResponseCode();
        InputStream inputStream = con.getErrorStream();
        if (inputStream == null) {
            inputStream = con.getInputStream();
        }
        StringBuilder content = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
                content.append("\n");
            }
            con.disconnect();
        }
        return content.toString();
    }

    public static String postForm(String reqURL, Map<String, String> fields) throws IOException {
        URL url = new URL(reqURL);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
        con.setDoOutput(true);
        try (OutputStream out = con.getOutputStream();){
            for (Map.Entry<String, String> field : fields.entrySet()) {
                out.write((field.getKey() + "=" + URLEncoder.encode(field.getValue(), StandardCharsets.UTF_8) + "&").getBytes(StandardCharsets.UTF_8));
            }
        }
        return WebUtils.connectionToString(con);
    }

    public static String @Nullable [] findSrvRecord(GeyserImpl geyser, String remoteAddress) {
        block3: {
            try {
                InitialDirContext ctx = new InitialDirContext();
                Attribute attr = ctx.getAttributes("dns:///_minecraft._tcp." + remoteAddress, new String[]{"SRV"}).get("SRV");
                if (attr != null && attr.size() > 0) {
                    return ((String)attr.get(0)).split(" ");
                }
            }
            catch (Exception | NoClassDefFoundError ex) {
                if (!geyser.getConfig().isDebugMode()) break block3;
                geyser.getLogger().debug("Exception while trying to find an SRV record for the remote host.");
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static Stream<String> getLineStream(String reqURL) {
        try {
            URL url = new URL(reqURL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", WebUtils.getUserAgent());
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            return WebUtils.connectionToString(con).lines();
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Error while trying to get a stream from " + reqURL, e);
            return Stream.empty();
        }
    }

    public static String getUserAgent() {
        return "Geyser-" + GeyserImpl.getInstance().getPlatformType().platformName() + "/2.7.1-b839 (git-master-4f413d3)";
    }
}

