/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.inventory.transaction;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.common.util.Preconditions;

public final class InventorySource {
    private static final InventorySource CREATIVE_SOURCE = new InventorySource(Type.CREATIVE, -1, Flag.NONE);
    private static final InventorySource GLOBAL_SOURCE = new InventorySource(Type.GLOBAL, -1, Flag.NONE);
    private static final InventorySource INVALID_SOURCE = new InventorySource(Type.INVALID, -1, Flag.NONE);
    private final Type type;
    private final int containerId;
    private final Flag flag;

    public static InventorySource fromContainerWindowId(int containerId) {
        Preconditions.checkNotNull(containerId, "containerId");
        return new InventorySource(Type.CONTAINER, containerId, Flag.NONE);
    }

    public static InventorySource fromCreativeInventory() {
        return CREATIVE_SOURCE;
    }

    public static InventorySource fromGlobalInventory() {
        return GLOBAL_SOURCE;
    }

    public static InventorySource fromInvalid() {
        return INVALID_SOURCE;
    }

    public static InventorySource fromNonImplementedTodo(int containerId) {
        Preconditions.checkNotNull(containerId, "containerId");
        return new InventorySource(Type.NON_IMPLEMENTED_TODO, containerId, Flag.NONE);
    }

    public static InventorySource fromUntrackedInteractionUI(int containerId) {
        Preconditions.checkNotNull(containerId, "containerId");
        return new InventorySource(Type.UNTRACKED_INTERACTION_UI, containerId, Flag.NONE);
    }

    public static InventorySource fromWorldInteraction(@NonNull Flag flag) {
        Preconditions.checkNotNull(flag, "flag");
        return new InventorySource(Type.WORLD_INTERACTION, -1, flag);
    }

    public Type getType() {
        return this.type;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventorySource)) {
            return false;
        }
        InventorySource other = (InventorySource)o;
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Flag this$flag = this.getFlag();
        Flag other$flag = other.getFlag();
        return !(this$flag == null ? other$flag != null : !((Object)((Object)this$flag)).equals((Object)other$flag));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Flag $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : ((Object)((Object)$flag)).hashCode());
        return result;
    }

    public String toString() {
        return "InventorySource(type=" + (Object)((Object)this.getType()) + ", containerId=" + this.getContainerId() + ", flag=" + (Object)((Object)this.getFlag()) + ")";
    }

    private InventorySource(Type type, int containerId, Flag flag) {
        this.type = type;
        this.containerId = containerId;
        this.flag = flag;
    }

    public static enum Flag {
        DROP_ITEM,
        PICKUP_ITEM,
        NONE;

    }

    public static enum Type {
        INVALID(-1),
        CONTAINER(0),
        GLOBAL(1),
        WORLD_INTERACTION(2),
        CREATIVE(3),
        UNTRACKED_INTERACTION_UI(100),
        NON_IMPLEMENTED_TODO(99999);

        private static final Int2ObjectMap<Type> BY_ID;
        private final int id;

        private Type(int id) {
            this.id = id;
        }

        public static Type byId(int id) {
            Type type = (Type)((Object)BY_ID.get(id));
            return type == null ? INVALID : type;
        }

        public int id() {
            return this.id;
        }

        static {
            BY_ID = new Int2ObjectOpenHashMap<Type>(6);
            for (Type type : Type.values()) {
                BY_ID.put(type.id, type);
            }
        }
    }
}

