/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import org.cloudburstmc.protocol.bedrock.packet.SetPlayerGameTypePacket;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerSpawnInfo;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundRespawnPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundPlayerLoadedPacket;

@Translator(packet=ClientboundRespawnPacket.class)
public class JavaRespawnTranslator
extends PacketTranslator<ClientboundRespawnPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundRespawnPacket packet) {
        SessionPlayerEntity entity = session.getPlayerEntity();
        PlayerSpawnInfo spawnInfo = packet.getCommonPlayerSpawnInfo();
        if (!packet.isKeepMetadata()) {
            entity.resetMetadata();
        }
        if (!packet.isKeepAttributeModifiers()) {
            entity.resetAttributes();
        }
        session.setSpawned(false);
        entity.setHealth(entity.getMaxHealth());
        entity.getAttributes().put(GeyserAttributeType.HEALTH, entity.createHealthAttribute());
        session.setOpenInventory(null);
        session.setClosingInventory(false);
        entity.setLastDeathPosition(spawnInfo.getLastDeathPos());
        entity.updateBedrockMetadata();
        SetPlayerGameTypePacket playerGameTypePacket = new SetPlayerGameTypePacket();
        playerGameTypePacket.setGamemode(EntityUtils.toBedrockGamemode(spawnInfo.getGameMode()).ordinal());
        session.sendUpstreamPacket(playerGameTypePacket);
        session.setGameMode(spawnInfo.getGameMode());
        if (session.isRaining()) {
            session.updateRain(0.0f);
        }
        if (session.isThunder()) {
            session.updateThunder(0.0f);
        }
        JavaDimension newDimension = session.getRegistryCache().registry(JavaRegistries.DIMENSION_TYPE).byId(spawnInfo.getDimension());
        if (session.getDimensionType() != newDimension || !spawnInfo.getWorldName().equals(session.getWorldName())) {
            if (session.getDimensionType().bedrockId() == newDimension.bedrockId()) {
                int fakeDim = DimensionUtils.getTemporaryDimension(session.getDimensionType().bedrockId(), newDimension.bedrockId());
                DimensionUtils.fastSwitchDimension(session, fakeDim);
            }
            session.setWorldName(spawnInfo.getWorldName());
            session.setWorldTicks(0L);
            DimensionUtils.switchDimension(session, newDimension);
            ChunkUtils.loadDimension(session);
        }
        session.sendDownstreamGamePacket(ServerboundPlayerLoadedPacket.INSTANCE);
    }
}

