/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.ModalFormResponsePacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.geysermc.cumulus.component.Component;
import org.geysermc.cumulus.component.util.ComponentType;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.impl.FormDefinition;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.session.GeyserSession;

public class FormCache {
    private static final Gson GSON_TEMP = new Gson();
    private static final long MAGIC_FORM_IMAGE_HACK_TIMESTAMP = -1234567890L;
    private final FormDefinitions formDefinitions = FormDefinitions.instance();
    private final AtomicInteger formIdCounter = new AtomicInteger(0);
    private final Int2ObjectMap<Form> forms = new Int2ObjectOpenHashMap<Form>();
    private final GeyserSession session;

    public int addForm(Form form) {
        int formId = this.formIdCounter.getAndIncrement();
        this.forms.put(formId, form);
        return formId;
    }

    public void showForm(Form form) {
        int formId = this.addForm(form);
        if (this.session.getUpstream().isInitialized()) {
            this.sendForm(formId, form);
        }
    }

    private void sendForm(int formId, Form form) {
        String jsonData = this.formDefinitions.codecFor(form).jsonData((Form)form);
        ModalFormRequestPacket formRequestPacket = new ModalFormRequestPacket();
        formRequestPacket.setFormId(formId);
        formRequestPacket.setFormData(jsonData);
        this.session.sendUpstreamPacket(formRequestPacket);
        if (form instanceof SimpleForm) {
            NetworkStackLatencyPacket latencyPacket = new NetworkStackLatencyPacket();
            latencyPacket.setFromServer(true);
            latencyPacket.setTimestamp(-1234567890L);
            this.session.scheduleInEventLoop(() -> this.session.sendUpstreamPacket(latencyPacket), 500L, TimeUnit.MILLISECONDS);
        }
    }

    public void resendAllForms() {
        for (Int2ObjectMap.Entry entry : this.forms.int2ObjectEntrySet()) {
            this.sendForm(entry.getIntKey(), (Form)entry.getValue());
        }
    }

    public void handleResponse(ModalFormResponsePacket response) {
        Form form = (Form)this.forms.remove(response.getFormId());
        if (form == null) {
            return;
        }
        String responseData = response.getFormData();
        if (form instanceof CustomForm) {
            CustomForm customForm = (CustomForm)form;
            if (GameProtocol.is1_21_70orHigher(this.session)) {
                IntArrayList labelIndexes = new IntArrayList();
                for (int i = 0; i < customForm.content().size(); ++i) {
                    Component component = customForm.content().get(i);
                    if (component == null || component.type() != ComponentType.LABEL) continue;
                    labelIndexes.add(i);
                }
                if (!labelIndexes.isEmpty()) {
                    if (responseData.startsWith("null")) {
                        ArrayList<Object> newResponse = new ArrayList<Object>();
                        for (int i = 0; i < labelIndexes.size(); ++i) {
                            newResponse.add(null);
                        }
                        responseData = GSON_TEMP.toJson(newResponse);
                    } else {
                        JsonArray responseDataArray = (JsonArray)GSON_TEMP.fromJson(responseData, JsonArray.class);
                        ArrayList<JsonElement> newResponse = new ArrayList<JsonElement>();
                        int handledLabelCount = 0;
                        for (int i = 0; i < responseDataArray.size() + labelIndexes.size(); ++i) {
                            if (labelIndexes.contains(i)) {
                                newResponse.add(null);
                                ++handledLabelCount;
                                continue;
                            }
                            newResponse.add(responseDataArray.get(i - handledLabelCount));
                        }
                        responseData = GSON_TEMP.toJson(newResponse);
                    }
                }
            }
        }
        try {
            ((FormDefinition)this.formDefinitions.definitionFor(form)).handleFormResponse((Form)form, responseData);
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Error while processing form response!", e);
        }
    }

    public FormCache(GeyserSession session) {
        this.session = session;
    }
}

