/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties.type;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.geysermc.geyser.api.entity.property.type.GeyserEnumEntityProperty;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.properties.type.AbstractEnumProperty;

public final class EnumProperty<E extends Enum<E>>
extends Record
implements AbstractEnumProperty<E>,
GeyserEnumEntityProperty<E> {
    private final Identifier identifier;
    private final Class<E> enumClass;
    private final E defaultValue;

    public EnumProperty(Identifier identifier, Class<E> enumClass, E defaultValue) {
        this.validateAllValues(identifier, Arrays.stream((Enum[])enumClass.getEnumConstants()).map(value -> value.name().toLowerCase(Locale.ROOT)).toList());
        this.identifier = identifier;
        this.enumClass = enumClass;
        this.defaultValue = defaultValue;
    }

    public List<E> values() {
        return List.of((Enum[])this.enumClass.getEnumConstants());
    }

    @Override
    public List<String> allBedrockValues() {
        return this.values().stream().map(value -> value.name().toLowerCase(Locale.ROOT)).toList();
    }

    @Override
    public int indexOf(E value) {
        return ((Enum)value).ordinal();
    }

    @Override
    public int defaultIndex() {
        return ((Enum)this.defaultValue).ordinal();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnumProperty.class, "identifier;enumClass;defaultValue", "identifier", "enumClass", "defaultValue"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnumProperty.class, "identifier;enumClass;defaultValue", "identifier", "enumClass", "defaultValue"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnumProperty.class, "identifier;enumClass;defaultValue", "identifier", "enumClass", "defaultValue"}, this, o);
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    public Class<E> enumClass() {
        return this.enumClass;
    }

    @Override
    public E defaultValue() {
        return this.defaultValue;
    }
}

