/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.command;

import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.platform.spigot.PaperAdventure;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import org.geysermc.geyser.text.GeyserLocale;

public class SpigotCommandSource
implements GeyserCommandSource {
    private final CommandSender handle;

    public SpigotCommandSource(CommandSender handle) {
        this.handle = handle;
        GeyserLocale.loadGeyserLocale(this.locale());
    }

    @Override
    public String name() {
        return this.handle.getName();
    }

    @Override
    public void sendMessage(@NonNull String message) {
        this.handle.sendMessage(message);
    }

    @Override
    public void sendMessage(Component message) {
        if (PaperAdventure.canSendMessageUsingComponent()) {
            PaperAdventure.sendMessage(this.handle, message);
            return;
        }
        this.handle.spigot().sendMessage(BungeeComponentSerializer.get().serialize(message));
    }

    @Override
    public Object handle() {
        return this.handle;
    }

    @Override
    public boolean isConsole() {
        return this.handle instanceof ConsoleCommandSender || this.handle instanceof RemoteConsoleCommandSender;
    }

    @Override
    public @Nullable UUID playerUuid() {
        CommandSender commandSender = this.handle;
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            return player.getUniqueId();
        }
        return null;
    }

    @Override
    public String locale() {
        CommandSender commandSender = this.handle;
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            return player.getLocale();
        }
        return GeyserLocale.getDefaultLocale();
    }

    @Override
    public boolean hasPermission(String permission) {
        return permission.isBlank() || this.handle.hasPermission(permission);
    }
}

