/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.registry;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.RegistryEntryData;

public class SimpleJavaRegistry<T>
implements JavaRegistry<T> {
    protected final ObjectArrayList<RegistryEntryData<T>> values = new ObjectArrayList();

    @Override
    public T byId(@NonNegative int id) {
        if (id < 0 || id >= this.values.size()) {
            return null;
        }
        return ((RegistryEntryData)this.values.get(id)).data();
    }

    @Override
    public RegistryEntryData<T> entryById(@NonNegative int id) {
        if (id < 0 || id >= this.values.size()) {
            return null;
        }
        return (RegistryEntryData)this.values.get(id);
    }

    @Override
    public T byKey(Key key) {
        for (RegistryEntryData entry : this.values) {
            if (!entry.key().equals(key)) continue;
            return entry.data();
        }
        return null;
    }

    @Override
    public @Nullable RegistryEntryData<T> entryByKey(Key key) {
        for (RegistryEntryData entry : this.values) {
            if (!entry.key().equals(key)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public int byValue(T value) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!((RegistryEntryData)this.values.get(i)).data().equals(value)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public RegistryEntryData<T> entryByValue(T value) {
        for (RegistryEntryData entry : this.values) {
            if (!entry.data().equals(value)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void reset(List<RegistryEntryData<T>> values) {
        this.values.clear();
        this.values.addAll(values);
        this.values.trim();
    }

    @Override
    public List<Key> keys() {
        return this.values.stream().map(RegistryEntryData::key).toList();
    }

    @Override
    public List<T> values() {
        return this.values.stream().map(RegistryEntryData::data).toList();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public String toString() {
        return this.values.toString();
    }
}

