/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.io;

import io.jsonwebtoken.impl.io.FilteredInputStream;
import io.jsonwebtoken.io.DecodingException;
import io.jsonwebtoken.lang.Assert;
import java.io.InputStream;

public class DecodingInputStream
extends FilteredInputStream {
    private final String codecName;
    private final String name;

    public DecodingInputStream(InputStream in, String codecName, String name) {
        super(in);
        this.codecName = Assert.hasText(codecName, "codecName cannot be null or empty.");
        this.name = Assert.hasText(name, "Name cannot be null or empty.");
    }

    @Override
    protected void onThrowable(Throwable t2) {
        String msg = "Unable to " + this.codecName + "-decode " + this.name + ": " + t2.getMessage();
        throw new DecodingException(msg, t2);
    }
}

