/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.bukkit;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.cloudburstmc.math.vector.Vector3i;

public final class BukkitUtils {
    private static final boolean CAN_USE_PAPER_BLOCK_STATE;

    public static Vector3i getVector(Location location) {
        return Vector3i.from(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static String getCraftBukkitPackage() {
        return Bukkit.getServer().getClass().getPackage().getName();
    }

    public static String getLegacyNmsPackage() {
        return BukkitUtils.getCraftBukkitPackage().replace("org.bukkit.craftbukkit", "net.minecraft.server");
    }

    public static boolean invalidDistance(Player player, Vector3i pos) {
        return BukkitUtils.invalidDistance(player, pos.getX(), pos.getZ());
    }

    public static boolean invalidDistance(Player player, int x, int z) {
        int viewDistance;
        int dZ;
        Location location = player.getLocation();
        int dX = Math.abs(x - location.getBlockX()) >> 4;
        return dX * dX + (dZ = Math.abs(z - location.getBlockZ()) >> 4) * dZ > (viewDistance = Bukkit.getViewDistance()) * viewDistance;
    }

    public static boolean invalidChunkDistance(Player player, int x, int z) {
        int viewDistance;
        int dZ;
        Location location = player.getLocation();
        int dX = Math.abs((x << 4) - location.getBlockX()) >> 4;
        return dX * dX + (dZ = Math.abs((z << 4) - location.getBlockZ()) >> 4) * dZ > (viewDistance = Bukkit.getViewDistance()) * viewDistance;
    }

    public static BlockState getBlockState(Block block) {
        if (CAN_USE_PAPER_BLOCK_STATE) {
            return block.getState(false);
        }
        return block.getState();
    }

    private BukkitUtils() {
    }

    static {
        boolean canUsePaperBlockState = false;
        try {
            Block.class.getMethod("getState", Boolean.TYPE);
            canUsePaperBlockState = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        CAN_USE_PAPER_BLOCK_STATE = canUsePaperBlockState;
    }
}

