/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.shaded.io.leangen.geantyref;

import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.geysermc.geyser.platform.spigot.shaded.io.leangen.geantyref.GenericTypeReflector;

public abstract class TypeToken<T> {
    private final AnnotatedType type;
    private volatile AnnotatedType canonical;

    protected TypeToken() {
        this.type = this.extractType();
    }

    private TypeToken(AnnotatedType type) {
        this.type = type;
    }

    public static <T> TypeToken<T> get(Class<T> type) {
        return new TypeToken<T>(GenericTypeReflector.annotate(type)){};
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken<Object>(GenericTypeReflector.annotate(type)){};
    }

    public Type getType() {
        return this.type.getType();
    }

    public AnnotatedType getAnnotatedType() {
        return this.type;
    }

    public AnnotatedType getCanonicalType() {
        if (this.canonical == null) {
            this.canonical = GenericTypeReflector.toCanonical(this.type);
        }
        return this.canonical;
    }

    private AnnotatedType extractType() {
        AnnotatedType t2 = this.getClass().getAnnotatedSuperclass();
        if (!(t2 instanceof AnnotatedParameterizedType)) {
            throw new RuntimeException("Invalid TypeToken; must specify type parameters");
        }
        AnnotatedParameterizedType pt = (AnnotatedParameterizedType)t2;
        if (((ParameterizedType)pt.getType()).getRawType() != TypeToken.class) {
            throw new RuntimeException("Invalid TypeToken; must directly extend TypeToken");
        }
        return pt.getAnnotatedActualTypeArguments()[0];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof TypeToken && this.getCanonicalType().equals(((TypeToken)obj).type);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }
}

